/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongoImportConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.net.UnknownHostException;

public class MongoImportConfigBuilder
extends AbstractMongoConfigBuilder<IMongoImportConfig> {
    protected static final TypedProperty<String> DB_NAME = TypedProperty.with((String)"db", String.class);
    protected static final TypedProperty<String> IMPORT_FILE = TypedProperty.with((String)"file", String.class);
    protected static final TypedProperty<String> COLLECTION = TypedProperty.with((String)"collection", String.class);
    protected static final TypedProperty<String> TYPE = TypedProperty.with((String)"type", String.class);
    protected static final TypedProperty<Boolean> HEADERLINE = TypedProperty.with((String)"headerline", Boolean.class);
    protected static final TypedProperty<Boolean> JSON_ARRAY = TypedProperty.with((String)"jsonArray", Boolean.class);
    protected static final TypedProperty<Boolean> UPSERT = TypedProperty.with((String)"upsert", Boolean.class);
    protected static final TypedProperty<Boolean> DROP = TypedProperty.with((String)"drop", Boolean.class);

    public MongoImportConfigBuilder() throws UnknownHostException, IOException {
        this.property(PID_FILE).setDefault((Object)"mongoimport.pid");
        this.property(TYPE).setDefault((Object)"json");
        this.property(HEADERLINE).setDefault((Object)Boolean.FALSE);
    }

    public MongoImportConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set((Object)version);
        return this;
    }

    public MongoImportConfigBuilder timeout(Timeout timeout) {
        this.timeout().set((Object)timeout);
        return this;
    }

    public MongoImportConfigBuilder net(Net net) {
        this.net().set((Object)net);
        return this;
    }

    public MongoImportConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set((Object)cmdOptions);
        return this;
    }

    public MongoImportConfigBuilder importFile(String importFile) {
        this.set(IMPORT_FILE, importFile);
        return this;
    }

    public MongoImportConfigBuilder db(String dbName) {
        this.set(DB_NAME, dbName);
        return this;
    }

    public MongoImportConfigBuilder collection(String collection) {
        this.set(COLLECTION, collection);
        return this;
    }

    public MongoImportConfigBuilder type(String type) {
        this.set(TYPE, type);
        return this;
    }

    public MongoImportConfigBuilder headerline(boolean headerline) {
        this.set(HEADERLINE, headerline);
        return this;
    }

    public MongoImportConfigBuilder jsonArray(boolean jsonArray) {
        this.set(JSON_ARRAY, jsonArray);
        return this;
    }

    public MongoImportConfigBuilder upsert(boolean upsert) {
        this.set(UPSERT, upsert);
        return this;
    }

    public MongoImportConfigBuilder dropCollection(boolean dropCollection) {
        this.set(DROP, dropCollection);
        return this;
    }

    public IMongoImportConfig build() {
        IFeatureAwareVersion version = (IFeatureAwareVersion)this.version().get();
        Net net = (Net)this.net().get();
        Timeout timeout = (Timeout)this.timeout().get();
        String database = (String)this.get(DB_NAME);
        String collection = (String)this.get(COLLECTION);
        String importFile = (String)this.get(IMPORT_FILE);
        String type = (String)this.get(TYPE);
        Boolean headerline = (Boolean)this.get(HEADERLINE);
        Boolean jsonArray = (Boolean)this.get(JSON_ARRAY);
        Boolean upsert = (Boolean)this.get(UPSERT);
        Boolean drop = (Boolean)this.get(DROP);
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        String pidFile = (String)this.get(PID_FILE);
        return new ImmutableMongoImportConfig(version, net, timeout, cmdOptions, pidFile, database, collection, importFile, type, headerline, jsonArray, upsert, drop);
    }

    static class ImmutableMongoImportConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongoImportConfig {
        private final String _databaseName;
        private final String _getImportFile;
        private final String _collectionName;
        private final String _type;
        private final boolean _headerline;
        private final boolean _jsonArray;
        private final boolean _dropCollection;
        private final boolean _upsetDocuments;

        public ImmutableMongoImportConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, String database, String collection, String importFile, String type, boolean headerline, boolean jsonArray, boolean upsert, boolean drop) {
            super(new SupportConfig(Command.MongoImport), version, net, null, null, timeout, cmdOptions, pidFile);
            this._databaseName = database;
            this._collectionName = collection;
            this._getImportFile = importFile;
            this._jsonArray = jsonArray;
            this._dropCollection = drop;
            this._upsetDocuments = upsert;
            this._type = type;
            this._headerline = headerline;
        }

        @Override
        public String getDatabaseName() {
            return this._databaseName;
        }

        @Override
        public String getCollectionName() {
            return this._collectionName;
        }

        @Override
        public String getImportFile() {
            return this._getImportFile;
        }

        @Override
        public String getType() {
            return this._type;
        }

        @Override
        public boolean isHeaderline() {
            return this._headerline;
        }

        @Override
        public boolean isJsonArray() {
            return this._jsonArray;
        }

        @Override
        public boolean isDropCollection() {
            return this._dropCollection;
        }

        @Override
        public boolean isUpsertDocuments() {
            return this._upsetDocuments;
        }
    }
}

