package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ZoneMinuteCountDataExample extends BaseExample {

    public ZoneMinuteCountDataExample() {
        super();
        tableName = "d_zone_minute_count_data";
        tableAlias = "zoneMinute";
        ignoreCase = false;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public FloorExample.ColumnContainer createFloorColumns() {
        FloorExample floorExample = new FloorExample();
        FloorExample.ColumnContainer columnContainer = (FloorExample.ColumnContainer) columnContainerMap.get(floorExample.getTableName());
         if(columnContainer == null){
            columnContainer = floorExample.createColumns();
            columnContainerMap.put(floorExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public FloorExample.Criteria andFloorCriteria() {
        FloorExample floorExample = new FloorExample();
        FloorExample.Criteria criteria = floorExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public FloorExample.Criteria orFloorCriteria() {
        FloorExample floorExample = new FloorExample();
        FloorExample.Criteria criteria = floorExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public FloorExample.Criteria andFloorCriteria(Criteria criteria) {
        FloorExample floorExample = new FloorExample();
        FloorExample.Criteria newCriteria = floorExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public ZoneExample.ColumnContainer createZoneColumns() {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.ColumnContainer columnContainer = (ZoneExample.ColumnContainer) columnContainerMap.get(zoneExample.getTableName());
         if(columnContainer == null){
            columnContainer = zoneExample.createColumns();
            columnContainerMap.put(zoneExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public ZoneExample.Criteria andZoneCriteria() {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.Criteria criteria = zoneExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public ZoneExample.Criteria orZoneCriteria() {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.Criteria criteria = zoneExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public ZoneExample.Criteria andZoneCriteria(Criteria criteria) {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.Criteria newCriteria = zoneExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_zone_minute_count_data";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"zoneMinute\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"zoneMinute\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"zoneMinute\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"zoneMinute\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"zoneMinute\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"zoneMinute\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"zoneMinute\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"zoneMinute\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"zoneMinute\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"zoneMinute\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"zoneMinute\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"zoneMinute\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"zoneMinute\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"zoneMinute\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"zoneMinute\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"zoneMinute\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"zoneMinute\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"zoneMinute\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"zoneMinute\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"zoneMinute\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"zoneMinute\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"zoneMinute\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"zoneMinute\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"zoneMinute\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andFloorIdIsNull() {
            addCriterion("\"zoneMinute\".floor_id is null");
            return (Criteria) this;
        }

        public Criteria andFloorIdIsNotNull() {
            addCriterion("\"zoneMinute\".floor_id is not null");
            return (Criteria) this;
        }

        public Criteria andFloorIdEqualTo(Long value) {
            addCriterion("\"zoneMinute\".floor_id =", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdNotEqualTo(Long value) {
            addCriterion("\"zoneMinute\".floor_id <>", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdGreaterThan(Long value) {
            addCriterion("\"zoneMinute\".floor_id >", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".floor_id >=", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdLessThan(Long value) {
            addCriterion("\"zoneMinute\".floor_id <", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".floor_id <=", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdIn(List<Long> values) {
            addCriterion("\"zoneMinute\".floor_id in", values, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdNotIn(List<Long> values) {
            addCriterion("\"zoneMinute\".floor_id not in", values, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".floor_id between", value1, value2, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".floor_id not between", value1, value2, "floorId");
            return (Criteria) this;
        }

        public Criteria andZoneIdIsNull() {
            addCriterion("\"zoneMinute\".zone_id is null");
            return (Criteria) this;
        }

        public Criteria andZoneIdIsNotNull() {
            addCriterion("\"zoneMinute\".zone_id is not null");
            return (Criteria) this;
        }

        public Criteria andZoneIdEqualTo(Long value) {
            addCriterion("\"zoneMinute\".zone_id =", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdNotEqualTo(Long value) {
            addCriterion("\"zoneMinute\".zone_id <>", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdGreaterThan(Long value) {
            addCriterion("\"zoneMinute\".zone_id >", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".zone_id >=", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdLessThan(Long value) {
            addCriterion("\"zoneMinute\".zone_id <", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneMinute\".zone_id <=", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdIn(List<Long> values) {
            addCriterion("\"zoneMinute\".zone_id in", values, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdNotIn(List<Long> values) {
            addCriterion("\"zoneMinute\".zone_id not in", values, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".zone_id between", value1, value2, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneMinute\".zone_id not between", value1, value2, "zoneId");
            return (Criteria) this;
        }

        public Criteria andInnumIsNull() {
            addCriterion("\"zoneMinute\".innum is null");
            return (Criteria) this;
        }

        public Criteria andInnumIsNotNull() {
            addCriterion("\"zoneMinute\".innum is not null");
            return (Criteria) this;
        }

        public Criteria andInnumEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".innum =", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".innum <>", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumGreaterThan(Integer value) {
            addCriterion("\"zoneMinute\".innum >", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".innum >=", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumLessThan(Integer value) {
            addCriterion("\"zoneMinute\".innum <", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".innum <=", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".innum in", values, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".innum not in", values, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".innum between", value1, value2, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".innum not between", value1, value2, "innum");
            return (Criteria) this;
        }

        public Criteria andOutnumIsNull() {
            addCriterion("\"zoneMinute\".outnum is null");
            return (Criteria) this;
        }

        public Criteria andOutnumIsNotNull() {
            addCriterion("\"zoneMinute\".outnum is not null");
            return (Criteria) this;
        }

        public Criteria andOutnumEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outnum =", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outnum <>", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumGreaterThan(Integer value) {
            addCriterion("\"zoneMinute\".outnum >", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outnum >=", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumLessThan(Integer value) {
            addCriterion("\"zoneMinute\".outnum <", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outnum <=", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".outnum in", values, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".outnum not in", values, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".outnum between", value1, value2, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".outnum not between", value1, value2, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumIsNull() {
            addCriterion("\"zoneMinute\".outside_innum is null");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumIsNotNull() {
            addCriterion("\"zoneMinute\".outside_innum is not null");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_innum =", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumNotEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_innum <>", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumGreaterThan(Integer value) {
            addCriterion("\"zoneMinute\".outside_innum >", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_innum >=", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumLessThan(Integer value) {
            addCriterion("\"zoneMinute\".outside_innum <", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_innum <=", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".outside_innum in", values, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumNotIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".outside_innum not in", values, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".outside_innum between", value1, value2, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".outside_innum not between", value1, value2, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumIsNull() {
            addCriterion("\"zoneMinute\".outside_outnum is null");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumIsNotNull() {
            addCriterion("\"zoneMinute\".outside_outnum is not null");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_outnum =", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumNotEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_outnum <>", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumGreaterThan(Integer value) {
            addCriterion("\"zoneMinute\".outside_outnum >", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_outnum >=", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumLessThan(Integer value) {
            addCriterion("\"zoneMinute\".outside_outnum <", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneMinute\".outside_outnum <=", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".outside_outnum in", values, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumNotIn(List<Integer> values) {
            addCriterion("\"zoneMinute\".outside_outnum not in", values, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".outside_outnum between", value1, value2, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneMinute\".outside_outnum not between", value1, value2, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"zoneMinute\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"zoneMinute\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"zoneMinute\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"zoneMinute\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"zoneMinute\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"zoneMinute\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"zoneMinute\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"zoneMinute\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"zoneMinute\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"zoneMinute\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"zoneMinute\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"zoneMinute\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"zoneMinute\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"zoneMinute\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"zoneMinute\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"zoneMinute\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"zoneMinute\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"zoneMinute\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"zoneMinute\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"zoneMinute\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"zoneMinute\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"zoneMinute\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"zoneMinute\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"zoneMinute\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"zoneMinute\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"zoneMinute\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"zoneMinute\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"zoneMinute\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"zoneMinute\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"zoneMinute\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"zoneMinute\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"zoneMinute\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"zoneMinute\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"zoneMinute\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"zoneMinute\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"zoneMinute\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"zoneMinute\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"zoneMinute\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"zoneMinute\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andHourIsNull() {
            addCriterion("\"zoneMinute\".\"hour\" is null");
            return (Criteria) this;
        }

        public Criteria andHourIsNotNull() {
            addCriterion("\"zoneMinute\".\"hour\" is not null");
            return (Criteria) this;
        }

        public Criteria andHourEqualTo(Short value) {
            addCriterion("\"zoneMinute\".\"hour\" =", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotEqualTo(Short value) {
            addCriterion("\"zoneMinute\".\"hour\" <>", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourGreaterThan(Short value) {
            addCriterion("\"zoneMinute\".\"hour\" >", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourGreaterThanOrEqualTo(Short value) {
            addCriterion("\"zoneMinute\".\"hour\" >=", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourLessThan(Short value) {
            addCriterion("\"zoneMinute\".\"hour\" <", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourLessThanOrEqualTo(Short value) {
            addCriterion("\"zoneMinute\".\"hour\" <=", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourIn(List<Short> values) {
            addCriterion("\"zoneMinute\".\"hour\" in", values, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotIn(List<Short> values) {
            addCriterion("\"zoneMinute\".\"hour\" not in", values, "hour");
            return (Criteria) this;
        }

        public Criteria andHourBetween(Short value1, Short value2) {
            addCriterion("\"zoneMinute\".\"hour\" between", value1, value2, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotBetween(Short value1, Short value2) {
            addCriterion("\"zoneMinute\".\"hour\" not between", value1, value2, "hour");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"zoneMinute\".id as zoneMinute_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"zoneMinute\".mall_id as zoneMinute_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"zoneMinute\".account_id as zoneMinute_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFloorIdColumn() {
            addColumnStr("\"zoneMinute\".floor_id as zoneMinute_floor_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasZoneIdColumn() {
            addColumnStr("\"zoneMinute\".zone_id as zoneMinute_zone_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasInnumColumn() {
            addColumnStr("\"zoneMinute\".innum as zoneMinute_innum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutnumColumn() {
            addColumnStr("\"zoneMinute\".outnum as zoneMinute_outnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutsideInnumColumn() {
            addColumnStr("\"zoneMinute\".outside_innum as zoneMinute_outside_innum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutsideOutnumColumn() {
            addColumnStr("\"zoneMinute\".outside_outnum as zoneMinute_outside_outnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"zoneMinute\".counttime as zoneMinute_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"zoneMinute\".countdate as zoneMinute_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"zoneMinute\".modify_time as zoneMinute_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"zoneMinute\".create_time as zoneMinute_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHourColumn() {
            addColumnStr("\"zoneMinute\".\"hour\" as \"zoneMinute_hour\" ");
            return (ColumnContainer) this;
        }
    }
}