package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ZoneDayCountDataExample extends BaseExample {

    public ZoneDayCountDataExample() {
        super();
        tableName = "d_zone_day_count_data";
        tableAlias = "zoneDay";
        ignoreCase = false;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public FloorExample.ColumnContainer createFloorColumns() {
        FloorExample floorExample = new FloorExample();
        FloorExample.ColumnContainer columnContainer = (FloorExample.ColumnContainer) columnContainerMap.get(floorExample.getTableName());
         if(columnContainer == null){
            columnContainer = floorExample.createColumns();
            columnContainerMap.put(floorExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public FloorExample.Criteria andFloorCriteria() {
        FloorExample floorExample = new FloorExample();
        FloorExample.Criteria criteria = floorExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public FloorExample.Criteria orFloorCriteria() {
        FloorExample floorExample = new FloorExample();
        FloorExample.Criteria criteria = floorExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public FloorExample.Criteria andFloorCriteria(Criteria criteria) {
        FloorExample floorExample = new FloorExample();
        FloorExample.Criteria newCriteria = floorExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public ZoneExample.ColumnContainer createZoneColumns() {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.ColumnContainer columnContainer = (ZoneExample.ColumnContainer) columnContainerMap.get(zoneExample.getTableName());
         if(columnContainer == null){
            columnContainer = zoneExample.createColumns();
            columnContainerMap.put(zoneExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public ZoneExample.Criteria andZoneCriteria() {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.Criteria criteria = zoneExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public ZoneExample.Criteria orZoneCriteria() {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.Criteria criteria = zoneExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public ZoneExample.Criteria andZoneCriteria(Criteria criteria) {
        ZoneExample zoneExample = new ZoneExample();
        ZoneExample.Criteria newCriteria = zoneExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_zone_day_count_data";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"zoneDay\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"zoneDay\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"zoneDay\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"zoneDay\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"zoneDay\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"zoneDay\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"zoneDay\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"zoneDay\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"zoneDay\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"zoneDay\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"zoneDay\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"zoneDay\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"zoneDay\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"zoneDay\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"zoneDay\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"zoneDay\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"zoneDay\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"zoneDay\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"zoneDay\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"zoneDay\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"zoneDay\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"zoneDay\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"zoneDay\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"zoneDay\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andFloorIdIsNull() {
            addCriterion("\"zoneDay\".floor_id is null");
            return (Criteria) this;
        }

        public Criteria andFloorIdIsNotNull() {
            addCriterion("\"zoneDay\".floor_id is not null");
            return (Criteria) this;
        }

        public Criteria andFloorIdEqualTo(Long value) {
            addCriterion("\"zoneDay\".floor_id =", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdNotEqualTo(Long value) {
            addCriterion("\"zoneDay\".floor_id <>", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdGreaterThan(Long value) {
            addCriterion("\"zoneDay\".floor_id >", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".floor_id >=", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdLessThan(Long value) {
            addCriterion("\"zoneDay\".floor_id <", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".floor_id <=", value, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdIn(List<Long> values) {
            addCriterion("\"zoneDay\".floor_id in", values, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdNotIn(List<Long> values) {
            addCriterion("\"zoneDay\".floor_id not in", values, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".floor_id between", value1, value2, "floorId");
            return (Criteria) this;
        }

        public Criteria andFloorIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".floor_id not between", value1, value2, "floorId");
            return (Criteria) this;
        }

        public Criteria andZoneIdIsNull() {
            addCriterion("\"zoneDay\".zone_id is null");
            return (Criteria) this;
        }

        public Criteria andZoneIdIsNotNull() {
            addCriterion("\"zoneDay\".zone_id is not null");
            return (Criteria) this;
        }

        public Criteria andZoneIdEqualTo(Long value) {
            addCriterion("\"zoneDay\".zone_id =", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdNotEqualTo(Long value) {
            addCriterion("\"zoneDay\".zone_id <>", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdGreaterThan(Long value) {
            addCriterion("\"zoneDay\".zone_id >", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".zone_id >=", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdLessThan(Long value) {
            addCriterion("\"zoneDay\".zone_id <", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdLessThanOrEqualTo(Long value) {
            addCriterion("\"zoneDay\".zone_id <=", value, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdIn(List<Long> values) {
            addCriterion("\"zoneDay\".zone_id in", values, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdNotIn(List<Long> values) {
            addCriterion("\"zoneDay\".zone_id not in", values, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".zone_id between", value1, value2, "zoneId");
            return (Criteria) this;
        }

        public Criteria andZoneIdNotBetween(Long value1, Long value2) {
            addCriterion("\"zoneDay\".zone_id not between", value1, value2, "zoneId");
            return (Criteria) this;
        }

        public Criteria andInnumIsNull() {
            addCriterion("\"zoneDay\".innum is null");
            return (Criteria) this;
        }

        public Criteria andInnumIsNotNull() {
            addCriterion("\"zoneDay\".innum is not null");
            return (Criteria) this;
        }

        public Criteria andInnumEqualTo(Integer value) {
            addCriterion("\"zoneDay\".innum =", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotEqualTo(Integer value) {
            addCriterion("\"zoneDay\".innum <>", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumGreaterThan(Integer value) {
            addCriterion("\"zoneDay\".innum >", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".innum >=", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumLessThan(Integer value) {
            addCriterion("\"zoneDay\".innum <", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".innum <=", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumIn(List<Integer> values) {
            addCriterion("\"zoneDay\".innum in", values, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotIn(List<Integer> values) {
            addCriterion("\"zoneDay\".innum not in", values, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".innum between", value1, value2, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".innum not between", value1, value2, "innum");
            return (Criteria) this;
        }

        public Criteria andOutnumIsNull() {
            addCriterion("\"zoneDay\".outnum is null");
            return (Criteria) this;
        }

        public Criteria andOutnumIsNotNull() {
            addCriterion("\"zoneDay\".outnum is not null");
            return (Criteria) this;
        }

        public Criteria andOutnumEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outnum =", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outnum <>", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumGreaterThan(Integer value) {
            addCriterion("\"zoneDay\".outnum >", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outnum >=", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumLessThan(Integer value) {
            addCriterion("\"zoneDay\".outnum <", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outnum <=", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumIn(List<Integer> values) {
            addCriterion("\"zoneDay\".outnum in", values, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotIn(List<Integer> values) {
            addCriterion("\"zoneDay\".outnum not in", values, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".outnum between", value1, value2, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".outnum not between", value1, value2, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumIsNull() {
            addCriterion("\"zoneDay\".outside_innum is null");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumIsNotNull() {
            addCriterion("\"zoneDay\".outside_innum is not null");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_innum =", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumNotEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_innum <>", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumGreaterThan(Integer value) {
            addCriterion("\"zoneDay\".outside_innum >", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_innum >=", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumLessThan(Integer value) {
            addCriterion("\"zoneDay\".outside_innum <", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_innum <=", value, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumIn(List<Integer> values) {
            addCriterion("\"zoneDay\".outside_innum in", values, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumNotIn(List<Integer> values) {
            addCriterion("\"zoneDay\".outside_innum not in", values, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".outside_innum between", value1, value2, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideInnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".outside_innum not between", value1, value2, "outsideInnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumIsNull() {
            addCriterion("\"zoneDay\".outside_outnum is null");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumIsNotNull() {
            addCriterion("\"zoneDay\".outside_outnum is not null");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_outnum =", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumNotEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_outnum <>", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumGreaterThan(Integer value) {
            addCriterion("\"zoneDay\".outside_outnum >", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_outnum >=", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumLessThan(Integer value) {
            addCriterion("\"zoneDay\".outside_outnum <", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"zoneDay\".outside_outnum <=", value, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumIn(List<Integer> values) {
            addCriterion("\"zoneDay\".outside_outnum in", values, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumNotIn(List<Integer> values) {
            addCriterion("\"zoneDay\".outside_outnum not in", values, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".outside_outnum between", value1, value2, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andOutsideOutnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"zoneDay\".outside_outnum not between", value1, value2, "outsideOutnum");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"zoneDay\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"zoneDay\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"zoneDay\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"zoneDay\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"zoneDay\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"zoneDay\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"zoneDay\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"zoneDay\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"zoneDay\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"zoneDay\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"zoneDay\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"zoneDay\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"zoneDay\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"zoneDay\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneDay\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneDay\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"zoneDay\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneDay\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"zoneDay\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"zoneDay\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"zoneDay\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"zoneDay\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"zoneDay\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"zoneDay\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"zoneDay\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"zoneDay\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"zoneDay\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"zoneDay\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"zoneDay\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"zoneDay\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"zoneDay\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"zoneDay\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"zoneDay\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"zoneDay\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"zoneDay\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"zoneDay\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"zoneDay\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"zoneDay\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"zoneDay\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"zoneDay\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"zoneDay\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"zoneDay\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"zoneDay\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"zoneDay\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"zoneDay\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"zoneDay\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"zoneDay\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"zoneDay\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"zoneDay\".id as zoneDay_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"zoneDay\".mall_id as zoneDay_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"zoneDay\".account_id as zoneDay_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFloorIdColumn() {
            addColumnStr("\"zoneDay\".floor_id as zoneDay_floor_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasZoneIdColumn() {
            addColumnStr("\"zoneDay\".zone_id as zoneDay_zone_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasInnumColumn() {
            addColumnStr("\"zoneDay\".innum as zoneDay_innum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutnumColumn() {
            addColumnStr("\"zoneDay\".outnum as zoneDay_outnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutsideInnumColumn() {
            addColumnStr("\"zoneDay\".outside_innum as zoneDay_outside_innum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutsideOutnumColumn() {
            addColumnStr("\"zoneDay\".outside_outnum as zoneDay_outside_outnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"zoneDay\".counttime as zoneDay_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"zoneDay\".countdate as zoneDay_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"zoneDay\".modify_time as zoneDay_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"zoneDay\".create_time as zoneDay_create_time ");
            return (ColumnContainer) this;
        }
    }
}