package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.Date;
import java.util.List;

public class StaffFaceExample extends BaseExample {

    public StaffFaceExample() {
        super();
        tableName = "d_staff_face";
        tableAlias = "staffFace";
        ignoreCase = false;
    }

    public StaffExample.ColumnContainer createStaffColumns() {
        StaffExample staffExample = new StaffExample();
        StaffExample.ColumnContainer columnContainer = (StaffExample.ColumnContainer) columnContainerMap.get(staffExample.getTableName());
         if(columnContainer == null){
            columnContainer = staffExample.createColumns();
            columnContainerMap.put(staffExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public StaffExample.Criteria andStaffCriteria() {
        StaffExample staffExample = new StaffExample();
        StaffExample.Criteria criteria = staffExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public StaffExample.Criteria orStaffCriteria() {
        StaffExample staffExample = new StaffExample();
        StaffExample.Criteria criteria = staffExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public StaffExample.Criteria andStaffCriteria(Criteria criteria) {
        StaffExample staffExample = new StaffExample();
        StaffExample.Criteria newCriteria = staffExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public FaceRecognitionExample.ColumnContainer createFaceRecognitionColumns() {
        FaceRecognitionExample faceRecognitionExample = new FaceRecognitionExample();
        FaceRecognitionExample.ColumnContainer columnContainer = (FaceRecognitionExample.ColumnContainer) columnContainerMap.get(faceRecognitionExample.getTableName());
         if(columnContainer == null){
            columnContainer = faceRecognitionExample.createColumns();
            columnContainerMap.put(faceRecognitionExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public FaceRecognitionExample.Criteria andFaceRecognitionCriteria() {
        FaceRecognitionExample faceRecognitionExample = new FaceRecognitionExample();
        FaceRecognitionExample.Criteria criteria = faceRecognitionExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public FaceRecognitionExample.Criteria orFaceRecognitionCriteria() {
        FaceRecognitionExample faceRecognitionExample = new FaceRecognitionExample();
        FaceRecognitionExample.Criteria criteria = faceRecognitionExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public FaceRecognitionExample.Criteria andFaceRecognitionCriteria(Criteria criteria) {
        FaceRecognitionExample faceRecognitionExample = new FaceRecognitionExample();
        FaceRecognitionExample.Criteria newCriteria = faceRecognitionExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_staff_face";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("\"staffFace\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"staffFace\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"staffFace\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"staffFace\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"staffFace\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staffFace\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"staffFace\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staffFace\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"staffFace\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"staffFace\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"staffFace\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staffFace\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andStaffIdIsNull() {
            addCriterion("\"staffFace\".staff_id is null");
            return (Criteria) this;
        }

        public Criteria andStaffIdIsNotNull() {
            addCriterion("\"staffFace\".staff_id is not null");
            return (Criteria) this;
        }

        public Criteria andStaffIdEqualTo(Long value) {
            addCriterion("\"staffFace\".staff_id =", value, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdNotEqualTo(Long value) {
            addCriterion("\"staffFace\".staff_id <>", value, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdGreaterThan(Long value) {
            addCriterion("\"staffFace\".staff_id >", value, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staffFace\".staff_id >=", value, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdLessThan(Long value) {
            addCriterion("\"staffFace\".staff_id <", value, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staffFace\".staff_id <=", value, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdIn(List<Long> values) {
            addCriterion("\"staffFace\".staff_id in", values, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdNotIn(List<Long> values) {
            addCriterion("\"staffFace\".staff_id not in", values, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdBetween(Long value1, Long value2) {
            addCriterion("\"staffFace\".staff_id between", value1, value2, "staffId");
            return (Criteria) this;
        }

        public Criteria andStaffIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staffFace\".staff_id not between", value1, value2, "staffId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdIsNull() {
            addCriterion("\"staffFace\".recognition_id is null");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdIsNotNull() {
            addCriterion("\"staffFace\".recognition_id is not null");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdEqualTo(Long value) {
            addCriterion("\"staffFace\".recognition_id =", value, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdNotEqualTo(Long value) {
            addCriterion("\"staffFace\".recognition_id <>", value, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdGreaterThan(Long value) {
            addCriterion("\"staffFace\".recognition_id >", value, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staffFace\".recognition_id >=", value, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdLessThan(Long value) {
            addCriterion("\"staffFace\".recognition_id <", value, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staffFace\".recognition_id <=", value, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdIn(List<Long> values) {
            addCriterion("\"staffFace\".recognition_id in", values, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdNotIn(List<Long> values) {
            addCriterion("\"staffFace\".recognition_id not in", values, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdBetween(Long value1, Long value2) {
            addCriterion("\"staffFace\".recognition_id between", value1, value2, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andRecognitionIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staffFace\".recognition_id not between", value1, value2, "recognitionId");
            return (Criteria) this;
        }

        public Criteria andFeatureExtIsNull() {
            addCriterion("\"staffFace\".feature_ext is null");
            return (Criteria) this;
        }

        public Criteria andFeatureExtIsNotNull() {
            addCriterion("\"staffFace\".feature_ext is not null");
            return (Criteria) this;
        }

        public Criteria andFeatureExtEqualTo(String value) {
            addCriterion("\"staffFace\".feature_ext =", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtNotEqualTo(String value) {
            addCriterion("\"staffFace\".feature_ext <>", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtGreaterThan(String value) {
            addCriterion("\"staffFace\".feature_ext >", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtGreaterThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".feature_ext >=", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtLessThan(String value) {
            addCriterion("\"staffFace\".feature_ext <", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtLessThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".feature_ext <=", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtLike(String value) {
            addCriterion("\"staffFace\".feature_ext like", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtNotLike(String value) {
            addCriterion("\"staffFace\".feature_ext not like", value, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtIn(List<String> values) {
            addCriterion("\"staffFace\".feature_ext in", values, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtNotIn(List<String> values) {
            addCriterion("\"staffFace\".feature_ext not in", values, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtBetween(String value1, String value2) {
            addCriterion("\"staffFace\".feature_ext between", value1, value2, "featureExt");
            return (Criteria) this;
        }

        public Criteria andFeatureExtNotBetween(String value1, String value2) {
            addCriterion("\"staffFace\".feature_ext not between", value1, value2, "featureExt");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"staffFace\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"staffFace\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"staffFace\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"staffFace\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"staffFace\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"staffFace\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"staffFace\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"staffFace\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"staffFace\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"staffFace\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"staffFace\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"staffFace\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"staffFace\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"staffFace\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"staffFace\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"staffFace\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"staffFace\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"staffFace\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"staffFace\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"staffFace\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"staffFace\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"staffFace\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"staffFace\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"staffFace\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andFacePicIsNull() {
            addCriterion("\"staffFace\".face_pic is null");
            return (Criteria) this;
        }

        public Criteria andFacePicIsNotNull() {
            addCriterion("\"staffFace\".face_pic is not null");
            return (Criteria) this;
        }

        public Criteria andFacePicEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic =", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic <>", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicGreaterThan(String value) {
            addCriterion("\"staffFace\".face_pic >", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicGreaterThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic >=", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicLessThan(String value) {
            addCriterion("\"staffFace\".face_pic <", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicLessThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic <=", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicLike(String value) {
            addCriterion("\"staffFace\".face_pic like", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotLike(String value) {
            addCriterion("\"staffFace\".face_pic not like", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicIn(List<String> values) {
            addCriterion("\"staffFace\".face_pic in", values, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotIn(List<String> values) {
            addCriterion("\"staffFace\".face_pic not in", values, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicBetween(String value1, String value2) {
            addCriterion("\"staffFace\".face_pic between", value1, value2, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotBetween(String value1, String value2) {
            addCriterion("\"staffFace\".face_pic not between", value1, value2, "facePic");
            return (Criteria) this;
        }

        public Criteria andFeatureIsNull() {
            addCriterion("\"staffFace\".feature is null");
            return (Criteria) this;
        }

        public Criteria andFeatureIsNotNull() {
            addCriterion("\"staffFace\".feature is not null");
            return (Criteria) this;
        }

        public Criteria andFeatureEqualTo(String value) {
            addCriterion("\"staffFace\".feature =", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureNotEqualTo(String value) {
            addCriterion("\"staffFace\".feature <>", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureGreaterThan(String value) {
            addCriterion("\"staffFace\".feature >", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureGreaterThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".feature >=", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureLessThan(String value) {
            addCriterion("\"staffFace\".feature <", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureLessThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".feature <=", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureLike(String value) {
            addCriterion("\"staffFace\".feature like", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureNotLike(String value) {
            addCriterion("\"staffFace\".feature not like", value, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureIn(List<String> values) {
            addCriterion("\"staffFace\".feature in", values, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureNotIn(List<String> values) {
            addCriterion("\"staffFace\".feature not in", values, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureBetween(String value1, String value2) {
            addCriterion("\"staffFace\".feature between", value1, value2, "feature");
            return (Criteria) this;
        }

        public Criteria andFeatureNotBetween(String value1, String value2) {
            addCriterion("\"staffFace\".feature not between", value1, value2, "feature");
            return (Criteria) this;
        }

        public Criteria andFacePicExtIsNull() {
            addCriterion("\"staffFace\".face_pic_ext is null");
            return (Criteria) this;
        }

        public Criteria andFacePicExtIsNotNull() {
            addCriterion("\"staffFace\".face_pic_ext is not null");
            return (Criteria) this;
        }

        public Criteria andFacePicExtEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic_ext =", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic_ext <>", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtGreaterThan(String value) {
            addCriterion("\"staffFace\".face_pic_ext >", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtGreaterThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic_ext >=", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtLessThan(String value) {
            addCriterion("\"staffFace\".face_pic_ext <", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtLessThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".face_pic_ext <=", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtLike(String value) {
            addCriterion("\"staffFace\".face_pic_ext like", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotLike(String value) {
            addCriterion("\"staffFace\".face_pic_ext not like", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtIn(List<String> values) {
            addCriterion("\"staffFace\".face_pic_ext in", values, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotIn(List<String> values) {
            addCriterion("\"staffFace\".face_pic_ext not in", values, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtBetween(String value1, String value2) {
            addCriterion("\"staffFace\".face_pic_ext between", value1, value2, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotBetween(String value1, String value2) {
            addCriterion("\"staffFace\".face_pic_ext not between", value1, value2, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidIsNull() {
            addCriterion("\"staffFace\".original_person_uuid is null");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidIsNotNull() {
            addCriterion("\"staffFace\".original_person_uuid is not null");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidEqualTo(String value) {
            addCriterion("\"staffFace\".original_person_uuid =", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidNotEqualTo(String value) {
            addCriterion("\"staffFace\".original_person_uuid <>", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidGreaterThan(String value) {
            addCriterion("\"staffFace\".original_person_uuid >", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidGreaterThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".original_person_uuid >=", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidLessThan(String value) {
            addCriterion("\"staffFace\".original_person_uuid <", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidLessThanOrEqualTo(String value) {
            addCriterion("\"staffFace\".original_person_uuid <=", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidLike(String value) {
            addCriterion("\"staffFace\".original_person_uuid like", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidNotLike(String value) {
            addCriterion("\"staffFace\".original_person_uuid not like", value, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidIn(List<String> values) {
            addCriterion("\"staffFace\".original_person_uuid in", values, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidNotIn(List<String> values) {
            addCriterion("\"staffFace\".original_person_uuid not in", values, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidBetween(String value1, String value2) {
            addCriterion("\"staffFace\".original_person_uuid between", value1, value2, "originalPersonUuid");
            return (Criteria) this;
        }

        public Criteria andOriginalPersonUuidNotBetween(String value1, String value2) {
            addCriterion("\"staffFace\".original_person_uuid not between", value1, value2, "originalPersonUuid");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"staffFace\".id as staffFace_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStaffIdColumn() {
            addColumnStr("\"staffFace\".staff_id as staffFace_staff_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasRecognitionIdColumn() {
            addColumnStr("\"staffFace\".recognition_id as staffFace_recognition_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFeatureExtColumn() {
            addColumnStr("\"staffFace\".feature_ext as staffFace_feature_ext ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"staffFace\".create_time as staffFace_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"staffFace\".modify_time as staffFace_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFacePicColumn() {
            addColumnStr("\"staffFace\".face_pic as staffFace_face_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFeatureColumn() {
            addColumnStr("\"staffFace\".feature as staffFace_feature ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFacePicExtColumn() {
            addColumnStr("\"staffFace\".face_pic_ext as staffFace_face_pic_ext ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOriginalPersonUuidColumn() {
            addColumnStr("\"staffFace\".original_person_uuid as staffFace_original_person_uuid ");
            return (ColumnContainer) this;
        }
    }
}