package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.Date;
import java.util.List;

public class DeviceMappingExample extends BaseExample {

    public DeviceMappingExample() {
        super();
        tableName = "b_device_mapping";
        tableAlias = "device";
        ignoreCase = false;
    }

    public DeviceExample.ColumnContainer createDeviceColumns() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.ColumnContainer columnContainer = (DeviceExample.ColumnContainer) columnContainerMap.get(deviceExample.getTableName());
         if(columnContainer == null){
            columnContainer = deviceExample.createColumns();
            columnContainerMap.put(deviceExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public DeviceExample.Criteria andDeviceCriteria() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria criteria = deviceExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public DeviceExample.Criteria orDeviceCriteria() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria criteria = deviceExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public DeviceExample.Criteria andDeviceCriteria(Criteria criteria) {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria newCriteria = deviceExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "b_device_mapping";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("\"device\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"device\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"device\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"device\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"device\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"device\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"device\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"device\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andDeviceIdIsNull() {
            addCriterion("\"device\".device_id is null");
            return (Criteria) this;
        }

        public Criteria andDeviceIdIsNotNull() {
            addCriterion("\"device\".device_id is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceIdEqualTo(Long value) {
            addCriterion("\"device\".device_id =", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdNotEqualTo(Long value) {
            addCriterion("\"device\".device_id <>", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdGreaterThan(Long value) {
            addCriterion("\"device\".device_id >", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".device_id >=", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdLessThan(Long value) {
            addCriterion("\"device\".device_id <", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".device_id <=", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdIn(List<Long> values) {
            addCriterion("\"device\".device_id in", values, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdNotIn(List<Long> values) {
            addCriterion("\"device\".device_id not in", values, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".device_id between", value1, value2, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".device_id not between", value1, value2, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNull() {
            addCriterion("\"device\".device_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNotNull() {
            addCriterion("\"device\".device_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumEqualTo(String value) {
            addCriterion("\"device\".device_serialnum =", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotEqualTo(String value) {
            addCriterion("\"device\".device_serialnum <>", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThan(String value) {
            addCriterion("\"device\".device_serialnum >", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".device_serialnum >=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThan(String value) {
            addCriterion("\"device\".device_serialnum <", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"device\".device_serialnum <=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLike(String value) {
            addCriterion("\"device\".device_serialnum like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotLike(String value) {
            addCriterion("\"device\".device_serialnum not like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIn(List<String> values) {
            addCriterion("\"device\".device_serialnum in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotIn(List<String> values) {
            addCriterion("\"device\".device_serialnum not in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumBetween(String value1, String value2) {
            addCriterion("\"device\".device_serialnum between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"device\".device_serialnum not between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"device\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"device\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"device\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"device\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"device\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"device\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"device\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"device\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"device\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"device\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"device\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"device\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"device\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"device\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"device\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"device\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumIsNull() {
            addCriterion("\"device\".mapping_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumIsNotNull() {
            addCriterion("\"device\".mapping_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumEqualTo(String value) {
            addCriterion("\"device\".mapping_serialnum =", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumNotEqualTo(String value) {
            addCriterion("\"device\".mapping_serialnum <>", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumGreaterThan(String value) {
            addCriterion("\"device\".mapping_serialnum >", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".mapping_serialnum >=", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumLessThan(String value) {
            addCriterion("\"device\".mapping_serialnum <", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"device\".mapping_serialnum <=", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumLike(String value) {
            addCriterion("\"device\".mapping_serialnum like", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumNotLike(String value) {
            addCriterion("\"device\".mapping_serialnum not like", value, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumIn(List<String> values) {
            addCriterion("\"device\".mapping_serialnum in", values, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumNotIn(List<String> values) {
            addCriterion("\"device\".mapping_serialnum not in", values, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumBetween(String value1, String value2) {
            addCriterion("\"device\".mapping_serialnum between", value1, value2, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"device\".mapping_serialnum not between", value1, value2, "mappingSerialnum");
            return (Criteria) this;
        }

        public Criteria andMappingNameIsNull() {
            addCriterion("\"device\".mapping_name is null");
            return (Criteria) this;
        }

        public Criteria andMappingNameIsNotNull() {
            addCriterion("\"device\".mapping_name is not null");
            return (Criteria) this;
        }

        public Criteria andMappingNameEqualTo(String value) {
            addCriterion("\"device\".mapping_name =", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameNotEqualTo(String value) {
            addCriterion("\"device\".mapping_name <>", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameGreaterThan(String value) {
            addCriterion("\"device\".mapping_name >", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".mapping_name >=", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameLessThan(String value) {
            addCriterion("\"device\".mapping_name <", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameLessThanOrEqualTo(String value) {
            addCriterion("\"device\".mapping_name <=", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameLike(String value) {
            addCriterion("\"device\".mapping_name like", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameNotLike(String value) {
            addCriterion("\"device\".mapping_name not like", value, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameIn(List<String> values) {
            addCriterion("\"device\".mapping_name in", values, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameNotIn(List<String> values) {
            addCriterion("\"device\".mapping_name not in", values, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameBetween(String value1, String value2) {
            addCriterion("\"device\".mapping_name between", value1, value2, "mappingName");
            return (Criteria) this;
        }

        public Criteria andMappingNameNotBetween(String value1, String value2) {
            addCriterion("\"device\".mapping_name not between", value1, value2, "mappingName");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("\"device\".\"status\" is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("\"device\".\"status\" is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Short value) {
            addCriterion("\"device\".\"status\" =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Short value) {
            addCriterion("\"device\".\"status\" <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Short value) {
            addCriterion("\"device\".\"status\" >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Short value) {
            addCriterion("\"device\".\"status\" >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Short value) {
            addCriterion("\"device\".\"status\" <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Short value) {
            addCriterion("\"device\".\"status\" <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Short> values) {
            addCriterion("\"device\".\"status\" in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Short> values) {
            addCriterion("\"device\".\"status\" not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Short value1, Short value2) {
            addCriterion("\"device\".\"status\" between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Short value1, Short value2) {
            addCriterion("\"device\".\"status\" not between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"device\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"device\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"device\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"device\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"device\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"device\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"device\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"device\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"device\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"device\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"device\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"device\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"device\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"device\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"device\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"device\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"device\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"device\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"device\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"device\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"device\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"device\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"device\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"device\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"device\".id as device_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceIdColumn() {
            addColumnStr("\"device\".device_id as device_device_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceSerialnumColumn() {
            addColumnStr("\"device\".device_serialnum as device_device_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"device\".mall_id as device_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"device\".account_id as device_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMappingSerialnumColumn() {
            addColumnStr("\"device\".mapping_serialnum as device_mapping_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMappingNameColumn() {
            addColumnStr("\"device\".mapping_name as device_mapping_name ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStatusColumn() {
            addColumnStr("\"device\".\"status\" as \"device_status\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"device\".modify_time as device_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"device\".create_time as device_create_time ");
            return (ColumnContainer) this;
        }
    }
}