package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.Date;
import java.util.List;

public class ConfigParamsExample extends BaseExample {

    public ConfigParamsExample() {
        super();
        tableName = "s_config_params";
        tableAlias = "configParams";
        ignoreCase = false;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "s_config_params";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("\"configParams\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"configParams\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"configParams\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"configParams\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"configParams\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"configParams\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"configParams\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"configParams\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"configParams\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"configParams\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"configParams\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"configParams\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"configParams\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"configParams\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"configParams\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"configParams\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"configParams\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"configParams\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"configParams\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"configParams\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"configParams\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"configParams\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"configParams\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"configParams\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"configParams\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"configParams\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"configParams\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"configParams\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"configParams\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"configParams\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"configParams\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"configParams\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"configParams\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"configParams\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"configParams\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"configParams\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andKeyIsNull() {
            addCriterion("\"configParams\".\"key\" is null");
            return (Criteria) this;
        }

        public Criteria andKeyIsNotNull() {
            addCriterion("\"configParams\".\"key\" is not null");
            return (Criteria) this;
        }

        public Criteria andKeyEqualTo(String value) {
            addCriterion("\"configParams\".\"key\" =", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyNotEqualTo(String value) {
            addCriterion("\"configParams\".\"key\" <>", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyGreaterThan(String value) {
            addCriterion("\"configParams\".\"key\" >", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyGreaterThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"key\" >=", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyLessThan(String value) {
            addCriterion("\"configParams\".\"key\" <", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyLessThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"key\" <=", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyLike(String value) {
            addCriterion("\"configParams\".\"key\" like", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyNotLike(String value) {
            addCriterion("\"configParams\".\"key\" not like", value, "key");
            return (Criteria) this;
        }

        public Criteria andKeyIn(List<String> values) {
            addCriterion("\"configParams\".\"key\" in", values, "key");
            return (Criteria) this;
        }

        public Criteria andKeyNotIn(List<String> values) {
            addCriterion("\"configParams\".\"key\" not in", values, "key");
            return (Criteria) this;
        }

        public Criteria andKeyBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"key\" between", value1, value2, "key");
            return (Criteria) this;
        }

        public Criteria andKeyNotBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"key\" not between", value1, value2, "key");
            return (Criteria) this;
        }

        public Criteria andNameIsNull() {
            addCriterion("\"configParams\".\"name\" is null");
            return (Criteria) this;
        }

        public Criteria andNameIsNotNull() {
            addCriterion("\"configParams\".\"name\" is not null");
            return (Criteria) this;
        }

        public Criteria andNameEqualTo(String value) {
            addCriterion("\"configParams\".\"name\" =", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotEqualTo(String value) {
            addCriterion("\"configParams\".\"name\" <>", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameGreaterThan(String value) {
            addCriterion("\"configParams\".\"name\" >", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameGreaterThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"name\" >=", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLessThan(String value) {
            addCriterion("\"configParams\".\"name\" <", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLessThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"name\" <=", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLike(String value) {
            addCriterion("\"configParams\".\"name\" like", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotLike(String value) {
            addCriterion("\"configParams\".\"name\" not like", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameIn(List<String> values) {
            addCriterion("\"configParams\".\"name\" in", values, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotIn(List<String> values) {
            addCriterion("\"configParams\".\"name\" not in", values, "name");
            return (Criteria) this;
        }

        public Criteria andNameBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"name\" between", value1, value2, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"name\" not between", value1, value2, "name");
            return (Criteria) this;
        }

        public Criteria andValueIsNull() {
            addCriterion("\"configParams\".\"value\" is null");
            return (Criteria) this;
        }

        public Criteria andValueIsNotNull() {
            addCriterion("\"configParams\".\"value\" is not null");
            return (Criteria) this;
        }

        public Criteria andValueEqualTo(String value) {
            addCriterion("\"configParams\".\"value\" =", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueNotEqualTo(String value) {
            addCriterion("\"configParams\".\"value\" <>", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueGreaterThan(String value) {
            addCriterion("\"configParams\".\"value\" >", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueGreaterThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"value\" >=", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueLessThan(String value) {
            addCriterion("\"configParams\".\"value\" <", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueLessThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"value\" <=", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueLike(String value) {
            addCriterion("\"configParams\".\"value\" like", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueNotLike(String value) {
            addCriterion("\"configParams\".\"value\" not like", value, "value");
            return (Criteria) this;
        }

        public Criteria andValueIn(List<String> values) {
            addCriterion("\"configParams\".\"value\" in", values, "value");
            return (Criteria) this;
        }

        public Criteria andValueNotIn(List<String> values) {
            addCriterion("\"configParams\".\"value\" not in", values, "value");
            return (Criteria) this;
        }

        public Criteria andValueBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"value\" between", value1, value2, "value");
            return (Criteria) this;
        }

        public Criteria andValueNotBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"value\" not between", value1, value2, "value");
            return (Criteria) this;
        }

        public Criteria andTypeIsNull() {
            addCriterion("\"configParams\".\"type\" is null");
            return (Criteria) this;
        }

        public Criteria andTypeIsNotNull() {
            addCriterion("\"configParams\".\"type\" is not null");
            return (Criteria) this;
        }

        public Criteria andTypeEqualTo(Short value) {
            addCriterion("\"configParams\".\"type\" =", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotEqualTo(Short value) {
            addCriterion("\"configParams\".\"type\" <>", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThan(Short value) {
            addCriterion("\"configParams\".\"type\" >", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThanOrEqualTo(Short value) {
            addCriterion("\"configParams\".\"type\" >=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThan(Short value) {
            addCriterion("\"configParams\".\"type\" <", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThanOrEqualTo(Short value) {
            addCriterion("\"configParams\".\"type\" <=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeIn(List<Short> values) {
            addCriterion("\"configParams\".\"type\" in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotIn(List<Short> values) {
            addCriterion("\"configParams\".\"type\" not in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeBetween(Short value1, Short value2) {
            addCriterion("\"configParams\".\"type\" between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotBetween(Short value1, Short value2) {
            addCriterion("\"configParams\".\"type\" not between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andOptionsIsNull() {
            addCriterion("\"configParams\".\"options\" is null");
            return (Criteria) this;
        }

        public Criteria andOptionsIsNotNull() {
            addCriterion("\"configParams\".\"options\" is not null");
            return (Criteria) this;
        }

        public Criteria andOptionsEqualTo(String value) {
            addCriterion("\"configParams\".\"options\" =", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsNotEqualTo(String value) {
            addCriterion("\"configParams\".\"options\" <>", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsGreaterThan(String value) {
            addCriterion("\"configParams\".\"options\" >", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsGreaterThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"options\" >=", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsLessThan(String value) {
            addCriterion("\"configParams\".\"options\" <", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsLessThanOrEqualTo(String value) {
            addCriterion("\"configParams\".\"options\" <=", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsLike(String value) {
            addCriterion("\"configParams\".\"options\" like", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsNotLike(String value) {
            addCriterion("\"configParams\".\"options\" not like", value, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsIn(List<String> values) {
            addCriterion("\"configParams\".\"options\" in", values, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsNotIn(List<String> values) {
            addCriterion("\"configParams\".\"options\" not in", values, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"options\" between", value1, value2, "options");
            return (Criteria) this;
        }

        public Criteria andOptionsNotBetween(String value1, String value2) {
            addCriterion("\"configParams\".\"options\" not between", value1, value2, "options");
            return (Criteria) this;
        }

        public Criteria andIntroIsNull() {
            addCriterion("\"configParams\".intro is null");
            return (Criteria) this;
        }

        public Criteria andIntroIsNotNull() {
            addCriterion("\"configParams\".intro is not null");
            return (Criteria) this;
        }

        public Criteria andIntroEqualTo(String value) {
            addCriterion("\"configParams\".intro =", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotEqualTo(String value) {
            addCriterion("\"configParams\".intro <>", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroGreaterThan(String value) {
            addCriterion("\"configParams\".intro >", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroGreaterThanOrEqualTo(String value) {
            addCriterion("\"configParams\".intro >=", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLessThan(String value) {
            addCriterion("\"configParams\".intro <", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLessThanOrEqualTo(String value) {
            addCriterion("\"configParams\".intro <=", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLike(String value) {
            addCriterion("\"configParams\".intro like", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotLike(String value) {
            addCriterion("\"configParams\".intro not like", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroIn(List<String> values) {
            addCriterion("\"configParams\".intro in", values, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotIn(List<String> values) {
            addCriterion("\"configParams\".intro not in", values, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroBetween(String value1, String value2) {
            addCriterion("\"configParams\".intro between", value1, value2, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotBetween(String value1, String value2) {
            addCriterion("\"configParams\".intro not between", value1, value2, "intro");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"configParams\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"configParams\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"configParams\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"configParams\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"configParams\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"configParams\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"configParams\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"configParams\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"configParams\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"configParams\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"configParams\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"configParams\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"configParams\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"configParams\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"configParams\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"configParams\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"configParams\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"configParams\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"configParams\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"configParams\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"configParams\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"configParams\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"configParams\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"configParams\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andOrderIsNull() {
            addCriterion("\"configParams\".\"order\" is null");
            return (Criteria) this;
        }

        public Criteria andOrderIsNotNull() {
            addCriterion("\"configParams\".\"order\" is not null");
            return (Criteria) this;
        }

        public Criteria andOrderEqualTo(Integer value) {
            addCriterion("\"configParams\".\"order\" =", value, "order");
            return (Criteria) this;
        }

        public Criteria andOrderNotEqualTo(Integer value) {
            addCriterion("\"configParams\".\"order\" <>", value, "order");
            return (Criteria) this;
        }

        public Criteria andOrderGreaterThan(Integer value) {
            addCriterion("\"configParams\".\"order\" >", value, "order");
            return (Criteria) this;
        }

        public Criteria andOrderGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"configParams\".\"order\" >=", value, "order");
            return (Criteria) this;
        }

        public Criteria andOrderLessThan(Integer value) {
            addCriterion("\"configParams\".\"order\" <", value, "order");
            return (Criteria) this;
        }

        public Criteria andOrderLessThanOrEqualTo(Integer value) {
            addCriterion("\"configParams\".\"order\" <=", value, "order");
            return (Criteria) this;
        }

        public Criteria andOrderIn(List<Integer> values) {
            addCriterion("\"configParams\".\"order\" in", values, "order");
            return (Criteria) this;
        }

        public Criteria andOrderNotIn(List<Integer> values) {
            addCriterion("\"configParams\".\"order\" not in", values, "order");
            return (Criteria) this;
        }

        public Criteria andOrderBetween(Integer value1, Integer value2) {
            addCriterion("\"configParams\".\"order\" between", value1, value2, "order");
            return (Criteria) this;
        }

        public Criteria andOrderNotBetween(Integer value1, Integer value2) {
            addCriterion("\"configParams\".\"order\" not between", value1, value2, "order");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"configParams\".id as configParams_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"configParams\".mall_id as configParams_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"configParams\".account_id as configParams_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyColumn() {
            addColumnStr("\"configParams\".\"key\" as \"configParams_key\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasNameColumn() {
            addColumnStr("\"configParams\".\"name\" as \"configParams_name\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasValueColumn() {
            addColumnStr("\"configParams\".\"value\" as \"configParams_value\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTypeColumn() {
            addColumnStr("\"configParams\".\"type\" as \"configParams_type\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOptionsColumn() {
            addColumnStr("\"configParams\".\"options\" as \"configParams_options\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasIntroColumn() {
            addColumnStr("\"configParams\".intro as configParams_intro ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"configParams\".modify_time as configParams_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"configParams\".create_time as configParams_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOrderColumn() {
            addColumnStr("\"configParams\".\"order\" as \"configParams_order\" ");
            return (ColumnContainer) this;
        }
    }
}