package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ChannelSnapshotExample extends BaseExample {

    public ChannelSnapshotExample() {
        super();
        tableName = "d_channel_snapshot";
        tableAlias = "channelSnapshot";
        ignoreCase = false;
    }

    public DeviceExample.ColumnContainer createDeviceColumns() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.ColumnContainer columnContainer = (DeviceExample.ColumnContainer) columnContainerMap.get(deviceExample.getTableName());
         if(columnContainer == null){
            columnContainer = deviceExample.createColumns();
            columnContainerMap.put(deviceExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public DeviceExample.Criteria andDeviceCriteria() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria criteria = deviceExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public DeviceExample.Criteria orDeviceCriteria() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria criteria = deviceExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public DeviceExample.Criteria andDeviceCriteria(Criteria criteria) {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria newCriteria = deviceExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public ChannelExample.ColumnContainer createChannelColumns() {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.ColumnContainer columnContainer = (ChannelExample.ColumnContainer) columnContainerMap.get(channelExample.getTableName());
         if(columnContainer == null){
            columnContainer = channelExample.createColumns();
            columnContainerMap.put(channelExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public ChannelExample.Criteria andChannelCriteria() {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria criteria = channelExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public ChannelExample.Criteria orChannelCriteria() {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria criteria = channelExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public ChannelExample.Criteria andChannelCriteria(Criteria criteria) {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria newCriteria = channelExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public GateExample.ColumnContainer createGateColumns() {
        GateExample gateExample = new GateExample();
        GateExample.ColumnContainer columnContainer = (GateExample.ColumnContainer) columnContainerMap.get(gateExample.getTableName());
         if(columnContainer == null){
            columnContainer = gateExample.createColumns();
            columnContainerMap.put(gateExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public GateExample.Criteria andGateCriteria() {
        GateExample gateExample = new GateExample();
        GateExample.Criteria criteria = gateExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public GateExample.Criteria orGateCriteria() {
        GateExample gateExample = new GateExample();
        GateExample.Criteria criteria = gateExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public GateExample.Criteria andGateCriteria(Criteria criteria) {
        GateExample gateExample = new GateExample();
        GateExample.Criteria newCriteria = gateExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_channel_snapshot";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"channelSnapshot\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"channelSnapshot\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"channelSnapshot\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"channelSnapshot\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andDeviceIdIsNull() {
            addCriterion("\"channelSnapshot\".device_id is null");
            return (Criteria) this;
        }

        public Criteria andDeviceIdIsNotNull() {
            addCriterion("\"channelSnapshot\".device_id is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceIdEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".device_id =", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdNotEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".device_id <>", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdGreaterThan(Long value) {
            addCriterion("\"channelSnapshot\".device_id >", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".device_id >=", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdLessThan(Long value) {
            addCriterion("\"channelSnapshot\".device_id <", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdLessThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".device_id <=", value, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".device_id in", values, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdNotIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".device_id not in", values, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".device_id between", value1, value2, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceIdNotBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".device_id not between", value1, value2, "deviceId");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNull() {
            addCriterion("\"channelSnapshot\".device_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNotNull() {
            addCriterion("\"channelSnapshot\".device_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumEqualTo(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum =", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotEqualTo(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum <>", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThan(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum >", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum >=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThan(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum <", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum <=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLike(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotLike(String value) {
            addCriterion("\"channelSnapshot\".device_serialnum not like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIn(List<String> values) {
            addCriterion("\"channelSnapshot\".device_serialnum in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotIn(List<String> values) {
            addCriterion("\"channelSnapshot\".device_serialnum not in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".device_serialnum between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".device_serialnum not between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelIdIsNull() {
            addCriterion("\"channelSnapshot\".channel_id is null");
            return (Criteria) this;
        }

        public Criteria andChannelIdIsNotNull() {
            addCriterion("\"channelSnapshot\".channel_id is not null");
            return (Criteria) this;
        }

        public Criteria andChannelIdEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".channel_id =", value, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdNotEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".channel_id <>", value, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdGreaterThan(Long value) {
            addCriterion("\"channelSnapshot\".channel_id >", value, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".channel_id >=", value, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdLessThan(Long value) {
            addCriterion("\"channelSnapshot\".channel_id <", value, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdLessThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".channel_id <=", value, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".channel_id in", values, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdNotIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".channel_id not in", values, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".channel_id between", value1, value2, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelIdNotBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".channel_id not between", value1, value2, "channelId");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNull() {
            addCriterion("\"channelSnapshot\".channel_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNotNull() {
            addCriterion("\"channelSnapshot\".channel_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumEqualTo(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum =", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotEqualTo(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum <>", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThan(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum >", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum >=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThan(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum <", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum <=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLike(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotLike(String value) {
            addCriterion("\"channelSnapshot\".channel_serialnum not like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIn(List<String> values) {
            addCriterion("\"channelSnapshot\".channel_serialnum in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotIn(List<String> values) {
            addCriterion("\"channelSnapshot\".channel_serialnum not in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".channel_serialnum between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".channel_serialnum not between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andWidthIsNull() {
            addCriterion("\"channelSnapshot\".width is null");
            return (Criteria) this;
        }

        public Criteria andWidthIsNotNull() {
            addCriterion("\"channelSnapshot\".width is not null");
            return (Criteria) this;
        }

        public Criteria andWidthEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".width =", value, "width");
            return (Criteria) this;
        }

        public Criteria andWidthNotEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".width <>", value, "width");
            return (Criteria) this;
        }

        public Criteria andWidthGreaterThan(Float value) {
            addCriterion("\"channelSnapshot\".width >", value, "width");
            return (Criteria) this;
        }

        public Criteria andWidthGreaterThanOrEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".width >=", value, "width");
            return (Criteria) this;
        }

        public Criteria andWidthLessThan(Float value) {
            addCriterion("\"channelSnapshot\".width <", value, "width");
            return (Criteria) this;
        }

        public Criteria andWidthLessThanOrEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".width <=", value, "width");
            return (Criteria) this;
        }

        public Criteria andWidthIn(List<Float> values) {
            addCriterion("\"channelSnapshot\".width in", values, "width");
            return (Criteria) this;
        }

        public Criteria andWidthNotIn(List<Float> values) {
            addCriterion("\"channelSnapshot\".width not in", values, "width");
            return (Criteria) this;
        }

        public Criteria andWidthBetween(Float value1, Float value2) {
            addCriterion("\"channelSnapshot\".width between", value1, value2, "width");
            return (Criteria) this;
        }

        public Criteria andWidthNotBetween(Float value1, Float value2) {
            addCriterion("\"channelSnapshot\".width not between", value1, value2, "width");
            return (Criteria) this;
        }

        public Criteria andHeightIsNull() {
            addCriterion("\"channelSnapshot\".height is null");
            return (Criteria) this;
        }

        public Criteria andHeightIsNotNull() {
            addCriterion("\"channelSnapshot\".height is not null");
            return (Criteria) this;
        }

        public Criteria andHeightEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".height =", value, "height");
            return (Criteria) this;
        }

        public Criteria andHeightNotEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".height <>", value, "height");
            return (Criteria) this;
        }

        public Criteria andHeightGreaterThan(Float value) {
            addCriterion("\"channelSnapshot\".height >", value, "height");
            return (Criteria) this;
        }

        public Criteria andHeightGreaterThanOrEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".height >=", value, "height");
            return (Criteria) this;
        }

        public Criteria andHeightLessThan(Float value) {
            addCriterion("\"channelSnapshot\".height <", value, "height");
            return (Criteria) this;
        }

        public Criteria andHeightLessThanOrEqualTo(Float value) {
            addCriterion("\"channelSnapshot\".height <=", value, "height");
            return (Criteria) this;
        }

        public Criteria andHeightIn(List<Float> values) {
            addCriterion("\"channelSnapshot\".height in", values, "height");
            return (Criteria) this;
        }

        public Criteria andHeightNotIn(List<Float> values) {
            addCriterion("\"channelSnapshot\".height not in", values, "height");
            return (Criteria) this;
        }

        public Criteria andHeightBetween(Float value1, Float value2) {
            addCriterion("\"channelSnapshot\".height between", value1, value2, "height");
            return (Criteria) this;
        }

        public Criteria andHeightNotBetween(Float value1, Float value2) {
            addCriterion("\"channelSnapshot\".height not between", value1, value2, "height");
            return (Criteria) this;
        }

        public Criteria andSnapshotIsNull() {
            addCriterion("\"channelSnapshot\".snapshot is null");
            return (Criteria) this;
        }

        public Criteria andSnapshotIsNotNull() {
            addCriterion("\"channelSnapshot\".snapshot is not null");
            return (Criteria) this;
        }

        public Criteria andSnapshotEqualTo(String value) {
            addCriterion("\"channelSnapshot\".snapshot =", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotNotEqualTo(String value) {
            addCriterion("\"channelSnapshot\".snapshot <>", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotGreaterThan(String value) {
            addCriterion("\"channelSnapshot\".snapshot >", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotGreaterThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".snapshot >=", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotLessThan(String value) {
            addCriterion("\"channelSnapshot\".snapshot <", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotLessThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".snapshot <=", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotLike(String value) {
            addCriterion("\"channelSnapshot\".snapshot like", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotNotLike(String value) {
            addCriterion("\"channelSnapshot\".snapshot not like", value, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotIn(List<String> values) {
            addCriterion("\"channelSnapshot\".snapshot in", values, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotNotIn(List<String> values) {
            addCriterion("\"channelSnapshot\".snapshot not in", values, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".snapshot between", value1, value2, "snapshot");
            return (Criteria) this;
        }

        public Criteria andSnapshotNotBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".snapshot not between", value1, value2, "snapshot");
            return (Criteria) this;
        }

        public Criteria andGateIdIsNull() {
            addCriterion("\"channelSnapshot\".gate_id is null");
            return (Criteria) this;
        }

        public Criteria andGateIdIsNotNull() {
            addCriterion("\"channelSnapshot\".gate_id is not null");
            return (Criteria) this;
        }

        public Criteria andGateIdEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".gate_id =", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdNotEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".gate_id <>", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdGreaterThan(Long value) {
            addCriterion("\"channelSnapshot\".gate_id >", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".gate_id >=", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdLessThan(Long value) {
            addCriterion("\"channelSnapshot\".gate_id <", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdLessThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".gate_id <=", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".gate_id in", values, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdNotIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".gate_id not in", values, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".gate_id between", value1, value2, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdNotBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".gate_id not between", value1, value2, "gateId");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"channelSnapshot\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"channelSnapshot\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"channelSnapshot\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"channelSnapshot\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"channelSnapshot\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"channelSnapshot\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"channelSnapshot\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"channelSnapshot\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"channelSnapshot\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"channelSnapshot\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"channelSnapshot\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"channelSnapshot\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"channelSnapshot\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"channelSnapshot\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"channelSnapshot\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"channelSnapshot\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"channelSnapshot\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"channelSnapshot\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"channelSnapshot\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"channelSnapshot\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"channelSnapshot\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"channelSnapshot\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"channelSnapshot\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"channelSnapshot\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"channelSnapshot\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"channelSnapshot\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"channelSnapshot\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"channelSnapshot\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"channelSnapshot\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"channelSnapshot\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"channelSnapshot\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"channelSnapshot\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"channelSnapshot\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"channelSnapshot\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"channelSnapshot\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"channelSnapshot\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"channelSnapshot\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"channelSnapshot\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"channelSnapshot\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andHourIsNull() {
            addCriterion("\"channelSnapshot\".\"hour\" is null");
            return (Criteria) this;
        }

        public Criteria andHourIsNotNull() {
            addCriterion("\"channelSnapshot\".\"hour\" is not null");
            return (Criteria) this;
        }

        public Criteria andHourEqualTo(Short value) {
            addCriterion("\"channelSnapshot\".\"hour\" =", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotEqualTo(Short value) {
            addCriterion("\"channelSnapshot\".\"hour\" <>", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourGreaterThan(Short value) {
            addCriterion("\"channelSnapshot\".\"hour\" >", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourGreaterThanOrEqualTo(Short value) {
            addCriterion("\"channelSnapshot\".\"hour\" >=", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourLessThan(Short value) {
            addCriterion("\"channelSnapshot\".\"hour\" <", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourLessThanOrEqualTo(Short value) {
            addCriterion("\"channelSnapshot\".\"hour\" <=", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourIn(List<Short> values) {
            addCriterion("\"channelSnapshot\".\"hour\" in", values, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotIn(List<Short> values) {
            addCriterion("\"channelSnapshot\".\"hour\" not in", values, "hour");
            return (Criteria) this;
        }

        public Criteria andHourBetween(Short value1, Short value2) {
            addCriterion("\"channelSnapshot\".\"hour\" between", value1, value2, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotBetween(Short value1, Short value2) {
            addCriterion("\"channelSnapshot\".\"hour\" not between", value1, value2, "hour");
            return (Criteria) this;
        }

        public Criteria andLocalIpIsNull() {
            addCriterion("\"channelSnapshot\".local_ip is null");
            return (Criteria) this;
        }

        public Criteria andLocalIpIsNotNull() {
            addCriterion("\"channelSnapshot\".local_ip is not null");
            return (Criteria) this;
        }

        public Criteria andLocalIpEqualTo(String value) {
            addCriterion("\"channelSnapshot\".local_ip =", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotEqualTo(String value) {
            addCriterion("\"channelSnapshot\".local_ip <>", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpGreaterThan(String value) {
            addCriterion("\"channelSnapshot\".local_ip >", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpGreaterThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".local_ip >=", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpLessThan(String value) {
            addCriterion("\"channelSnapshot\".local_ip <", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpLessThanOrEqualTo(String value) {
            addCriterion("\"channelSnapshot\".local_ip <=", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpLike(String value) {
            addCriterion("\"channelSnapshot\".local_ip like", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotLike(String value) {
            addCriterion("\"channelSnapshot\".local_ip not like", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpIn(List<String> values) {
            addCriterion("\"channelSnapshot\".local_ip in", values, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotIn(List<String> values) {
            addCriterion("\"channelSnapshot\".local_ip not in", values, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".local_ip between", value1, value2, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotBetween(String value1, String value2) {
            addCriterion("\"channelSnapshot\".local_ip not between", value1, value2, "localIp");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"channelSnapshot\".id as channelSnapshot_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceIdColumn() {
            addColumnStr("\"channelSnapshot\".device_id as channelSnapshot_device_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceSerialnumColumn() {
            addColumnStr("\"channelSnapshot\".device_serialnum as channelSnapshot_device_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasChannelIdColumn() {
            addColumnStr("\"channelSnapshot\".channel_id as channelSnapshot_channel_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasChannelSerialnumColumn() {
            addColumnStr("\"channelSnapshot\".channel_serialnum as channelSnapshot_channel_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasWidthColumn() {
            addColumnStr("\"channelSnapshot\".width as channelSnapshot_width ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHeightColumn() {
            addColumnStr("\"channelSnapshot\".height as channelSnapshot_height ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSnapshotColumn() {
            addColumnStr("\"channelSnapshot\".snapshot as channelSnapshot_snapshot ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasGateIdColumn() {
            addColumnStr("\"channelSnapshot\".gate_id as channelSnapshot_gate_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"channelSnapshot\".mall_id as channelSnapshot_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"channelSnapshot\".account_id as channelSnapshot_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"channelSnapshot\".create_time as channelSnapshot_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"channelSnapshot\".modify_time as channelSnapshot_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"channelSnapshot\".countdate as channelSnapshot_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"channelSnapshot\".counttime as channelSnapshot_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHourColumn() {
            addColumnStr("\"channelSnapshot\".\"hour\" as \"channelSnapshot_hour\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLocalIpColumn() {
            addColumnStr("\"channelSnapshot\".local_ip as channelSnapshot_local_ip ");
            return (ColumnContainer) this;
        }
    }
}