/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object downfile(String fileName, InputStream inputStream, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ";filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8"));
        response.setContentType("application/octet-stream;charset=UTF-8");
        BufferedInputStream in = null;
        try (OutputStream toClient = null;){
            in = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[((InputStream)in).available()];
            ((InputStream)in).read(buffer);
            ((InputStream)in).close();
            toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            toClient.write(buffer);
            toClient.flush();
        }
        return null;
    }

    public static void clearFile(String fileName) {
        File file = new File(fileName);
        try {
            if (!file.exists()) {
                FileUtil.createFile(fileName);
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readFileByBytes(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        StringBuffer content = new StringBuffer();
        try {
            byte[] temp = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream(file);
            while (fileInputStream.read(temp) != -1) {
                content.append(new String(temp));
                temp = new byte[1024];
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    public static String readFileByChars(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        StringBuffer content = new StringBuffer();
        try {
            char[] temp = new char[1024];
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            while (inputStreamReader.read(temp) != -1) {
                content.append(new String(temp));
                temp = new char[1024];
            }
            fileInputStream.close();
            inputStreamReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileByFileWriter(String filePath, String content) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            FileUtil.createFile(filePath);
        }
        File file2 = file;
        synchronized (file2) {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filePath));
            fos.write(content.getBytes("UTF-8"));
            fos.flush();
            fos.close();
        }
    }

    public static boolean createFile(String destFileName) {
        File file = new File(destFileName);
        if (file.exists()) {
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff01");
            return false;
        }
        if (destFileName.endsWith(File.separator)) {
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u76ee\u5f55\uff01");
            return false;
        }
        if (!file.getParentFile().exists()) {
            System.out.println("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa\u5b83\uff01");
            if (!file.getParentFile().mkdirs()) {
                System.out.println("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
                return false;
            }
        }
        try {
            if (file.createNewFile()) {
                System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff01");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + destFileName + "\u5931\u8d25\uff01" + e.getMessage());
            return false;
        }
    }

    public static String getBasePath() {
        try {
            return ResourceUtils.getFile((String)"").getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return System.getProperty("java.io.tmpdir");
        }
    }
}

