/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class DateUtil
extends DateUtils {
    private static DateFormatSymbols dateformatSymbols = new DateFormatSymbols(Locale.CHINA);
    public static String FORMAT_YYYY;
    public static String FORMAT_YYYY_CN;
    public static String FORMAT_YYYY_MM_DD_HH;
    public static String FORMAT_MM_DD_HH;
    public static String FORMAT_DD_HH;
    public static String FORMAT_HH;
    public static String FORMAT_DAY_OF_WEEK_SORT_CN;
    public static String FORMAT_WEEK_OF_YEAR;
    public static String FORMAT_YYYY_MM;
    public static String FORMAT_YYYY_MM_CN;
    public static String FORMAT_MM_DD;
    public static String FORMAT_MM_DD_E;
    public static String FORMAT_DD;
    public static String FORMAT_SHORT;
    public static String FORMAT_YYYY_MM_DD_HH_MM;
    public static String FORMAT_LONG;
    public static String FORMAT_FULL;
    public static String FORMAT_SHORT_CN;
    public static String FORMAT_SHORT_CN_WEEK;
    public static String FORMAT_SHORT_WEEK;
    public static String FORMAT_LONG_CN;
    public static String FORMAT_FULL_CN;
    public static String FORMAT_HHMMSS;
    public static String FORMAT_HHMMSSS;
    public static String FORMAT_HHMM;
    public static int FIRST_DAY_OF_WEEK;
    private static int[] weekends;

    public static void setFirstDayOfWeek(int firstDayOfWeek) {
        FIRST_DAY_OF_WEEK = firstDayOfWeek;
    }

    public static void setWeekend(int[] weekends) {
        DateUtil.weekends = weekends;
    }

    public static Date getLastWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(4, -1);
        return calendar.getTime();
    }

    public static Date getLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date getNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getLastYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, -1);
        return calendar.getTime();
    }

    public static Date getYesterday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date getTorromow(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, 1);
        return calendar.getTime();
    }

    public static Date getNextHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 1);
        return calendar.getTime();
    }

    public static Date getPreviousHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, -1);
        return calendar.getTime();
    }

    public static boolean isYesterday(Date today, Date yesterDay) {
        return DateUtil.isSameDay(DateUtil.getYesterday(today), yesterDay);
    }

    public static boolean isLastWeekDay(Date today, Date lastWeekDay) {
        return DateUtil.isSameDay(DateUtil.getLastWeek(today), lastWeekDay);
    }

    public static boolean isLastMonthDay(Date today, Date lastMonthDay) {
        return DateUtil.isSameDay(DateUtil.getLastMonth(today), lastMonthDay);
    }

    public static boolean isLastYearDay(Date today, Date lastYearDay) {
        return DateUtil.isSameDay(DateUtil.getLastYear(today), lastYearDay);
    }

    public static boolean isSameHour(Date date1, Date date2) {
        if (!DateUtil.isSameDay(date1, date2)) {
            return false;
        }
        return date1.getHours() == date2.getHours();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (!DateUtil.isSameMonth(date1, date2)) {
            return false;
        }
        return date1.getDate() == date2.getDate();
    }

    public static boolean isSameWeek(Date week, Date otherWeek) {
        return DateUtil.isSameDay(DateUtil.getMondayOfWeek(week), DateUtil.getMondayOfWeek(otherWeek));
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1.getYear() != date2.getYear()) {
            return false;
        }
        return date1.getMonth() == date2.getMonth();
    }

    public static boolean isLastWeek(Date date1, Date date2) {
        return DateUtil.isSameWeek(DateUtil.getLastWeek(date1), date2);
    }

    public static boolean isLastYearWeek(Date today, Date otherDay) {
        if (!DateUtil.isSameYear(DateUtil.getLastYear(today), otherDay)) {
            return false;
        }
        return DateUtil.getWeekOfYear(today) == DateUtil.getWeekOfYear(otherDay);
    }

    public static boolean isLastMonth(Date date1, Date date2) {
        return DateUtil.isSameMonth(DateUtil.getLastMonth(date1), date2);
    }

    public static boolean isLastYearMonth(Date date1, Date date2) {
        return DateUtil.isSameMonth(DateUtil.getLastYear(date1), date2);
    }

    public static boolean isSameSeason(Date date1, Date date2) {
        return DateUtil.getSeason(date1) == DateUtil.getSeason(date2);
    }

    public static boolean isLastSeason(Date date1, Date date2) {
        return DateUtil.getSeason(date1) == DateUtil.getSeason(date2) + 1;
    }

    public static boolean isSameYear(Date date1, Date date2) {
        return date1.getYear() == date2.getYear();
    }

    public static Date parseHMDate2NowTime(String HMStr, boolean before) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        Date HMTime = DateUtil.parse(FORMAT_HHMM, HMStr);
        calendar.setTime(HMTime);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int milliSecond = calendar.get(14);
        if (before) {
            minute = 0;
            second = 0;
            milliSecond = 0;
        } else {
            minute = 59;
            second = 59;
            milliSecond = 999;
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecond);
        return calendar.getTime();
    }

    public static Date setDayHMS(Date date, Date HMTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, HMTime.getHours());
        calendar.set(12, HMTime.getMinutes());
        calendar.set(13, HMTime.getSeconds());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setDayHM(Date date, String HMTimeStr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date HMTime = null;
        try {
            HMTime = DateUtil.parse(FORMAT_HHMM, HMTimeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar hmCalendar = Calendar.getInstance();
        hmCalendar.setTime(HMTime);
        calendar.set(11, hmCalendar.get(11));
        calendar.set(12, hmCalendar.get(12));
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date setDayHMS(Date date, String HMSTimeStr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date HMSTime = null;
        try {
            HMSTime = DateUtil.parse(FORMAT_HHMMSS, HMSTimeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar hmsCalendar = Calendar.getInstance();
        hmsCalendar.setTime(HMSTime);
        calendar.set(11, hmsCalendar.get(11));
        calendar.set(12, hmsCalendar.get(12));
        calendar.set(13, hmsCalendar.get(13));
        return calendar.getTime();
    }

    public static Date setDayH(Date date, String HTimeStr) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date HTime = null;
        try {
            HTime = DateUtil.parse(FORMAT_HH, HTimeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar hCalendar = Calendar.getInstance();
        hCalendar.setTime(HTime);
        calendar.set(11, hCalendar.get(11));
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String getTimeString() {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.format(FORMAT_FULL, calendar.getTime());
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getMinuteOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11) * 60 + calendar.get(12);
    }

    public static int getSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static int getMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(14);
    }

    public static int getDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
        int day_of_week = c.get(7);
        if (--day_of_week == 0) {
            day_of_week = 7;
        }
        return day_of_week;
    }

    public static int[] getCountDayOfWeekInMonth(Date date) {
        int[] count = new int[7];
        Date firstDate = DateUtil.getFirstDateOfMonth(date);
        int dayOfWeek = DateUtil.getDayOfWeek(firstDate);
        int dayOfMonth = DateUtil.getPassDayOfMonth(date);
        for (int i = 0; i < dayOfMonth; ++i) {
            int n = dayOfWeek - 1;
            count[n] = count[n] + 1;
            if (++dayOfWeek <= 7) continue;
            dayOfWeek = 1;
        }
        return count;
    }

    public static int getWeekOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int week_of_year = c.get(4);
        return week_of_year;
    }

    public static int getWeekOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
        int week_of_year = c.get(3);
        return week_of_year;
    }

    public static Date getMondayOfWeek(Date date) {
        Calendar monday = Calendar.getInstance();
        monday.setTime(date);
        monday.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
        monday.set(7, 2);
        return monday.getTime();
    }

    public static Date getSundayOfWeek(Date date) {
        Calendar sunday = Calendar.getInstance();
        sunday.setTime(date);
        sunday.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
        sunday.set(7, 1);
        return sunday.getTime();
    }

    public static boolean isWeekday(Date date) {
        int dayOfWeek = DateUtil.getDayOfWeek(date);
        if (weekends == null) {
            return dayOfWeek <= 5;
        }
        for (int weekend : weekends) {
            if (weekend != dayOfWeek) continue;
            return false;
        }
        return true;
    }

    public static Date getFirstSametWeekOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        date = DateUtil.setDayMinTime(date);
        c.setTime(date);
        int weekIndex = c.get(7);
        c.set(5, 1);
        while (weekIndex != c.get(7)) {
            c.add(5, 1);
        }
        return c.getTime();
    }

    public static int getRemainDayOfMonth(Date date) {
        int dayOfMonth = DateUtil.getDayOfMonth(date);
        int day = DateUtil.getPassDayOfMonth(date);
        return dayOfMonth - day;
    }

    public static int getPassDayOfMonth(Date date) {
        Date monthStart = DateUtil.setDayMinTime(DateUtil.getFirstDateOfMonth(new Date()));
        if (monthStart.after(date)) {
            return DateUtil.getDayOfMonth(date);
        }
        Date monthEnd = DateUtil.setDayMaxTime(DateUtil.getLastDateOfMonth(new Date()));
        if (monthEnd.before(date)) {
            return 0;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        return c.get(5);
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMinimum(5));
        return c.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static Date getFirstDateOfSeason(Date date) {
        return DateUtil.getFirstDateOfMonth(DateUtil.getSeasonDate(date)[0]);
    }

    public static Date getLastDateOfSeason(Date date) {
        return DateUtil.getLastDateOfMonth(DateUtil.getSeasonDate(date)[2]);
    }

    public static int getDayOfSeason(Date date) {
        Date[] seasonDates;
        int day = 0;
        for (Date date2 : seasonDates = DateUtil.getSeasonDate(date)) {
            day += DateUtil.getDayOfMonth(date2);
        }
        return day;
    }

    public static int getRemainDayOfSeason(Date date) {
        return DateUtil.getDayOfSeason(date) - DateUtil.getPassDayOfSeason(date);
    }

    public static int getPassDayOfSeason(Date date) {
        int day = 0;
        Date[] seasonDates = DateUtil.getSeasonDate(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        if (month == 0 || month == 3 || month == 6 || month == 9) {
            day = DateUtil.getPassDayOfMonth(seasonDates[0]);
        } else if (month == 1 || month == 4 || month == 7 || month == 10) {
            day = DateUtil.getDayOfMonth(seasonDates[0]) + DateUtil.getPassDayOfMonth(seasonDates[1]);
        } else if (month == 2 || month == 5 || month == 8 || month == 11) {
            day = DateUtil.getDayOfMonth(seasonDates[0]) + DateUtil.getDayOfMonth(seasonDates[1]) + DateUtil.getPassDayOfMonth(seasonDates[2]);
        }
        return day;
    }

    public static Date[] getSeasonDate(Date date) {
        Date[] season = new Date[3];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int nSeason = DateUtil.getSeason(date);
        if (nSeason == 1) {
            c.set(2, 0);
            season[0] = c.getTime();
            c.set(2, 1);
            season[1] = c.getTime();
            c.set(2, 2);
            season[2] = c.getTime();
        } else if (nSeason == 2) {
            c.set(2, 3);
            season[0] = c.getTime();
            c.set(2, 4);
            season[1] = c.getTime();
            c.set(2, 5);
            season[2] = c.getTime();
        } else if (nSeason == 3) {
            c.set(2, 6);
            season[0] = c.getTime();
            c.set(2, 7);
            season[1] = c.getTime();
            c.set(2, 8);
            season[2] = c.getTime();
        } else if (nSeason == 4) {
            c.set(2, 9);
            season[0] = c.getTime();
            c.set(2, 10);
            season[1] = c.getTime();
            c.set(2, 11);
            season[2] = c.getTime();
        }
        return season;
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(6, c.getActualMinimum(6));
        return DateUtil.setDayMinTime(c.getTime());
    }

    public static Date getLastDateOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(6, c.getActualMaximum(6));
        return DateUtil.setDayMaxTime(c.getTime());
    }

    public static Date dateFormat(String dateStr) throws ParseException {
        if (dateStr.length() == 23) {
            return DateUtil.parse(FORMAT_FULL, dateStr);
        }
        if (dateStr.length() == 19) {
            return DateUtil.parse(FORMAT_LONG, dateStr);
        }
        if (dateStr.length() == 16) {
            return DateUtil.parse(FORMAT_YYYY_MM_DD_HH_MM, dateStr);
        }
        if (dateStr.length() == 10) {
            return DateUtil.parse(FORMAT_SHORT, dateStr);
        }
        return null;
    }

    public static Date setDayMaxTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, c.getActualMaximum(11));
        c.set(12, c.getActualMaximum(12));
        c.set(13, c.getActualMaximum(13));
        c.set(14, c.getActualMaximum(14));
        return c.getTime();
    }

    public static Date setDayMinTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, c.getActualMinimum(11));
        c.set(12, c.getActualMinimum(12));
        c.set(13, c.getActualMinimum(13));
        c.set(14, c.getActualMinimum(14));
        return c.getTime();
    }

    public static Date dateAddMillisecond(Date date, int num) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(14, num);
        return c.getTime();
    }

    public static List<Date> getDaysBetweenDates(Date startDate, Date endDate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        while (c.getTime().before(endDate)) {
            dates.add(c.getTime());
            c.add(5, 1);
        }
        dates.add(endDate);
        return dates;
    }

    public static List<Date> getDaysOfWeek(Date date) {
        Calendar day = Calendar.getInstance();
        day.setTime(date);
        day.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
        day.set(7, 2);
        Date startDate = day.getTime();
        day.set(7, 1);
        Date endDate = day.getTime();
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        while (c.getTime().before(endDate)) {
            dates.add(c.getTime());
            c.add(5, 1);
        }
        dates.add(endDate);
        return dates;
    }

    public static Date parseDate(SimpleDateFormat sdf, String dateStr) {
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date maxDate(Date date1, Date date2) {
        if (date1.before(date2)) {
            return date2;
        }
        return date1;
    }

    public static Date minDate(Date date1, Date date2) {
        if (date1.before(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date UTC2Local(Date date) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        String utcDate = sdf1.format(date);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        TimeZone utcZone = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(utcZone);
        Date result = null;
        try {
            result = sdf.parse(utcDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date local2UTC(Date localDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        TimeZone utcZone = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(utcZone);
        String utcTime = sdf.format(localDate);
        Date result = null;
        try {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            result = sdf1.parse(utcTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Date> getMonthDyas(Date date) {
        Date currentDate;
        Date monthStart = DateUtil.getFirstDateOfMonth(date);
        Date monthEnd = DateUtil.getLastDateOfMonth(date);
        monthEnd = monthEnd.before(currentDate = new Date()) ? monthEnd : currentDate;
        List<Date> dates = DateUtil.getDaysBetweenDates(monthStart, monthEnd);
        return dates;
    }

    public static String format(String dateFormatStr, Date date) {
        Locale locale = LocaleContextHolder.getLocale();
        return DateUtil.format(dateFormatStr, date, locale);
    }

    public static Date parse(String dateFormatStr, String dateStr) throws ParseException {
        Locale locale = LocaleContextHolder.getLocale();
        return DateUtil.parse(dateFormatStr, dateStr, locale);
    }

    public static String format(String dateFormatStr, Date date, Locale locale) {
        SimpleDateFormat sdf = null;
        sdf = locale != null && !"zh".equals(locale.getLanguage()) ? new SimpleDateFormat(dateFormatStr, locale) : new SimpleDateFormat(dateFormatStr, dateformatSymbols);
        return sdf.format(date);
    }

    public static Date parse(String dateFormatStr, String dateStr, Locale locale) throws ParseException {
        SimpleDateFormat sdf = null;
        sdf = locale != null && !"zh".equals(locale.getLanguage()) ? new SimpleDateFormat(dateFormatStr, locale) : new SimpleDateFormat(dateFormatStr, dateformatSymbols);
        return sdf.parse(dateStr);
    }

    public static int compareDate(String dateFormatStr, String DATE1, String DATE2) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
        try {
            Date dt1 = sdf.parse(DATE1);
            Date dt2 = sdf.parse(DATE2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static int compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static String DateBlockFormatStr(Date date, int min, String dateFormatStr) {
        Date dt2 = DateUtil.addMinutes((Date)date, (int)min);
        return DateUtil.format(dateFormatStr, date) + "-" + DateUtil.format(dateFormatStr, dt2);
    }

    public static boolean isInOpenTime(Date date, Date startDate, Date endDate) {
        boolean flag = true;
        if (flag) {
            return DateUtil.isInBusiness(date, startDate, endDate);
        }
        Calendar date_c = Calendar.getInstance();
        date_c.setTime(date);
        int year = date_c.get(1);
        int month = date_c.get(2);
        int day = date_c.get(5);
        int hour = date_c.get(11);
        Calendar start_c = Calendar.getInstance();
        start_c.setTime(startDate);
        start_c.set(year, month, day);
        int start_hour = start_c.get(11);
        startDate = start_c.getTime();
        Calendar end_c = Calendar.getInstance();
        end_c.setTime(endDate);
        end_c.set(year, month, day);
        endDate = end_c.getTime();
        if (endDate.before(startDate) || endDate.equals(startDate)) {
            Calendar end_n = Calendar.getInstance();
            end_n.setTime(endDate);
            end_n.add(5, 1);
            endDate = end_n.getTime();
        }
        if (DateUtil.compareDate(date, endDate) <= 0) {
            if (DateUtil.compareDate(date, startDate) >= 0) {
                return true;
            }
            return hour == start_hour;
        }
        return false;
    }

    public static boolean isInBusiness(Date counttime, Date startTime, Date endTime) {
        Calendar counttimeCalendar = Calendar.getInstance();
        counttimeCalendar.setTime(counttime);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(startTime);
        int counttimeHour = counttimeCalendar.get(11);
        int counttimeMinute = counttimeCalendar.get(12);
        int startTimeHour = startTimeCalendar.get(11);
        int startTimeMinute = startTimeCalendar.get(12);
        Calendar endTimeCalendar = Calendar.getInstance();
        endTimeCalendar.setTime(endTime);
        int endTimeHour = endTimeCalendar.get(11);
        int endTimeMinute = endTimeCalendar.get(12);
        if (startTimeHour == endTimeHour && startTimeMinute == endTimeMinute) {
            return true;
        }
        if (startTimeHour < endTimeHour || startTimeHour == endTimeHour && startTimeMinute < endTimeMinute) {
            if (counttimeHour < startTimeHour) {
                return false;
            }
            if (counttimeHour == startTimeHour && counttimeMinute < startTimeMinute) {
                return false;
            }
            if (counttimeHour > endTimeHour) {
                return false;
            }
            return counttimeHour != endTimeHour || counttimeMinute <= endTimeMinute;
        }
        if (counttimeHour > startTimeHour) {
            return true;
        }
        if (counttimeHour == startTimeHour && counttimeMinute > startTimeMinute) {
            return true;
        }
        if (counttimeHour < endTimeHour) {
            return true;
        }
        return counttimeHour == endTimeHour && counttimeMinute < endTimeMinute;
    }

    public static void main(String[] args) throws ParseException {
        DateUtil.setFirstDayOfWeek(1);
        Date sundayOfWeek = DateUtil.getSundayOfWeek(new Date());
        System.out.println(DateUtil.format(FORMAT_YYYY_MM_DD_HH_MM, sundayOfWeek));
    }

    static {
        dateformatSymbols.setShortWeekdays(new String[]{"", "\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"});
        FORMAT_YYYY = "yyyy";
        FORMAT_YYYY_CN = "yyyy\u5e74";
        FORMAT_YYYY_MM_DD_HH = "yyyy-MM-dd HH";
        FORMAT_MM_DD_HH = "MM-dd HH";
        FORMAT_DD_HH = "dd HH";
        FORMAT_HH = "HH";
        FORMAT_DAY_OF_WEEK_SORT_CN = "E";
        FORMAT_WEEK_OF_YEAR = "w";
        FORMAT_YYYY_MM = "yyyy-MM";
        FORMAT_YYYY_MM_CN = "yyyy\u5e74MM\u6708";
        FORMAT_MM_DD = "MM-dd";
        FORMAT_MM_DD_E = "MM-dd(E)";
        FORMAT_DD = "dd";
        FORMAT_SHORT = "yyyy-MM-dd";
        FORMAT_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm:ss";
        FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
        FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.S";
        FORMAT_SHORT_CN = "yyyy\u5e74MM\u6708dd\u65e5";
        FORMAT_SHORT_CN_WEEK = "yyyy\u5e74MM\u6708dd\u65e5(E)";
        FORMAT_SHORT_WEEK = "yyyy-MM-dd(E)";
        FORMAT_LONG_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2";
        FORMAT_FULL_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";
        FORMAT_HHMMSS = "HH:mm:ss";
        FORMAT_HHMMSSS = "HH:mm:ss.S";
        FORMAT_HHMM = "HH:mm";
        FIRST_DAY_OF_WEEK = 2;
        weekends = null;
    }
}

