package com.viontech.keliu.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;

public class FileUtil {
	private final static Logger logger = LoggerFactory.getLogger(FileUtil.class);

	/**
	 * 下载文件
	 * @param fileName
	 * @param inputStream
	 * @param request
	 * @param response
	 * @return
	 * @throws IOException
	 */
	public static  Object downfile(String fileName,InputStream inputStream, HttpServletRequest request, HttpServletResponse response) throws IOException{
		 // 清空response 
	       response.reset();
	      // response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes("UTF-8"),"ISO8859-1") + "\"");
	       response.setHeader("Content-Disposition", "attachment;filename="+URLEncoder.encode(fileName,"UTF-8")+";filename*=UTF-8''"+URLEncoder.encode(fileName,"UTF-8"));
	       response.setContentType("application/octet-stream;charset=UTF-8");
	       InputStream in = null;  
	       OutputStream toClient = null;  
	       try{   
	            //以流的形式下载文件   
	           	in = new BufferedInputStream(inputStream);   
	            byte[] buffer = new byte[in.available()];   
	            in.read(buffer);   
	            in.close();  
	              
	            toClient = new BufferedOutputStream(response.getOutputStream());   
	            toClient.write(buffer);   
	            toClient.flush();   
	              
	        }catch(Exception e){ 
	            e.getMessage();
	        }finally{  
	            toClient.close();   
	        }  
	        return null;  
	}

	// 清空已有的文件内容，以便下次重新写入新的内容
    public static void clearFile(String fileName) {
        File file =new File(fileName);
        try {
            if(!file.exists()) {
				createFile(fileName);
            }
            FileWriter fileWriter =new FileWriter(file);
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

	/**
	 * 以字节为单位读取文件，常用于读二进制文件，如图片、声音、影像等文件
	 * @param filePath
	 * @return
	 */
	public static String readFileByBytes(String filePath){
		File file = new File(filePath);
		if(!file.exists() || !file.isFile()){
			return null;
		}
		StringBuffer content = new StringBuffer();
		try {
			byte[] temp = new byte[1024];
			FileInputStream fileInputStream = new FileInputStream(file);
			while(fileInputStream.read(temp) != -1){
				content.append(new String(temp));
				temp = new byte[1024];
			}

			fileInputStream.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return content.toString();
	}

	/**
	 * 以字符为单位读取文件，常用于读文本，数字等类型的文件，支持读取中文
	 * @param filePath
	 * @return
	 */
	public static String readFileByChars(String filePath){
		File file = new File(filePath);
		if(!file.exists() || !file.isFile()){
			return null;
		}

		StringBuffer content = new StringBuffer();
		try {
			char[] temp = new char[1024];
			FileInputStream fileInputStream = new FileInputStream(file);
			InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
			while(inputStreamReader.read(temp) != -1){
				content.append(new String(temp));
				temp = new char[1024];
			}

			fileInputStream.close();
			inputStreamReader.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return content.toString();
	}

	/**
	 * 文件写入
	 * @param filePath
	 * @param content
	 * @throws IOException
	 */
	public static void writeFileByFileWriter(String filePath, String content) throws IOException{
		File file = new File(filePath);
		if(!file.exists()){
			createFile(filePath);
		}
		synchronized (file) {
			BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filePath));
			fos.write(content.getBytes("UTF-8"));
			fos.flush();
			fos.close();
		}
	}

	public static boolean createFile(String destFileName) {
		File file = new File(destFileName);
		if(file.exists()) {
			System.out.println("创建单个文件" + destFileName + "失败，目标文件已存在！");
			return false;
		}
		if (destFileName.endsWith(File.separator)) {
			System.out.println("创建单个文件" + destFileName + "失败，目标文件不能为目录！");
			return false;
		}
		//判断目标文件所在的目录是否存在
		if(!file.getParentFile().exists()) {
			//如果目标文件所在的目录不存在，则创建父目录
			System.out.println("目标文件所在目录不存在，准备创建它！");
			if(!file.getParentFile().mkdirs()) {
				System.out.println("创建目标文件所在目录失败！");
				return false;
			}
		}
		//创建目标文件
		try {
			if (file.createNewFile()) {
				System.out.println("创建单个文件" + destFileName + "成功！");
				return true;
			} else {
				System.out.println("创建单个文件" + destFileName + "失败！");
				return false;
			}
		} catch (IOException e) {
			e.printStackTrace();
			System.out.println("创建单个文件" + destFileName + "失败！" + e.getMessage());
			return false;
		}
	}

	/**
	 * 获取项目部署根目录
	 * @return
	 */
	public static String getBasePath() {
		try {
			return ResourceUtils.getFile("").getAbsolutePath();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return System.getProperty("java.io.tmpdir");
	}

}
