package com.viontech.keliu.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.*;
import java.util.Map.Entry;

public class MapUtil {

	/**
	 * Integer排序
	 * @param hashMap
	 * @param isAsc true升序，false降序
	 * @return
	 */
	 public static ArrayList<Map.Entry<String, Integer>>  sortValueOfInteger(Map<String,Integer> hashMap,final boolean isAsc,Integer getSize) {  
	        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(hashMap.entrySet());
	        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>() {  
	            @Override  
	            public int compare(Entry<java.lang.String, Integer> entry0,Entry<java.lang.String, Integer> entry1) {  
	                if(isAsc)
	                	return entry0.getValue() - entry1.getValue();
	                else 
	                	return entry1.getValue() - entry0.getValue();
	            }  
	        });
	        
	        if(getSize == null){
				return list;
			}else{
				ArrayList<Entry<String, Integer>> gettList = new ArrayList<Map.Entry<String, Integer>>();
				for (int i = 0; i < list.size(); i++) {
					Map.Entry<String, Integer> entry = list.get(i);
					gettList.add(entry);
				    if(i+2 > getSize) break;
				}
				return gettList;
			}
	    }  
	
	/**
	 * Float排序
	 * @param hashMap
	 * @param isAsctrue升序，false降序
	 * @return
	 */
	public static ArrayList<Entry<String, Float>> sortValueOfFloat(Map<String,Float> hashMap,final boolean isAsc,Integer getSize) {
		ArrayList<Entry<String, Float>> list = new ArrayList<Map.Entry<String, Float>>(hashMap.entrySet());
		Collections.sort(list, new Comparator<Map.Entry<String, Float>>() {
			public int compare(Map.Entry<String, Float> entry0,Map.Entry<String, Float> entry1) {
				if(isAsc)
					return entry0.getValue() - entry1.getValue()  >0 ? 1 : -1;
				else   
					return entry0.getValue() - entry1.getValue()  >0 ? -1 : 1;
			}
		});
		
		if(getSize == null){
			return list;
		}else{
			ArrayList<Entry<String, Float>> gettList = new ArrayList<Map.Entry<String, Float>>();
			for (int i = 0; i < list.size(); i++) {
				Map.Entry<String, Float> entry = list.get(i);
				gettList.add(entry);
			    if(i+2 > getSize) break;
			}
			return gettList;
		}
	}
	
	// Bean --> Map 1: 利用Introspector和PropertyDescriptor 将Bean --> Map  
	public static Map<String, Object> transBean2Map(Object obj) {  
	    if (obj == null) {  
	        return null;  
	    }  
	    Map<String, Object> map = new HashMap<String, Object>();  
	    try {  
	        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());  
	        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();  
	        for (PropertyDescriptor property : propertyDescriptors) {  
	            String key = property.getName();  
	            // 过滤class属性  
	            if (!key.equals("class")) {  
	                // 得到property对应的getter方法  
	                Method getter = property.getReadMethod();  
	                Object value = getter.invoke(obj);  
	  
	                map.put(key, value);  
	            }  
	  
	        }  
	    } catch (Exception e) {  
	    	e.printStackTrace();
	    }  
	    return map;  
	}  
	
}
