package com.viontech.keliu.util;

public class JsonMessageUtil {
	/**
	 * 返回成功json信息
	 * 
	 * @param msg
	 *            成功信息
	 * @param data
	 *            对应的数据
	 * @return json消息对象
	 */
	public static JsonMessage getSuccessJsonMsg(String msg, Object data) {
		JsonMessage jsonMessage = getJsonMessageInstance();
		jsonMessage.setSuccess(true);
		jsonMessage.setCode(Constants.APP_CODE_SUCCESS);
		jsonMessage.setMsg(msg);
		jsonMessage.setData(data);
		return jsonMessage;
	}
	public static JsonMessage getSuccessJsonMsg(Object data) {
		return getSuccessJsonMsg("", data);
	}
	public static JsonMessage getSuccessJsonMsg(String msg) {
		return getSuccessJsonMsg(msg, null);
	}
	/**
	 * 返回成功跳转信息
	 * 
	 * @return json消息对象
	 */
	public static JsonMessage getRedirectJsonMsg(String URL) {
		JsonMessage jsonMessage = getJsonMessageInstance();
		jsonMessage.setSuccess(true);
		jsonMessage.setCode(Constants.WEB_CODE_REDIRCET);
		jsonMessage.setData(URL);
		return jsonMessage;
	}

	/**
	 * 返回资源为空json信息
	 * 
	 * @param msg
	 *            成功信息
	 * @return json消息对象
	 */
	public static JsonMessage getResourceEemptyJsonMsg(String msg) {
		JsonMessage jsonMessage = getJsonMessageInstance();
		jsonMessage.setSuccess(true);
		jsonMessage.setCode(Constants.APP_CODE_RESOURCE_EMPTY);
		jsonMessage.setMsg(msg);
		jsonMessage.setData(null);
		return jsonMessage;
	}
	
	/**
	 * 返回失败json信息
	 * 
	 * @param msg
	 *            成功信息
	 * @return json消息对象
	 */
	public static JsonMessage getErrorJsonMsg(String msg) {
		JsonMessage jsonMessage = getJsonMessageInstance();
		jsonMessage.setSuccess(false);
		jsonMessage.setCode(Constants.APP_CODE_ERROR);
		jsonMessage.setMsg(msg);
		jsonMessage.setData(null);
		return jsonMessage;
	}

	/**
	 * 返回失败json信息
	 *
	 * @param msg
	 *            成功信息
	 * @return json消息对象
	 */
	public static JsonMessage getErrorJsonMsg(Integer code,String msg) {
		JsonMessage jsonMessage = getJsonMessageInstance();
		jsonMessage.setSuccess(false);
		jsonMessage.setCode(code);
		jsonMessage.setMsg(msg);
		jsonMessage.setData(null);
		return jsonMessage;
	}
	/**
	 * Json消息对象，用来返回给前台json
	 * 
	 * @author suman 2016年8月15日 上午10:55:05
	 */
	public static JsonMessage getJsonMessageInstance(){
		return new JsonMessageUtil().new JsonMessage();
	}
	public class JsonMessage {
		private boolean success;
		private int code;
		private String msg;
		private Object data;

		public boolean isSuccess() {
			return success;
		}

		public void setSuccess(boolean success) {
			this.success = success;
		}

		public int getCode() {
			return code;
		}

		public void setCode(int code) {
			this.code = code;
		}

		public String getMsg() {
			return msg;
		}

		public void setMsg(String msg) {
			this.msg = msg;
		}

		public Object getData() {
			return data;
		}

		public void setData(Object data) {
			this.data = data;
		}
	}
}

