/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage.convert;

import com.viontech.keliu.storage.convert.Convert;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class BufferedImageConvert
implements Convert<BufferedImage> {
    @Override
    public byte[] object2bytes(BufferedImage bufferedImage) {
        return this.object2bytes(bufferedImage, "jpeg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] object2bytes(BufferedImage bufferedImage, String format) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = this.getImageWriter(format);
            ImageWriteParam param = imageWriter.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
            try {
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, new IIOImage(bufferedImage, null, null), param);
            }
            finally {
                imageWriter.dispose();
                imageOutputStream.flush();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageWriter getImageWriter(String format) {
        if (format == null || format.isEmpty()) {
            format = "jpg";
        }
        return ImageIO.getImageWritersByFormatName(format).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage bytes2Object(byte[] bytes) {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(bytes);
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                assert (in != null);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

