/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.Convert;
import com.viontech.keliu.storage.pathgenerator.PathStorage;

public class OssStorage<T>
extends PathStorage<T> {
    private OssClientHelper ossClientHelper;

    @Override
    public void setItem(String key, T item) {
        Convert<T> convert = this.getConvert();
        byte[] bytes = convert instanceof BufferedImageConvert ? convert.object2bytes(item, key.substring(key.lastIndexOf(".") + 1)) : convert.object2bytes(item);
        this.ossClientHelper.storeFile(this.storagePathGenerator.generator(key), bytes);
    }

    @Override
    public T getItem(String key) {
        try {
            return this.getConvert().bytes2Object(this.getByteArrayItem(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return this.ossClientHelper.getByteArrayImage(this.storagePathGenerator.generator(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isItemExist(String key) {
        return this.ossClientHelper.isExist(this.storagePathGenerator.generator(key));
    }

    @Override
    public boolean deleteItem(String key) {
        return this.ossClientHelper.deleteItem(this.storagePathGenerator.generator(key));
    }

    public OssClientHelper getOssClientHelper() {
        return this.ossClientHelper;
    }

    public void setOssClientHelper(OssClientHelper ossClientHelper) {
        this.ossClientHelper = ossClientHelper;
    }
}

