/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.Convert;
import com.viontech.keliu.storage.pathgenerator.PathStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorage<T>
extends PathStorage<T> {
    private Logger logger = LoggerFactory.getLogger(LocalStorage.class);
    private String basePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String key, T item) {
        OutputStream output = null;
        try {
            File file = new File(this.basePath, this.storagePathGenerator.generator(key));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            output = new FileOutputStream(file);
            Convert<T> convert = this.getConvert();
            byte[] bytes = convert instanceof BufferedImageConvert ? convert.object2bytes(item, key.substring(key.lastIndexOf(".") + 1)) : convert.object2bytes(item);
            output.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.flush();
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public T getItem(String key) {
        return this.getConvert().bytes2Object(this.getByteArrayItem(key));
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        File file = new File(this.basePath, this.storagePathGenerator.generator(key));
        try {
            return this.readFile(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isItemExist(String key) {
        File file = new File(this.basePath, this.storagePathGenerator.generator(key));
        return file.exists();
    }

    @Override
    public boolean deleteItem(String key) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFile(File file) throws IOException {
        try (FileInputStream fi = null;){
            int offset;
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                byte[] byArray = null;
                return byArray;
            }
            fi = new FileInputStream(file);
            byte[] buffer = new byte[(int)fileSize];
            int numRead = 0;
            for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

