/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.IOUtils;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.viontech.keliu.oss.ClientHelper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ClientHelper
implements ClientHelper {
    private final AmazonS3 amazonS3;
    private final String bucket;
    Logger log = LoggerFactory.getLogger(S3ClientHelper.class);

    public S3ClientHelper(String accessKey, String secretKey, String endPoint, String bucket) {
        this.bucket = bucket;
        BasicAWSCredentials credentials = new BasicAWSCredentials(accessKey, secretKey);
        ClientConfiguration config = new ClientConfiguration();
        config.setProtocol(Protocol.HTTP);
        config.setSignerOverride("S3SignerType");
        config.setSocketTimeout(180000);
        config.setMaxConnections(50);
        config.setConnectionTimeout(10000);
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(config)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endPoint, Regions.US_EAST_1.getName()))).enablePathStyleAccess()).build();
    }

    @Override
    public String storeFile(String remoteFile, byte[] content) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        String eTag = this.amazonS3.putObject(this.bucket, remoteFile, (InputStream)inputStream, null).getETag();
        this.addAccessRole(this.bucket, remoteFile);
        return eTag;
    }

    @Override
    public String storeFile(String remoteFile, InputStream stream) {
        String eTag = this.amazonS3.putObject(this.bucket, remoteFile, stream, null).getETag();
        this.addAccessRole(this.bucket, remoteFile);
        return eTag;
    }

    @Override
    public boolean isExist(String key) {
        return this.amazonS3.doesObjectExist(this.bucket, key);
    }

    @Override
    public String getItem(String key) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)this.amazonS3.getObject(this.bucket, key).getObjectContent()));){
            String s;
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            this.log.error("", (Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public byte[] getByteArray(String key) {
        try {
            return IOUtils.readStreamAsByteArray((InputStream)this.amazonS3.getObject(this.bucket, key).getObjectContent());
        }
        catch (IOException e) {
            this.log.error("oss getByteArray error", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public BufferedImage getBufferedImage(String key) {
        try {
            return ImageIO.read((InputStream)this.amazonS3.getObject(this.bucket, key).getObjectContent());
        }
        catch (IOException e) {
            this.log.error("oss getBufferedImage error", (Throwable)e);
            return null;
        }
    }

    @Override
    public InputStream getObjectContent(String key) {
        return this.amazonS3.getObject(this.bucket, key).getObjectContent();
    }

    @Override
    public byte[] getByteArrayImage(String key) {
        try {
            return IOUtils.readStreamAsByteArray((InputStream)this.amazonS3.getObject(this.bucket, key).getObjectContent());
        }
        catch (IOException e) {
            this.log.error("oss getByteArrayImage error", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean deleteItem(String key) {
        try {
            this.amazonS3.deleteObject(this.bucket, key);
            return true;
        }
        catch (ClientException | OSSException e) {
            this.log.error("", e);
            return false;
        }
    }

    public void addAccessRole(String bucketName, String key) {
        AccessControlList objectAcl = this.amazonS3.getObjectAcl(bucketName, key, null);
        Owner owner = objectAcl.getOwner();
        List grantList = objectAcl.getGrantsAsList();
        Grant grant = null;
        for (Grant grant1 : grantList) {
            if (!owner.getId().equals(grant1.getGrantee().getIdentifier())) continue;
            grant = grant1;
            break;
        }
        ArrayList<Grant> allGrants = new ArrayList<Grant>();
        allGrants.add(grant);
        allGrants.add(new Grant((Grantee)GroupGrantee.AllUsers, Permission.FullControl));
        AccessControlList accessControlList = new AccessControlList();
        accessControlList.setOwner(owner);
        accessControlList.grantAllPermissions(allGrants.toArray(new Grant[allGrants.size()]));
        this.amazonS3.setObjectAcl(bucketName, key, null, accessControlList);
    }
}

