/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.ftp;

import com.viontech.keliu.ftp.FTPClientFactory;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClientPool {
    private Logger logger = LoggerFactory.getLogger(FTPClientPool.class);
    private GenericObjectPool<FTPClient> pool;
    private FTPClientFactory clientFactory;

    public FTPClientPool(FTPClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.pool = new GenericObjectPool((PooledObjectFactory)clientFactory, (GenericObjectPoolConfig)clientFactory.getFtpPoolConfig());
    }

    public FTPClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public GenericObjectPool<FTPClient> getPool() {
        return this.pool;
    }

    public FTPClient borrowObject() throws Exception {
        FTPClient client = (FTPClient)this.pool.borrowObject();
        boolean valid = true;
        try {
            valid = client.isConnected() ? client.sendNoOp() : false;
        }
        catch (IOException e) {
            this.logger.error("\u4ec0\u4e48\u60c5\u51b5 \u521a\u521a\u83b7\u53d6\u7684\u5bf9\u8c61\u5c31\u4e0d\u53ef\u7528\uff0c", (Throwable)e);
            e.printStackTrace();
            valid = false;
        }
        if (!valid) {
            try {
                client.logout();
                client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pool.invalidateObject((Object)client);
        }
        return client;
    }

    public void returnObject(FTPClient ftpClient) {
        if (ftpClient != null) {
            try {
                this.pool.returnObject((Object)ftpClient);
            }
            catch (Exception e) {
                this.logger.error("\u5c06FTP\u5f52\u8fd8\u5230FTP\u6c60\u4e2d\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

