/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.ftp;

import com.viontech.keliu.ftp.FtpPoolConfig;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClientFactory
extends BasePooledObjectFactory<FTPClient> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private FtpPoolConfig ftpPoolConfig;

    public FtpPoolConfig getFtpPoolConfig() {
        return this.ftpPoolConfig;
    }

    public void setFtpPoolConfig(FtpPoolConfig ftpPoolConfig) {
        this.ftpPoolConfig = ftpPoolConfig;
    }

    public FTPClient create() throws Exception {
        FTPClient ftpClient = new FTPClient();
        ftpClient.setConnectTimeout(this.ftpPoolConfig.getConnectTimeOut());
        try {
            this.logger.info("\u8fde\u63a5ftp\u670d\u52a1\u5668:" + this.ftpPoolConfig.getHost() + ":" + this.ftpPoolConfig.getPort());
            ftpClient.connect(this.ftpPoolConfig.getHost(), this.ftpPoolConfig.getPort());
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftpClient.disconnect();
                this.logger.error("FTPServer \u62d2\u7edd\u8fde\u63a5");
                return null;
            }
            boolean result = ftpClient.login(this.ftpPoolConfig.getUsername(), this.ftpPoolConfig.getPassword());
            if (!result) {
                throw new Exception("ftpClient\u767b\u5f55\u5931\u8d25! userName:" + this.ftpPoolConfig.getUsername() + ", password:" + this.ftpPoolConfig.getPassword());
            }
            ftpClient.setControlEncoding(this.ftpPoolConfig.getControlEncoding());
            ftpClient.setBufferSize(this.ftpPoolConfig.getBufferSize());
            ftpClient.setFileType(this.ftpPoolConfig.getFileType());
            ftpClient.setDataTimeout(this.ftpPoolConfig.getDataTimeout());
            if (this.ftpPoolConfig.isPassiveMode()) {
                this.logger.info("\u8fdb\u5165ftp\u88ab\u52a8\u6a21\u5f0f");
                ftpClient.enterLocalPassiveMode();
            }
        }
        catch (IOException e) {
            this.logger.error("FTP\u8fde\u63a5\u5931\u8d25\uff1a", (Throwable)e);
        }
        return ftpClient;
    }

    public PooledObject<FTPClient> wrap(FTPClient ftpClient) {
        return new DefaultPooledObject((Object)ftpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(PooledObject<FTPClient> p) throws Exception {
        FTPClient ftpClient = (FTPClient)p.getObject();
        try {
            if (ftpClient != null && ftpClient.isConnected()) {
                ftpClient.logout();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    public boolean validateObject(PooledObject<FTPClient> p) {
        FTPClient ftpClient = (FTPClient)p.getObject();
        boolean connect = false;
        try {
            connect = ftpClient.sendNoOp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return connect;
    }

    public void activateObject(PooledObject<FTPClient> p) throws Exception {
        FTPClient ftpClient = (FTPClient)p.getObject();
        if (!this.validateObject(p)) {
            ftpClient.reinitialize();
        }
        if (!this.validateObject(p)) {
            throw new RuntimeException("ftp\u5df2\u7ecf\u5931\u6548");
        }
    }

    public void passivateObject(PooledObject<FTPClient> p) throws Exception {
    }
}

