/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FtpPoolConfig;
import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.oss.S3ClientHelper;
import com.viontech.keliu.storage.LocalStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={OssClientHelper.class, S3ClientHelper.class, FtpPoolConfig.class})
public class LocalStorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LocalStorageConfiguration.class);

    @Bean(value={"imageStorage"})
    @ConditionalOnMissingBean(name={"imageStorage"})
    public Storage localImageStorage(StoragePathGenerator imagePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<BufferedImage> localImageStorage = new LocalStorage<BufferedImage>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local imageStorage==================");
        localImageStorage.setBasePath(path);
        localImageStorage.setConvert(new BufferedImageConvert());
        localImageStorage.setStoragePathGenerator(imagePathGenerator);
        return localImageStorage;
    }

    @Bean(value={"simpleStringStorage"})
    @ConditionalOnMissingBean(name={"simpleStringStorage"})
    public Storage localSimpleStringStorage(StoragePathGenerator simplePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<String> localSimpleStorage = new LocalStorage<String>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local simpleStringStorage==================");
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new StringConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    @Bean(value={"simpleImageStorage"})
    @ConditionalOnMissingBean(name={"simpleImageStorage"})
    public Storage localSimpleImageStorage(StoragePathGenerator simplePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<BufferedImage> localSimpleStorage = new LocalStorage<BufferedImage>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local simpleImageStorage==================");
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new BufferedImageConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnMissingBean(name={"featureStorage"})
    public Storage localFeatureStorage(StoragePathGenerator featurePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<String> localFeatureStorage = new LocalStorage<String>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local featureStorage==================");
        localFeatureStorage.setBasePath(path);
        localFeatureStorage.setConvert(new StringConvert());
        localFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return localFeatureStorage;
    }

    @Bean(value={"simpleByteArrayStorage"})
    @ConditionalOnMissingBean(name={"simpleByteArrayStorage"})
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<byte[]> localSimpleStorage = new LocalStorage<byte[]>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("================local simpleByteArrayStorage==================");
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new ByteArrayConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    @Bean(value={"byteArrayStorage"})
    @ConditionalOnMissingBean(name={"byteArrayStorage"})
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<byte[]> localStorage = new LocalStorage<byte[]>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        logger.info("=============local byteArrayStorage==================");
        localStorage.setBasePath(path);
        localStorage.setConvert(new ByteArrayConvert());
        localStorage.setStoragePathGenerator(imagePathGenerator);
        return localStorage;
    }
}

