/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.storage.FtpStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={FTPClientHelper.class})
public class FtpStorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FtpStorageConfiguration.class);

    @Bean(value={"imageStorage"})
    @ConditionalOnMissingBean(name={"imageStorage"})
    public Storage ftpImageStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP imageStorage==================");
        FtpStorage<BufferedImage> ftpImageStorage = new FtpStorage<BufferedImage>();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setConvert(new BufferedImageConvert());
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    @Bean(value={"simpleStringStorage"})
    @ConditionalOnMissingBean(name={"simpleStringStorage"})
    public Storage ftpSimpleStringStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP simpleStringStorage==================");
        FtpStorage<BufferedImage> simpleStorage = new FtpStorage<BufferedImage>();
        simpleStorage.setFtpClientHelper(ftpClientHelper);
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnMissingBean(name={"featureStorage"})
    public Storage ftpFeatureStorage(StoragePathGenerator featurePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP featureStorage==================");
        FtpStorage<String> ftpFeatureStorage = new FtpStorage<String>();
        ftpFeatureStorage.setFtpClientHelper(ftpClientHelper);
        ftpFeatureStorage.setConvert(new StringConvert());
        ftpFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ftpFeatureStorage;
    }

    @Bean(value={"simpleImageStorage"})
    @ConditionalOnMissingBean(name={"simpleImageStorage"})
    public Storage ftpSimpleImageStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP simpleImageStorage==================");
        FtpStorage<BufferedImage> simpleImageStorage = new FtpStorage<BufferedImage>();
        simpleImageStorage.setFtpClientHelper(ftpClientHelper);
        simpleImageStorage.setConvert(new BufferedImageConvert());
        simpleImageStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleImageStorage;
    }

    @Bean(value={"byteArrayStorage"})
    @ConditionalOnMissingBean(name={"byteArrayStorage"})
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP byteArrayStorage==================");
        FtpStorage<byte[]> ftpImageStorage = new FtpStorage<byte[]>();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setConvert(new ByteArrayConvert());
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    @Bean(value={"simpleByteArrayStorage"})
    @ConditionalOnMissingBean(name={"simpleByteArrayStorage"})
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP simpleByteArrayStorage==================");
        FtpStorage<byte[]> simpleImageStorage = new FtpStorage<byte[]>();
        simpleImageStorage.setFtpClientHelper(ftpClientHelper);
        simpleImageStorage.setConvert(new ByteArrayConvert());
        simpleImageStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleImageStorage;
    }
}

