package com.viontech.keliu.storage.convert;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Created by 苏曼 on 2019/3/26.
 */
public class BufferedImageConvert implements Convert<BufferedImage> {

    @Override
    public byte[] object2bytes(BufferedImage bufferedImage) {
        return object2bytes(bufferedImage, "jpeg");
    }

    @Override
    public byte[] object2bytes(BufferedImage bufferedImage, String format) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = getImageWriter(format);
            ImageWriteParam param = imageWriter.getDefaultWriteParam();
            param.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
            param.setCompressionQuality(1.0F);
            try {
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, new IIOImage(bufferedImage, null, null), param);

            } finally {
                imageWriter.dispose();
                imageOutputStream.flush();
            }
            return byteArrayOutputStream.toByteArray();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ImageWriter getImageWriter(String format) {
        if (format == null || format.isEmpty()) {
            format = "jpg";
        }
        return ImageIO.getImageWritersByFormatName(format).next();
    }

    @Override
    public BufferedImage bytes2Object(byte[] bytes) {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(bytes);
            return ImageIO.read(in);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                assert in != null;
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
