package com.viontech.keliu.storage;

import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.Convert;
import com.viontech.keliu.storage.pathgenerator.PathStorage;

/**
 * @author 谢明辉
 * @createDate 2018-10-27
 * @description
 */

public class OssStorage<T> extends PathStorage<T> {
    private OssClientHelper ossClientHelper;

    @Override
    public void setItem(String key, T item) {
        Convert<T> convert = getConvert();
        byte[] bytes;
        if (convert instanceof BufferedImageConvert) {
            bytes = convert.object2bytes(item, key.substring(key.lastIndexOf(".") + 1));
        } else {
            bytes = convert.object2bytes(item);
        }
        ossClientHelper.storeFile(storagePathGenerator.generator(key), bytes);
    }

    @Override
    public T getItem(String key) {
        try {
            return getConvert().bytes2Object(getByteArrayItem(key));
        } catch (Exception e) {

        }
        return null;
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return ossClientHelper.getByteArrayImage(storagePathGenerator.generator(key));
        } catch (Exception e) {

        }
        return null;
    }

    @Override
    public boolean isItemExist(String key) {
        return ossClientHelper.isExist(storagePathGenerator.generator(key));
    }

    @Override
    public boolean deleteItem(String key) {
        return ossClientHelper.deleteItem(storagePathGenerator.generator(key));
    }


    public OssClientHelper getOssClientHelper() {
        return ossClientHelper;
    }

    public void setOssClientHelper(OssClientHelper ossClientHelper) {
        this.ossClientHelper = ossClientHelper;
    }
}
