package com.viontech.keliu.storage;

import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.storage.pathgenerator.PathStorage;

public class FtpStorage<T> extends PathStorage<T> {
    private FTPClientHelper ftpClientHelper;

    @Override
    public void setItem(String key, T item) {
        try {
            ftpClientHelper.storeFile(storagePathGenerator.generator(key), getConvert().object2bytes(item));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public T getItem(String key) {
        return getConvert().bytes2Object(getByteArrayItem(key));
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        return ftpClientHelper.retrieveFileStream(storagePathGenerator.generator(key));
    }

    @Override
    public boolean isItemExist(String key) {
        return ftpClientHelper.isExist(storagePathGenerator.generator(key));
    }

    @Override
    public boolean deleteItem(String key) {
        return false;
    }

    public FTPClientHelper getFtpClientHelper() {
        return ftpClientHelper;
    }

    public void setFtpClientHelper(FTPClientHelper ftpClientHelper) {
        this.ftpClientHelper = ftpClientHelper;
    }
}
