package com.viontech.keliu.configuration;

import com.viontech.keliu.oss.OssClientHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OssConfiguration {

    public OssConfiguration() {

    }

    @Value("${oss.config.endPoint:}")
    private String endPoint;
    @Value("${oss.config.accessKeyId:}")
    private String accessKeyId;
    @Value("${oss.config.accessKeySecret:}")
    private String accessKeySecret;
    @Value("${oss.config.bucket:}")
    private String bucket;


    @Bean("ossClientHelper")
    @ConditionalOnProperty("oss.config.bucket")
    public OssClientHelper ossClientHelper() {
        OssClientHelper helper = new OssClientHelper();
        helper.setKey(accessKeyId);
        helper.setSecret(accessKeySecret);
        helper.setBucket(bucket);
        helper.setEndPoint(endPoint);
        return helper;
    }
}
