package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.storage.FtpStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/29
 */
@Configuration
@ConditionalOnBean(FTPClientHelper.class)
public class FtpStorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FtpStorageConfiguration.class);

    /**
     * 配置一个FTP图片存储器
     */
    @Bean("imageStorage")
    @ConditionalOnMissingBean(name = "imageStorage")
    public Storage ftpImageStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP imageStorage==================");
        FtpStorage ftpImageStorage = new FtpStorage();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setConvert(new BufferedImageConvert());
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    /**
     * 配置一个轨迹文件存储器
     */
    @Bean("simpleStringStorage")
    @ConditionalOnMissingBean(name = "simpleStringStorage")
    public Storage ftpSimpleStringStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP simpleStringStorage==================");
        FtpStorage simpleStorage = new FtpStorage();
        simpleStorage.setFtpClientHelper(ftpClientHelper);
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    /**
     * 配置一个特征文件存储器
     */
    @Bean("featureStorage")
    @ConditionalOnMissingBean(name = "featureStorage")
    public Storage ftpFeatureStorage(StoragePathGenerator featurePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP featureStorage==================");
        FtpStorage ftpFeatureStorage = new FtpStorage();
        ftpFeatureStorage.setFtpClientHelper(ftpClientHelper);
        ftpFeatureStorage.setConvert(new StringConvert());
        ftpFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ftpFeatureStorage;
    }

    /**
     * 配置一个轨迹文件存储器
     */
    @Bean("simpleImageStorage")
    @ConditionalOnMissingBean(name = "simpleImageStorage")
    public Storage ftpSimpleImageStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP simpleImageStorage==================");
        FtpStorage simpleImageStorage = new FtpStorage();
        simpleImageStorage.setFtpClientHelper(ftpClientHelper);
        simpleImageStorage.setConvert(new BufferedImageConvert());
        simpleImageStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleImageStorage;
    }


    /**
     * 配置一个FTP图片存储器
     */
    @Bean("byteArrayStorage")
    @ConditionalOnMissingBean(name = "byteArrayStorage")
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP byteArrayStorage==================");
        FtpStorage ftpImageStorage = new FtpStorage();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setConvert(new ByteArrayConvert());
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    /**
     * 配置一个轨迹文件存储器
     */
    @Bean("simpleByteArrayStorage")
    @ConditionalOnMissingBean(name = "simpleByteArrayStorage")
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info("=============FTP simpleByteArrayStorage==================");
        FtpStorage simpleImageStorage = new FtpStorage();
        simpleImageStorage.setFtpClientHelper(ftpClientHelper);
        simpleImageStorage.setConvert(new ByteArrayConvert());
        simpleImageStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleImageStorage;
    }


}
