/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.i18n.util;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class LocalMessageUtil {
    private static final Logger logger = LoggerFactory.getLogger(LocalMessageUtil.class);
    @Autowired(required=false)
    private static MessageSource messageSource;
    private static ThreadLocal<String> defaultLanguage;

    public static String getDefaultLanguage() {
        return defaultLanguage.get();
    }

    public static void setDefaultLanguage(String language) {
        defaultLanguage.set(language);
    }

    @Autowired(required=false)
    public void setMessageSource(MessageSource messageSource) {
        LocalMessageUtil.messageSource = messageSource;
    }

    public static String getMessage(String code) {
        return LocalMessageUtil.getMessage(code, new Object[0]);
    }

    public static String getMessage(String code, Class clazz) {
        return LocalMessageUtil.getMessage(code, new Object[0], clazz);
    }

    public static String getMessage(String code, Locale locale) {
        return LocalMessageUtil.getMessage(code, locale);
    }

    public static String getMessage(String code, Locale locale, Class clazz) {
        return LocalMessageUtil.getMessage(code, new Object[0], locale, clazz);
    }

    public static String getMessage(String code, Object[] args) {
        Locale locale = LocaleContextHolder.getLocale();
        String language = defaultLanguage.get();
        if (language != null && !language.isEmpty()) {
            String[] split = language.split("_");
            locale = new Locale(split[0], split[1]);
        }
        return LocalMessageUtil.getMessage(code, args, locale);
    }

    public static String getMessage(String code, Object[] args, Class clazz) {
        Locale locale = LocaleContextHolder.getLocale();
        String language = defaultLanguage.get();
        if (language != null && !language.isEmpty()) {
            String[] split = language.split("_");
            locale = new Locale(split[0], split[1]);
        }
        return LocalMessageUtil.getMessage(code, args, locale, clazz);
    }

    public static String getMessage(String code, Object[] args, Locale locale) {
        return LocalMessageUtil.getMessage(code, args, locale, null);
    }

    public static String getMessage(String code, Object[] args, Locale locale, Class clazz) {
        String clasCode = LocalMessageUtil.buildKey(code, clazz);
        String result = "";
        try {
            result = messageSource.getMessage(clasCode, args, locale);
        }
        catch (NoSuchMessageException e) {
            try {
                result = messageSource.getMessage(code, args, locale);
            }
            catch (NoSuchMessageException noSuchMessageException) {
                // empty catch block
            }
        }
        defaultLanguage.remove();
        return result;
    }

    public static String buildKey(String code, Class clazz) {
        if (clazz == null) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getSimpleName()).append(".").append(code);
        return sb.toString();
    }

    static {
        defaultLanguage = new ThreadLocal();
    }
}

