/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.i18n.service;

import com.viontech.keliu.i18n.model.Message;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
public class I18NService {
    @Autowired(required=false)
    private ResourceBundleMessageSource messageSource;

    public void getLocal() {
        this.messageSource.getParentMessageSource();
    }

    public boolean updateMessage(Message message) {
        Set basenameSet = this.messageSource.getBasenameSet();
        boolean result = false;
        if (message.getLocale() == null) {
            return false;
        }
        for (String basename : basenameSet) {
            result = this.updateMessage(basename, message.getLocale(), message.getKey(), message.getValue());
        }
        return result;
    }

    private boolean updateMessage(String baseName, Locale localeVal, String key, String value) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, localeVal);
        Locale locale = resourceBundle.getLocale();
        Properties properties = new Properties();
        try {
            URL resource = ClassUtils.getDefaultClassLoader().getResource(baseName + "_" + locale.toString() + ".properties");
            properties.load(ClassUtils.getDefaultClassLoader().getResourceAsStream(baseName + "_" + locale.toString() + ".properties"));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(resource.toURI())));
            properties.setProperty(key, value);
            properties.store(bufferedOutputStream, "");
            resourceBundle.clearCache();
        }
        catch (IOException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public Set<Locale> getSupportLocales() {
        HashSet<Locale> results = new HashSet<Locale>();
        Set basenameSet = this.messageSource.getBasenameSet();
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        Iterator iterator = basenameSet.iterator();
        while (iterator.hasNext()) {
            String basename;
            String folder = basename = (String)iterator.next();
            if (basename.contains("/")) {
                folder = basename.substring(0, basename.lastIndexOf("/"));
            } else if (basename.contains("\\")) {
                folder = basename.substring(0, basename.lastIndexOf("\\"));
            }
            URL resource = classLoader.getResource(folder);
            try {
                File[] files;
                File file = new File(resource.toURI());
                if (file.isFile()) continue;
                for (File f : files = file.listFiles()) {
                    Locale locale;
                    String fileName = f.getName();
                    if (fileName.indexOf("_") == -1) {
                        results.add(Locale.getDefault());
                        continue;
                    }
                    String localeStr = fileName.substring(fileName.indexOf("_") + 1, fileName.lastIndexOf(".properties"));
                    if (localeStr.contains("_")) {
                        locale = new Locale(localeStr.split("_")[0], localeStr.split("_")[1]);
                        results.add(locale);
                        continue;
                    }
                    locale = new Locale(localeStr);
                    results.add(locale);
                }
            }
            catch (URISyntaxException e) {
            }
        }
        return results;
    }

    public Collection<Map<String, String>> getMessages() {
        Set<Locale> supportLocales = this.getSupportLocales();
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>();
        for (Locale locale : supportLocales) {
            Set<Message> messages = this.getMessages(locale);
            for (Message message : messages) {
                HashMap<String, String> map = (HashMap<String, String>)result.get(message.getKey());
                if (map == null) {
                    map = new HashMap<String, String>();
                    result.put(message.getKey(), map);
                    map.put("key", message.getKey());
                }
                map.put(message.getLocale().toString(), message.getValue());
            }
        }
        return result.values();
    }

    public Set<Message> getMessages(Locale locale) {
        HashSet<Message> results = new HashSet<Message>();
        Set basenameSet = this.messageSource.getBasenameSet();
        for (String basename : basenameSet) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(basename, locale);
            Enumeration<String> keys = resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = resourceBundle.getString(key);
                Message message = new Message();
                message.setLocale(locale);
                message.setKey(key);
                message.setValue(value);
                results.add(message);
            }
        }
        return results;
    }

    public Locale buildLocale(String localeStr) {
        if (localeStr.contains("_")) {
            return new Locale(localeStr.split("_")[0], localeStr.split("_")[1]);
        }
        return new Locale(localeStr);
    }
}

