/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.i18n.controller;

import com.viontech.keliu.i18n.model.Message;
import com.viontech.keliu.i18n.service.I18NService;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.JsonMessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/i18n"})
public class I18NController {
    @Autowired(required=false)
    private I18NService i18nService;

    @RequestMapping(value={"/messages"}, method={RequestMethod.GET})
    public Object messages() {
        return JsonMessageUtil.getSuccessJsonMsg(this.i18nService.getMessages());
    }

    @RequestMapping(value={"/messages/{locale}"}, method={RequestMethod.POST})
    public Object updateMessages(@PathVariable(value="locale") String localeStr, @RequestBody Message message) {
        message.setLocale(this.i18nService.buildLocale(localeStr));
        this.i18nService.updateMessage(message);
        return JsonMessageUtil.getSuccessJsonMsg(this.i18nService.getMessages());
    }

    @RequestMapping(value={"/messages/{locale}"}, method={RequestMethod.GET})
    public Object messages(@PathVariable(value="locale") String localeStr) {
        return JsonMessageUtil.getSuccessJsonMsg(this.i18nService.getMessages(this.i18nService.buildLocale(localeStr)));
    }

    @RequestMapping(value={"/supportLocales"}, method={RequestMethod.GET})
    public Object supportLocales() {
        return JsonMessageUtil.getSuccessJsonMsg(this.i18nService.getSupportLocales());
    }

    @RequestMapping(value={"/hello"}, method={RequestMethod.GET})
    public Object hello() {
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage("update"));
    }
}

