package com.viontech.keliu.i18n.service;

import com.viontech.keliu.i18n.model.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.*;

@Service
public class I18NService {
	@Autowired(required = false)
	private ResourceBundleMessageSource messageSource;
	
	public void getLocal(){
		messageSource.getParentMessageSource();
	}
	
	public boolean updateMessage(Message message){
		Set<String> basenameSet = messageSource.getBasenameSet();
		boolean result = false;
		if(message.getLocale() == null){
			return false;
		}
		for (String basename : basenameSet) {
			result =updateMessage(basename,message.getLocale(),message.getKey(),message.getValue());
		}
		return result;
		
	}
	
	private boolean updateMessage(String baseName,Locale localeVal,String key,String value){
		ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName,localeVal);
		
		Locale locale = resourceBundle.getLocale();
		Properties properties = new Properties();
		try {
			URL resource = ClassUtils.getDefaultClassLoader().getResource(baseName+"_"+locale.toString()+".properties");
			properties.load(ClassUtils.getDefaultClassLoader().getResourceAsStream(baseName+"_"+locale.toString()+".properties"));
			BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(resource.toURI())));
			properties.setProperty(key,value);
			properties.store(bufferedOutputStream, "");
			resourceBundle.clearCache();
		} catch (IOException e) {
			return false;
		} catch (URISyntaxException e) {
			return false;
		}
	
		return true;
	}
	
	public Set<Locale> getSupportLocales(){
		Set<Locale> results = new HashSet<Locale>();
		Set<String> basenameSet = messageSource.getBasenameSet();
		ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
		ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
		for (String basename : basenameSet) {
			String folder = folder = basename;
			if(basename.contains("/")){//如果路径是/分隔的
				folder = basename.substring(0,basename.lastIndexOf("/"));//截取文件夹路径
			}else if(basename.contains("\\")){//如果路径是\分隔的
				folder = basename.substring(0,basename.lastIndexOf("\\"));//截取文件路径
			}
			URL resource = classLoader.getResource(folder);//加载文件夹的URL
			try {          
				File file = new File(resource.toURI());//得到文件夹路径
				if(file.isFile()){
					continue;
				}
				//如果是目录
				File[] files = file.listFiles();
				for (File f : files) {
					String fileName = f.getName();
					if(fileName.indexOf("_") == -1){
						results.add(Locale.getDefault());
						continue;
					}
					String localeStr = fileName.substring(fileName.indexOf("_")+1,fileName.lastIndexOf(".properties"));
					if(localeStr.contains("_")){
						Locale locale = new Locale(localeStr.split("_")[0], localeStr.split("_")[1]);
						results.add(  locale);
					}else{
						Locale locale = new Locale(localeStr);
						results.add(locale);
					}
				}
			} catch (URISyntaxException e) {
				continue;
			}
			
		}
		return results;
		
	}

	public Collection<Map<String, String>> getMessages() {
		Set<Locale> supportLocales = getSupportLocales();
		//
		Map<String,Map<String,String>> result = new HashMap<String, Map<String,String>>();
		
		for (Locale locale : supportLocales) {
			Set<Message> messages = getMessages(locale);
			for (Message message : messages) {
				Map<String, String> map = result.get(message.getKey());
				if(map == null){
					map = new HashMap<String, String>();
					result.put(message.getKey(), map);
					map.put("key",message.getKey());
				}
				map.put(message.getLocale().toString(),message.getValue());
			}
		}
		return result.values();
		
	}
	public Set<Message> getMessages(Locale locale) {
		Set<Message> results = new HashSet<Message>();
		Set<String> basenameSet = messageSource.getBasenameSet();
		for (String basename : basenameSet) {
			ResourceBundle resourceBundle = ResourceBundle.getBundle(basename, locale);
			Enumeration<String> keys = resourceBundle.getKeys();
		
			
			while(keys.hasMoreElements()){
				String key = keys.nextElement();
				String value = resourceBundle.getString(key);
				Message message = new Message();
				message.setLocale(locale);
				message.setKey(key);
				message.setValue(value);
				results.add(message);
			}
		
		}
		return results;
		
	}
	
	public Locale buildLocale(String localeStr){
		if(localeStr.contains("_")){
			return  new Locale(localeStr.split("_")[0], localeStr.split("_")[1]);
		}else{
			return new Locale(localeStr);
		}
	}
}
