package com.viontech.keliu.i18n.controller;

import com.viontech.keliu.i18n.model.Message;
import com.viontech.keliu.i18n.service.I18NService;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import static com.viontech.keliu.util.JsonMessageUtil.getSuccessJsonMsg;

@RestController
@RequestMapping("/i18n")
public class I18NController {
	@Autowired(required = false)
	private I18NService i18nService;
	
	@RequestMapping(value="/messages",method={RequestMethod.GET})
	public Object messages(){
		return getSuccessJsonMsg(i18nService.getMessages());
	}
	@RequestMapping(value="/messages/{locale}",method={RequestMethod.POST})
	public Object updateMessages(@PathVariable("locale") String localeStr,@RequestBody Message message){
		message.setLocale(i18nService.buildLocale(localeStr));
		i18nService.updateMessage(message);
		return getSuccessJsonMsg(i18nService.getMessages());
	}

	@RequestMapping(value="/messages/{locale}",method={RequestMethod.GET})
	public Object messages(@PathVariable("locale") String localeStr){
		return getSuccessJsonMsg(i18nService.getMessages(i18nService.buildLocale(localeStr)));
	}

	@RequestMapping(value="/supportLocales",method={RequestMethod.GET})
	public Object supportLocales(){
		return getSuccessJsonMsg(i18nService.getSupportLocales());
	}

	@RequestMapping(value="/hello",method={RequestMethod.GET})
	public Object hello(){
		return getSuccessJsonMsg(LocalMessageUtil.getMessage("update"));
	}
	
}
