package com.viontech.keliu.i18n.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import java.util.Locale;

/**
 * 
 * 国际化工具类
 * 
 * @author 苏曼
 * 
 * @version v.0.1
 * 
 * @date 2016年8月5日下午2:44:03
 * 
 */

@Component
public class LocalMessageUtil {
	private final static  Logger logger = LoggerFactory.getLogger(LocalMessageUtil.class);

	@Autowired(required = false)
	private static MessageSource messageSource;


	private static ThreadLocal<String> defaultLanguage = new ThreadLocal<>();

	public static String getDefaultLanguage() {
		return defaultLanguage.get();
	}

	public static void setDefaultLanguage(String language) {
		defaultLanguage.set(language);
	}


	@Autowired(required = false)
    public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;  
    }  

	public static String getMessage(String code) {

		return getMessage(code, new Object[] {});

	}

	public static String getMessage(String code,Class clazz) {

		return getMessage(code, new Object[] {},clazz);

	}
	
	public static String getMessage(String code, Locale locale) {

		return getMessage(code, locale);

	}
	
	public static String getMessage(String code, Locale locale,Class clazz) {

		return getMessage(code,  new Object[] {},locale,clazz);

	}

	/**
	 *
	 * 
	 * 
	 * @param code：对应messages配置的key.
	 * 
	 * @param args
	 *            :数组参数.
	 * 
	 * @return
	 * 
	 */

	public static String getMessage(String code, Object[] args) {
		Locale locale = LocaleContextHolder.getLocale();
		String language = defaultLanguage.get();
		if (language != null && !language.isEmpty()){
			String[] split = language.split("_");
			locale = new Locale(split[0],split[1]);
		}
		return getMessage(code, args,locale);

	}
	
	public static String getMessage(String code, Object[] args,Class clazz) {
		Locale locale = LocaleContextHolder.getLocale();
		String language = defaultLanguage.get();
		if (language != null && !language.isEmpty()){
			String[] split = language.split("_");
			locale = new Locale(split[0],split[1]);
		}
		return getMessage(code, args,locale,clazz);

	}


	
	/**
	 * 
	 * 指定语言.
	 * 
	 * @param code
	 * 
	 * @param args
	 * 
	 * @param locale
	 * 
	 * @return
	 * 
	 */

	public static String getMessage(String code, Object[] args, Locale locale) {
		return getMessage(code, args, locale,null);

	}
	public static String getMessage(String code, Object[] args, Locale locale,Class clazz) {
		String clasCode = buildKey(code, clazz);
		String result = "";
		try {
			result =  messageSource.getMessage(clasCode, args, locale);
		} catch (NoSuchMessageException e) {
			try {
				result =  messageSource.getMessage(code, args, locale);
			} catch (NoSuchMessageException e1) {
				//e1.printStackTrace();
			}
		}
		return result;

	}
	
	public static String buildKey(String code,Class clazz){
		if(clazz == null){
			return code;
		}
		StringBuilder sb = new StringBuilder();
		sb.append(clazz.getSimpleName()).append(".").append(code);
		return sb.toString();
	}

}