/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class ExampleGenerator
extends AbstractJavaGenerator {
    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.6", table.toString()));
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        TopLevelClass topLevelClass = new TopLevelClass(type);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType superType = new FullyQualifiedJavaType(this.context.getBaseExampleName());
        topLevelClass.setSuperClass(superType);
        topLevelClass.addImportedType(superType);
        commentGenerator.addJavaFileComment(topLevelClass);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setConstructor(true);
        method.setName(type.getShortName());
        method.addBodyLine("super();");
        method.addBodyLine("tableName = \"" + this.introspectedTable.getActualTableName().getTableName() + "\";");
        method.addBodyLine("tableAlias = \"" + this.introspectedTable.getFullyQualifiedTable().getAlias() + "\";");
        method.addBodyLine("ignoreCase = false;");
        commentGenerator.addGeneralMethodComment(method, this.introspectedTable);
        topLevelClass.addMethod(method);
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getAllColumns()) {
            IntrospectedTable introspectedImportTable;
            IntrospectedColumn introspectedImportColumn = introspectedColumn.getIntrospectedImportColumn();
            if (introspectedImportColumn == null || (introspectedImportTable = introspectedImportColumn.getIntrospectedTable()).equals(this.introspectedTable)) continue;
            method = this.getCreateOtherExampleColumnsMethod(introspectedImportTable);
            commentGenerator.addGeneralMethodComment(method, this.introspectedTable);
            topLevelClass.addMethod(method);
            topLevelClass.addMethod(this.getAndOtherExampleCriteriaMethod(introspectedImportTable));
            topLevelClass.addMethod(this.getOrOtherExampleCriteriaMethod(introspectedImportTable));
            topLevelClass.addMethod(this.getAndOtherExampleCriteriaMethodWithCriteria(introspectedImportTable));
        }
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("or");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = createCriteriaInternal();");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, this.introspectedTable);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("createCriteria");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = createCriteriaInternal();");
        method.addBodyLine("if (oredCriteria.size() == 0) {");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("}");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, this.introspectedTable);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("createCriteriaInternal");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = new Criteria(this.tableName,this.ignoreCase);");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, this.introspectedTable);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("createColumns");
        method.setReturnType(FullyQualifiedJavaType.getColumnContainerInstance());
        method.addBodyLine("ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);");
        method.addBodyLine("if(columnContainer == null){");
        method.addBodyLine("columnContainer = new ColumnContainer(this.tableName);");
        method.addBodyLine("columnContainerMap.put(this.tableName,columnContainer);");
        method.addBodyLine("}");
        method.addBodyLine("return (ColumnContainer)columnContainer;");
        commentGenerator.addGeneralMethodComment(method, this.introspectedTable);
        topLevelClass.addMethod(method);
        topLevelClass.addInnerClass(this.getCriteriaInnerClass(topLevelClass));
        topLevelClass.addInnerClass(this.getColumnContainerClass(topLevelClass));
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.context.getPlugins().modelExampleClassGenerated(topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
        }
        return answer;
    }

    private Method getCreateOtherExampleColumnsMethod(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("create");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Columns");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".ColumnContainer");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".ColumnContainer columnContainer = (");
        sb.append(importType.getShortName());
        sb.append(".ColumnContainer) columnContainerMap.get(");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(".getTableName());");
        method.addBodyLine(sb.toString());
        method.addBodyLine(" if(columnContainer == null){");
        sb.setLength(0);
        sb.append("columnContainer = ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(".createColumns();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append("columnContainerMap.put(");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(".getTableName(),columnContainer);");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        method.addBodyLine("}");
        method.addBodyLine("leftJoinTableSet.add(columnContainer.getTableName());");
        method.addBodyLine("return columnContainer;");
        return method;
    }

    private Method getAndOtherExampleCriteriaMethod(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("and");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Criteria");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria criteria = ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(".createCriteria();");
        method.addBodyLine(sb.toString());
        method.addBodyLine("Criteria myCriteria = null;");
        method.addBodyLine("if (oredCriteria.size() == 0) {");
        method.addBodyLine("myCriteria =  createCriteriaInternal();");
        method.addBodyLine("oredCriteria.add(myCriteria);");
        method.addBodyLine("}else{");
        method.addBodyLine("myCriteria =  (Criteria)oredCriteria.get(0);");
        method.addBodyLine("}");
        method.addBodyLine("leftJoinTableSet.add(criteria.getTableName());");
        method.addBodyLine("criteria.setAllCriteria(myCriteria.getAllCriteria());");
        method.addBodyLine("return criteria;");
        return method;
    }

    private Method getAndOtherExampleCriteriaMethodWithCriteria(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.addParameter(new Parameter(new FullyQualifiedJavaType("Criteria"), "criteria"));
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("and");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Criteria");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria newCriteria = ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(".createCriteria();");
        method.addBodyLine(sb.toString());
        method.addBodyLine("leftJoinTableSet.add(newCriteria.getTableName());");
        method.addBodyLine("newCriteria.setAllCriteria(criteria.getAllCriteria());");
        method.addBodyLine("return newCriteria;");
        return method;
    }

    private Method getOrOtherExampleCriteriaMethod(IntrospectedTable introspectedImportTable) {
        FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getExampleType());
        StringBuffer sb = new StringBuffer();
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        sb.append("or");
        sb.append(importType.getShortName().replace("Example", ""));
        sb.append("Criteria");
        method.setName(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria");
        method.setReturnType(new FullyQualifiedJavaType(sb.toString()), false);
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(" ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(" = new ");
        sb.append(importType.getShortName());
        sb.append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(importType.getShortName());
        sb.append(".Criteria criteria = ");
        sb.append(JavaBeansUtil.getValidPropertyName(importType.getShortName()));
        sb.append(".createCriteria();");
        method.addBodyLine(sb.toString());
        method.addBodyLine("leftJoinTableSet.add(criteria.getTableName());");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("return criteria;");
        return method;
    }

    private InnerClass getColumnContainerClass(TopLevelClass topLevelClass) {
        InnerClass answer = new InnerClass(FullyQualifiedJavaType.getColumnContainerInstance());
        answer.setVisibility(JavaVisibility.PUBLIC);
        answer.setStatic(true);
        answer.setSuperClass(FullyQualifiedJavaType.getColumnContainerBaseInstance());
        this.context.getCommentGenerator().addClassComment(answer, this.introspectedTable);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("ColumnContainer");
        method.setConstructor(true);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "tableName"));
        method.addBodyLine("super(tableName);");
        answer.addMethod(method);
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            answer.addMethod(this.getHasColumnMethod(introspectedColumn));
        }
        return answer;
    }

    private InnerClass getCriteriaInnerClass(TopLevelClass topLevelClass) {
        InnerClass answer = new InnerClass(FullyQualifiedJavaType.getCriteriaInstance());
        answer.setVisibility(JavaVisibility.PUBLIC);
        answer.setStatic(true);
        answer.setSuperClass(FullyQualifiedJavaType.getGeneratedCriteriaInstance());
        this.context.getCommentGenerator().addClassComment(answer, this.introspectedTable);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("Criteria");
        method.setConstructor(true);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "tableName"));
        method.addBodyLine("super(tableName);");
        method.addBodyLine("tableName = \"" + this.introspectedTable.getActualTableName().getTableName() + "\";");
        answer.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("Criteria");
        method.setConstructor(true);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "tableName"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "ignoreCase"));
        method.addBodyLine("this(tableName);");
        method.addBodyLine("this.ignoreCase = ignoreCase;");
        answer.addMethod(method);
        ArrayList<String> criteriaLists = new ArrayList<String>();
        criteriaLists.add("criteria");
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getNonBLOBColumns()) {
            if (!StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) continue;
            String name = this.addtypeHandledObjectsAndMethods(introspectedColumn, method, answer);
            criteriaLists.add(name);
        }
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("isValid");
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        StringBuilder sb = new StringBuilder();
        Iterator strIter = criteriaLists.iterator();
        sb.append("return ");
        sb.append((String)strIter.next());
        sb.append(".size() > 0");
        if (!strIter.hasNext()) {
            sb.append(';');
        }
        method.addBodyLine(sb.toString());
        while (strIter.hasNext()) {
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append("|| ");
            sb.append((String)strIter.next());
            sb.append(".size() > 0");
            if (!strIter.hasNext()) {
                sb.append(';');
            }
            method.addBodyLine(sb.toString());
        }
        answer.addMethod(method);
        if (criteriaLists.size() > 1) {
            Field field = new Field();
            field.setName("allCriteria");
            field.setType(new FullyQualifiedJavaType("List<Criterion>"));
            field.setVisibility(JavaVisibility.PROTECTED);
            answer.addField(field);
        }
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("getAllCriteria");
        method.setReturnType(new FullyQualifiedJavaType("List<Criterion>"));
        if (criteriaLists.size() < 2) {
            method.addBodyLine("return criteria;");
        } else {
            method.addBodyLine("if (allCriteria == null) {");
            method.addBodyLine("allCriteria = new ArrayList<Criterion>();");
            strIter = criteriaLists.iterator();
            while (strIter.hasNext()) {
                method.addBodyLine(String.format("allCriteria.addAll(%s);", strIter.next()));
            }
            method.addBodyLine("}");
            method.addBodyLine("return allCriteria;");
        }
        answer.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("setAllCriteria");
        method.addParameter(new Parameter(new FullyQualifiedJavaType("List<Criterion>"), "criteria"));
        method.addBodyLine("this.criteria = criteria;");
        answer.addMethod(method);
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewArrayListInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewSetInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewHashSetInstance());
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addBodyLine("if (condition == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for condition cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteria.add(new Criterion(condition));");
        if (criteriaLists.size() > 1) {
            method.addBodyLine("allCriteria = null;");
        }
        answer.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteria.add(new Criterion(condition, value,ignoreCase));");
        if (criteriaLists.size() > 1) {
            method.addBodyLine("allCriteria = null;");
        }
        answer.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value1"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value2"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value1 == null || value2 == null) {");
        method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteria.add(new Criterion(condition, value1, value2));");
        if (criteriaLists.size() > 1) {
            method.addBodyLine("allCriteria = null;");
        }
        answer.addMethod(method);
        FullyQualifiedJavaType listOfDates = new FullyQualifiedJavaType("java.util.List<java.util.Date>");
        if (this.introspectedTable.hasJDBCDateColumns()) {
            topLevelClass.addImportedType(FullyQualifiedJavaType.getDateInstance());
            topLevelClass.addImportedType(FullyQualifiedJavaType.getNewIteratorInstance());
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCDate");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value == null) {");
            method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Date(value.getTime()), property);");
            answer.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCDate");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(listOfDates, "values"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (values == null || values.size() == 0) {");
            method.addBodyLine("throw new RuntimeException(\"Value list for \" + property + \" cannot be null or empty\");");
            method.addBodyLine("}");
            method.addBodyLine("List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();");
            method.addBodyLine("Iterator<Date> iter = values.iterator();");
            method.addBodyLine("while (iter.hasNext()) {");
            method.addBodyLine("dateList.add(new java.sql.Date(iter.next().getTime()));");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, dateList, property);");
            answer.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCDate");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value1"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value2"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value1 == null || value2 == null) {");
            method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);");
            answer.addMethod(method);
        }
        if (this.introspectedTable.hasJDBCTimeColumns()) {
            topLevelClass.addImportedType(FullyQualifiedJavaType.getDateInstance());
            topLevelClass.addImportedType(FullyQualifiedJavaType.getNewIteratorInstance());
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCTime");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value == null) {");
            method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Time(value.getTime()), property);");
            answer.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCTime");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(listOfDates, "values"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (values == null || values.size() == 0) {");
            method.addBodyLine("throw new RuntimeException(\"Value list for \" + property + \" cannot be null or empty\");");
            method.addBodyLine("}");
            method.addBodyLine("List<java.sql.Time> timeList = new ArrayList<java.sql.Time>();");
            method.addBodyLine("Iterator<Date> iter = values.iterator();");
            method.addBodyLine("while (iter.hasNext()) {");
            method.addBodyLine("timeList.add(new java.sql.Time(iter.next().getTime()));");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, timeList, property);");
            answer.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setName("addCriterionForJDBCTime");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value1"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getDateInstance(), "value2"));
            method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
            method.addBodyLine("if (value1 == null || value2 == null) {");
            method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
            method.addBodyLine("addCriterion(condition, new java.sql.Time(value1.getTime()), new java.sql.Time(value2.getTime()), property);");
            answer.addMethod(method);
        }
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            answer.addMethod(this.getSetNullMethod(introspectedColumn));
            answer.addMethod(this.getSetNotNullMethod(introspectedColumn));
            answer.addMethod(this.getSetEqualMethod(introspectedColumn));
            answer.addMethod(this.getSetNotEqualMethod(introspectedColumn));
            answer.addMethod(this.getSetGreaterThanMethod(introspectedColumn));
            answer.addMethod(this.getSetGreaterThenOrEqualMethod(introspectedColumn));
            answer.addMethod(this.getSetLessThanMethod(introspectedColumn));
            answer.addMethod(this.getSetLessThanOrEqualMethod(introspectedColumn));
            if (introspectedColumn.isJdbcCharacterColumn()) {
                answer.addMethod(this.getSetLikeMethod(introspectedColumn));
                answer.addMethod(this.getSetNotLikeMethod(introspectedColumn));
            }
            answer.addMethod(this.getSetInOrNotInMethod(introspectedColumn, true));
            answer.addMethod(this.getSetInOrNotInMethod(introspectedColumn, false));
            answer.addMethod(this.getSetBetweenOrNotBetweenMethod(introspectedColumn, true));
            answer.addMethod(this.getSetBetweenOrNotBetweenMethod(introspectedColumn, false));
        }
        return answer;
    }

    private Method getSetNullMethod(IntrospectedColumn introspectedColumn) {
        return this.getNoValueMethod(introspectedColumn, "IsNull", "is null");
    }

    private Method getHasColumnMethod(IntrospectedColumn introspectedColumn) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "has");
        sb.append("Column");
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getColumnContainerInstance());
        sb.setLength(0);
        sb.append("addColumnStr(\"");
        sb.append(MyBatis3FormattingUtilities.getSelectListPhraseWithEscape(introspectedColumn));
        sb.append(' ');
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (ColumnContainer) this;");
        return method;
    }

    private Method getSetNotNullMethod(IntrospectedColumn introspectedColumn) {
        return this.getNoValueMethod(introspectedColumn, "IsNotNull", "is not null");
    }

    private Method getSetEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "EqualTo", "=");
    }

    private Method getSetNotEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "NotEqualTo", "<>");
    }

    private Method getSetGreaterThanMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "GreaterThan", ">");
    }

    private Method getSetGreaterThenOrEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "GreaterThanOrEqualTo", ">=");
    }

    private Method getSetLessThanMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "LessThan", "<");
    }

    private Method getSetLessThanOrEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "LessThanOrEqualTo", "<=");
    }

    private Method getSetLikeMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "Like", "like");
    }

    private Method getSetNotLikeMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "NotLike", "not like");
    }

    private Method getSingleValueMethod(IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterionForJDBCDate(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterionForJDBCTime(\"");
        } else if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        sb.append(' ');
        sb.append(operator);
        sb.append("\", ");
        sb.append("value");
        sb.append(", \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private Method getSetBetweenOrNotBetweenMethod(IntrospectedColumn introspectedColumn, boolean betweenMethod) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType type = introspectedColumn.getFullyQualifiedJavaType();
        method.addParameter(new Parameter(type, "value1"));
        method.addParameter(new Parameter(type, "value2"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        if (betweenMethod) {
            sb.append("Between");
        } else {
            sb.append("NotBetween");
        }
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterionForJDBCDate(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterionForJDBCTime(\"");
        } else if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        if (betweenMethod) {
            sb.append(" between");
        } else {
            sb.append(" not between");
        }
        sb.append("\", ");
        sb.append("value1, value2");
        sb.append(", \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private Method getSetInOrNotInMethod(IntrospectedColumn introspectedColumn, boolean inMethod) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType type = FullyQualifiedJavaType.getNewListInstance();
        if (introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
            type.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType().getPrimitiveTypeWrapper());
        } else {
            type.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType());
        }
        method.addParameter(new Parameter(type, "values"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        if (inMethod) {
            sb.append("In");
        } else {
            sb.append("NotIn");
        }
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterionForJDBCDate(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterionForJDBCTime(\"");
        } else if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        if (inMethod) {
            sb.append(" in");
        } else {
            sb.append(" not in");
        }
        sb.append("\", values, \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private Method getNoValueMethod(IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        sb.append("addCriterion(\"");
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        sb.append(' ');
        sb.append(operator);
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private String addtypeHandledObjectsAndMethods(IntrospectedColumn introspectedColumn, Method constructor, InnerClass innerClass) {
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("Criteria");
        String answer = sb.toString();
        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(new FullyQualifiedJavaType("java.util.List<Criterion>"));
        field.setName(answer);
        innerClass.addField(field);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        sb.insert(0, "return ");
        sb.append(';');
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        sb.setLength(0);
        sb.append(field.getName());
        sb.append(" = new ArrayList<Criterion>();");
        constructor.addBodyLine(sb.toString());
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");
        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine(String.format("%s.add(new Criterion(condition, value, \"%s\"));", field.getName(), introspectedColumn.getTypeHandler()));
        method.addBodyLine("allCriteria = null;");
        innerClass.addMethod(method);
        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value1"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value2"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        if (!introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
            method.addBodyLine("if (value1 == null || value2 == null) {");
            method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
            method.addBodyLine("}");
        }
        method.addBodyLine(String.format("%s.add(new Criterion(condition, value1, value2, \"%s\"));", field.getName(), introspectedColumn.getTypeHandler()));
        method.addBodyLine("allCriteria = null;");
        innerClass.addMethod(method);
        return answer;
    }
}

