package com.viontech.keliu.configuration.elasticsearch.util;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

/**
 * Author: inggg
 * Date: 2020/5/25 9:34
 */
public class AndQueryBuilder {
    private final static Logger logger = LoggerFactory.getLogger(AndQueryBuilder.class);

    private BoolQuery.Builder boolQueryBuilder;

    public AndQueryBuilder() {
        boolQueryBuilder = new BoolQuery.Builder();
    }

    /**
     * where and field = value
     * @param field
     * @param value
     * @return
     */
    public AndQueryBuilder eq(String field, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
//        boolQueryBuilder.filter(QueryBuilders.termQuery(field, value));
        return this;
    }
    /**
     * where and field = value
     * @param field
     * @param value
     * @return
     */
    public AndQueryBuilder eq(String field, Integer value) {
//        if (null == value) {
//            return this;
//        }
//        boolQueryBuilder.filter(new Query.Builder().term(t -> t.value(value).field(field)));
        return this;
    }
    /**
     * where and field in values
     * @param field
     * @param values
     * @return
     */
    public AndQueryBuilder in(String field, String... values) {
//        if (null == values || values.length == 0) {
//            return this;
//        }
//        boolQueryBuilder.filter(QueryBuilders.termsQuery(field, values));
        return this;
    }
    /**
     * where and field in values
     * @param field
     * @param values
     * @return
     */
    public AndQueryBuilder in(String field, Integer... values) {
        if (null == values || values.length == 0) {
            return this;
        }
//        boolQueryBuilder.filter(QueryBuilders.termsQuery(field, values));
        return this;
    }
    public AndQueryBuilder in(String field, Collection<?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return this;
        }
//        boolQueryBuilder.filter(QueryBuilders.termsQuery(field, values));
        return this;
    }

    /**
     * where field like *value*
     * @param field
     * @param value
     * @return
     */
    public AndQueryBuilder like(String field, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
//        boolQueryBuilder.filter(QueryBuilders.wildcardQuery(field, "*" + value + "*"));
        return this;
    }

    /**
     * where filed > from and field < to
     * @param field
     * @param from
     * @param to
     * @param includeLower
     * @param includeUpper
     * @return
     */
    public AndQueryBuilder between(String field, Object from, boolean includeLower, Object to, boolean includeUpper) {
//        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery(field);
//        if (null == from && null == to) {
//            return this;
//        }
//        if (null != from) {
//            rangeQueryBuilder.from(from, includeLower);
//        }
//        if (null != to) {
//            rangeQueryBuilder.to(to, includeUpper);
//        }
//        boolQueryBuilder.filter(rangeQueryBuilder);
        return this;
    }

    /**
     * where field is not null and field.length != ""
     * @param field
     * @param includeNullString 是否包含空字符串，""，如果为true，值为""也是存在，如果为false，value长度必须大于0
     * @return
     */
    public AndQueryBuilder exists(String field, boolean includeNullString) {
//        boolQueryBuilder.filter(QueryBuilders.existsQuery(field));
//        if (!includeNullString) {
//            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
//            subBoolQueryBuilder.mustNot(QueryBuilders.termQuery(field, ""));
//            boolQueryBuilder.filter(subBoolQueryBuilder);
//        }
        return this;
    }

    /**
     * where (field is null or field = '')
     * @param field
     * @param includeNullString 空字符串''是否也算不存在，如果为true，''也表示不存在，如果为false，''为存在
     * @return
     */
    public AndQueryBuilder notExists(String field, boolean includeNullString) {
//        if (includeNullString) {
//            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
//            subBoolQueryBuilder.should(QueryBuilders.termQuery(field, ""));
//            subBoolQueryBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery(field)));
//            boolQueryBuilder.filter(subBoolQueryBuilder);
//        } else {
//            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
//            subBoolQueryBuilder.mustNot(QueryBuilders.existsQuery(field));
//            boolQueryBuilder.filter(subBoolQueryBuilder);
//        }
        return this;
    }

    public BoolQuery build() {
        return boolQueryBuilder.build();
    }
}
