package com.viontech.keliu.configuration.elasticsearch.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.data.geo.Point;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Component
public class PointDeserializer extends JsonDeserializer<Point> {

    @Override
    public Point deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        if (node.isObject() && node.has("x") && node.has("y") && node.get("x").isDouble() && node.get("y").isDouble()) {
            return new Point(node.get("x").asDouble(), node.get("y").asDouble());
        }
        return null;
    }
}
