//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.viontech.keliu.configuration.elasticsearch.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.core.annotation.AliasFor;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Documented
@Inherited
public @interface Field {
    @AliasFor("name")
    String value() default "";

    @AliasFor("value")
    String name() default "";

    FieldType type() default FieldType.Auto;

    boolean index() default true;

    DateFormat[] format() default {DateFormat.date_optional_time, DateFormat.epoch_millis};

    String[] pattern() default {};

    boolean store() default false;

    boolean fielddata() default false;

    String searchAnalyzer() default "";

    String analyzer() default "";

    String normalizer() default "";

    String[] ignoreFields() default {};

    boolean includeInParent() default false;

    String[] copyTo() default {};

    int ignoreAbove() default -1;

    boolean coerce() default true;

    boolean docValues() default true;

    boolean ignoreMalformed() default false;

    IndexOptions indexOptions() default IndexOptions.none;

    boolean indexPhrases() default false;

    boolean norms() default true;

    String nullValue() default "";

    int positionIncrementGap() default -1;

    double scalingFactor() default 1.0;

    int maxShingleSize() default -1;

    boolean storeNullValue() default false;

    boolean positiveScoreImpact() default true;

    boolean enabled() default true;

    boolean eagerGlobalOrdinals() default false;

    int dims() default -1;
}
