package com.viontech.keliu.configuration.elasticsearch;

import cn.hutool.core.util.ClassUtil;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.ilm.*;
import co.elastic.clients.elasticsearch.indices.*;
import co.elastic.clients.elasticsearch.security.PutUserResponse;
import com.viontech.keliu.configuration.elasticsearch.annotation.*;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
//import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
//import org.springframework.data.elasticsearch.annotations.Document;
//import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
//import org.springframework.data.elasticsearch.core.index.MappingBuilder;
//import org.springframework.data.elasticsearch.core.index.Settings;
//import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.*;

/**
 * 启动后ES索引，模板初始化
 * Author: inggg
 * Date: 2021/10/28 15:05
 */
@Component
@ConditionalOnProperty("spring.elasticsearch.rest.uris")
@Slf4j
public class EsInit implements CommandLineRunner {

    /**
     * 生命周期名字
     */
    public final static String LIFECYCLE_NAME = "delete-heatmap-after-days";

    @Value("${delete.after.days:14}")
    private Integer deleteAfterDays;

//    @Autowired
//    private ElasticsearchRestTemplate template;
    @Autowired
    private ESClient esClient;

    private Boolean refreshTemplateILM() throws Exception {
        try {
            Actions hotAction = new Actions.Builder()
                    .setPriority(p -> p.priority(100))
                    .build();
            Actions deleteAction = new Actions.Builder().delete(s -> s.deleteSearchableSnapshot(true)).build();
            IlmPolicy ilmPolicy = new IlmPolicy.Builder()
                    .phases(new Phases.Builder()
                            .hot(new Phase.Builder().actions(hotAction).minAge(t -> t.time("0ms")).build())
                            .delete(new Phase.Builder().actions(deleteAction).minAge(t -> t.time(deleteAfterDays + "d")).build())
                            .build())
                    .build();
            PutLifecycleRequest request = new PutLifecycleRequest.Builder().name(LIFECYCLE_NAME).policy(ilmPolicy).build();
            PutLifecycleResponse response = esClient.getClient().ilm().putLifecycle(request);
            GetLifecycleResponse getResponse = esClient.getClient().ilm().getLifecycle(new GetLifecycleRequest.Builder().name(LIFECYCLE_NAME).build());
            if (getResponse.get(LIFECYCLE_NAME) != null) {
                log.info(LIFECYCLE_NAME + "生命周期创建完成");
            }
            return true;
        } catch (Exception e) {
            log.error("生命周期创建异常", e);
        }
        return false;
    }

    @Override
    public void run(String... args) throws Exception {
        if (!refreshTemplateILM()) {
            log.error("生命周期创建失败，无法创建热力模板");
            return;
        }
        Set<Class<?>> templates = ClassUtil.scanPackageByAnnotation("com.viontech", Template.class);
        for (Class<?> clazz : templates) {
            Template annotation = clazz.getAnnotation(Template.class);
            ESPrefix prefixAnnotation = clazz.getAnnotation(ESPrefix.class);
            String templateName;
            List<String> patterns = new ArrayList<>(annotation.patterns().length);
            if (null != prefixAnnotation) {
                String prefix = ESUtil.getPrefix(prefixAnnotation);
                templateName = prefix + "-" + annotation.templateName();
                for (String pattern : annotation.patterns()) {
                    patterns.add(prefix + "-" + pattern);
                }
            } else {
                templateName = annotation.templateName();
                for (String pattern : annotation.patterns()) {
                    patterns.add(pattern);
                }
            }

            Map<String, Property> properties = new HashMap<>();
            for (Field field : clazz.getDeclaredFields()) {
                com.viontech.keliu.configuration.elasticsearch.annotation.FieldType type = null;
                com.viontech.keliu.configuration.elasticsearch.annotation.Field field1 = field.getAnnotation(com.viontech.keliu.configuration.elasticsearch.annotation.Field.class);
                if (null != field1) {
                    type = field1.type();
                }

                if (type == com.viontech.keliu.configuration.elasticsearch.annotation.FieldType.Keyword) {
                    Boolean indexRet;
                    if (field.getType() == Integer.class)
                        indexRet = false;
                    else {
                        indexRet = true;
                    }
                    properties.put(field.getName(), new Property.Builder().keyword(k -> k.index(true)).build());
//                } else if (type == null && field.getType() == String.class) {
//                    properties.put(field.getName(), new Property.Builder().text(t -> t.fielddata(true)).build());
                } else if (type == com.viontech.keliu.configuration.elasticsearch.annotation.FieldType.Short) {
                    properties.put(field.getName(), new Property.Builder().short_(s -> s.nullValue(0)).build());
                } else if (type == com.viontech.keliu.configuration.elasticsearch.annotation.FieldType.Double) {
                    properties.put(field.getName(), new Property.Builder().double_(s -> s.nullValue(0.0)).build());
                } else if (type == com.viontech.keliu.configuration.elasticsearch.annotation.FieldType.Date) {
                    properties.put(field.getName(), new Property.Builder().date(d -> d.format("date_optional_time||epoch_millis")).build());
                } else if (type == com.viontech.keliu.configuration.elasticsearch.annotation.FieldType.Date_Nanos) {
                    properties.put(field.getName(), new Property.Builder().dateNanos(d -> d.format("epoch_millis")).build());
                } else if (type == com.viontech.keliu.configuration.elasticsearch.annotation.FieldType.Float) {
                    properties.put(field.getName(), new Property.Builder().float_(d -> d.nullValue(0.0f)).build());
                } else {
                    Mapping mapping = field.getAnnotation(Mapping.class);
                    if (null != mapping && mapping.mappingPath().contains("Point.properties")) {
                        properties.put(field.getName(), new Property.Builder().point(d -> d.docValues(true)).build());
                    }
                }
            }
//            properties.put("_class", new Property.Builder().keyword(k -> k.index(false).docValues(false)).build());
            TypeMapping.Builder builder = new TypeMapping.Builder().properties(properties);
            Setting setting = clazz.getAnnotation(Setting.class);
            IndexSettings.Builder indexSettingsBuilder = new IndexSettings.Builder()
                    .maxResultWindow(ESConfig.MAX_SIZE)
                    .numberOfShards(String.valueOf(setting.shards()))
                    .numberOfReplicas(String.valueOf(setting.replicas()))
                    .refreshInterval(r -> r.time(setting.refreshInterval()));
            if (setting.enableDeleted()) {
                indexSettingsBuilder.lifecycle(l -> l.name(LIFECYCLE_NAME));
            }
            PutIndexTemplateRequest request = new PutIndexTemplateRequest.Builder()
                    .name(templateName)
                    .template(t ->
                                t.mappings(builder.build())
                                .settings(indexSettingsBuilder.build())
                    )
                    .indexPatterns(patterns)
                    .build();

            PutIndexTemplateResponse acknowledgedResponse = esClient.indices().putIndexTemplate(request);
            if (acknowledgedResponse.acknowledged()) {
                log.info("{}模板创建完成", templateName);
            }

//            Document document = clazz.getAnnotation(Document.class);
//            if (document != null && document.createIndex()) {
//                PutMappingRequest putMappingRequest = new PutMappingRequest.Builder()
//                        .index(document.indexName())
//                        .properties(properties)
//                        .build();
//                try {
//                    PutMappingResponse putUserResponse = esClient.indices().putMapping(putMappingRequest);
//                    if (putUserResponse.acknowledged()) {
//                        log.info("{}索引更新成功", document.indexName());
//                    }
//                } catch (ElasticsearchException e) {
//                    if (e.status() == 404) {
//                        log.info("{}索引不存在，不用刷新", document.indexName());
//                    } else {
//                        log.error("{}索引更新失败", document.indexName(), e);
//                    }
//                }
//            }
        }

//        Set<Class<?>> classes = ClassUtil.scanPackageByAnnotation("com.viontech", Document.class);
//        for (Class<?> clazz : classes) {
//            if (clazz.getAnnotation(Document.class).createIndex()) {
//                boolean b = template.indexOps(clazz).putMapping(clazz);
//                if (b) {
//                    log.info("{}索引更新成功", clazz.getName());
//                }
//            }
//        }

        new Thread(()->{
            while (true){
                try{
                    Thread.sleep(1000 * 15);
                    //long l = System.currentTimeMillis();
                    esClient.info();
                    //log.info("es心跳:{}ms", System.currentTimeMillis() - l);
                }catch (Exception e){
                    log.error("EsQueryHandler error",e);
                }
            }
        }).start();
    }
}
