package com.viontech.keliu.configuration.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.*;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.*;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import org.elasticsearch.client.RequestOptions;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * Author: inggg
 * Date: 2019/8/12 9:42
 */
public class ESClient {

    private ElasticsearchClient client;
    private RequestOptions options;

    public ESClient(ElasticsearchClient client, RequestOptions options) {
        this.client = client;
        this.options = options;
    }

    public final InfoResponse info() throws IOException {
//        return client.info(options);
        return client.info();
    }

    public final ElasticsearchClient getClient() {
        return client;
    }

    public final <T> List<T> select(T t) throws Exception {
        Class<T> clazz = (Class<T>) t.getClass();
        SearchRequest.Builder searchRequest = ESRequestFactory.getSearchRequest(clazz);
        SourceConfig.Builder searchSourceBuilder = new SourceConfig.Builder();
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        List<Query> queries = new ArrayList<>();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            String name = field.getName();
            Class<?> type = field.getType();

            //获取对应属性的属性值
            field.setAccessible(true);
            Object value = field.get(t);
            if (!Objects.isNull(value) && !type.isAssignableFrom(Date.class) && !type.isAssignableFrom(List.class)) {
                queries.add(QueryBuilders.term().field(name).value(FieldValue.of(value)).build()._toQuery());
//                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery(name, value);
//                boolQueryBuilder.must(termQueryBuilder);
            }
        }
//        boolQueryBuilder.must(queries);
//        searchSourceBuilder.query(boolQueryBuilder);
//        searchRequest.source(searchSourceBuilder);

        SearchResponse<T> response = client.search(searchRequest.query(boolQueryBuilder.must(queries).build()._toQuery()).build(), clazz);
        HitsMetadata hits = response.hits();
        List<Hit<T>> hits1 = hits.hits();
        List<T> results = new ArrayList<>();
        if (hits1.isEmpty()) {
            return results;
        }
        for (Hit hit : hits1) {
            T t1 = (T)hit.source();

            Field idField = clazz.getDeclaredField("id");
            if (null != idField) {
                idField.setAccessible(true);
                idField.set(t1, hit.id());
            }
            results.add(t1);
        }
        return results;
    }

    public final <T> List<T> select(T t, Date date, Integer size) throws Exception {
        Class<T> clazz = (Class<T>) t.getClass();
        SearchRequest.Builder searchRequest = ESRequestFactory.getSearchRequest(clazz, date);
//        SourceConfig searchSourceBuilder = new SourceConfig();
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        List<Query> queries = new ArrayList<>();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            String name = field.getName();
            Class<?> type = field.getType();

            //获取对应属性的属性值
            field.setAccessible(true);
            Object value = field.get(t);
            if (!Objects.isNull(value) && !type.isAssignableFrom(Date.class) && !type.isAssignableFrom(List.class)) {
                queries.add(QueryBuilders.term().field(name).value(FieldValue.of(value)).build()._toQuery());
//                TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery(name, value);
//                boolQueryBuilder.must(termQueryBuilder);
            }
        }
//        searchSourceBuilder.query(boolQueryBuilder);
//        searchSourceBuilder.size(size);
//        searchRequest.source(searchSourceBuilder);
        SearchResponse<T> response = client.search(searchRequest.query(boolQueryBuilder.must(queries).build()._toQuery()).build(), clazz);
        HitsMetadata hits = response.hits();
        List<Hit<T>> hits1 = hits.hits();
        List<T> results = new ArrayList<>();
        if (hits1.isEmpty()) {
            return results;
        }
        for (Hit hit : hits1) {
//            String sourceAsString = hit.getSourceAsString();
//            T t1 = JSON.parseObject(sourceAsString, clazz);
            T t1 = (T)hit.source();
            String id = hit.id();
            Field idField = clazz.getDeclaredField("id");
            if (null != idField) {
                idField.setAccessible(true);
                idField.set(t1, id);
            }
            results.add(t1);
        }
        return results;
    }

//    public final <T> T findById(T t) throws Exception {
//        Class<T> clazz = (Class<T>) t.getClass();
//        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(t.getClass());
//        Field[] fields = clazz.getDeclaredFields();
//        Object id = null;
//        for (Field field : fields) {
//            Id idAnnotation = field.getAnnotation(Id.class);
//            if (null != idAnnotation) {
//                field.setAccessible(true);
//                id = field.get(t);
//                if (Objects.isNull(id)) {
//                    throw new RuntimeException("id不能为空");
//                }
//                break;
//            }
//        }
//        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
//        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery().addIds((String) id);
//        searchSourceBuilder.query(idsQueryBuilder);
//        searchRequest.source(searchSourceBuilder);
//        SearchResponse response = client.search(searchRequest, options);
//        SearchHits hits = response.getHits();
//        SearchHit[] hits1 = hits.getHits();
//        if (0 == hits1.length) {
//            return null;
//        }
//        SearchHit searchHit = hits1[0];
//        String sourceAsString = searchHit.getSourceAsString();
//        T t1 = JSON.parseObject(sourceAsString, clazz);
//        String id1 = searchHit.getId();
//        Field idField = clazz.getDeclaredField("id");
//        if (idField != null) {
//            idField.setAccessible(true);
//            idField.set(t1, id1);
//        }
//        return t1;
//    }

    /**
     * 存储数据，默认不只用自增主键，使用自定义主键
     * 默认立即刷新
     *
     * @param t   数据
     * @param <T>
     * @return
     * @throws Exception
     */
//    public final <T> T saveOrUpdate(T t) throws Exception {
//        return saveOrUpdate(t, false);
//    }

//    /**
//     * 存储数据
//     *
//     * @param t            数据
//     * @param delayRefresh 是否延迟刷新
//     * @param <T>
//     * @return
//     * @throws Exception
//     */
//    public final <T> T saveOrUpdate(T t, boolean delayRefresh) throws Exception {
//        Class clazz = t.getClass();
//        String index = getIndexName(t);
//        Field[] fields = clazz.getDeclaredFields();
//        int idCount = 0;
//        Field idField = null;
//        for (Field field : fields) {
//            JsonTypeInfo.Id idAnnotation = field.getAnnotation(JsonTypeInfo.Id.class);
//            if (null != idAnnotation) {
//                idCount++;
//                idField = field;
//            }
//        }
//        /*if (idCount == 0) {
//            throw new RuntimeException(clazz.getName() + "没有id字段");
//        }*/
//        if (idCount > 1) {
//            throw new RuntimeException(clazz.getName() + "有两个id");
//        }
//        String s = JSON.toJSONString(t);
//
//        IndexRequest.Builder indexRequest = new IndexRequest.Builder().index(index);
//        if (delayRefresh) {
//            indexRequest.refresh(Refresh.False);
////            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
//        } else {
//            indexRequest.refresh(Refresh.WaitFor);
////            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
//        }
//        //是否有id，没有id使用默认
//        if (null != idField) {
//            idField.setAccessible(true);
//            Object id = idField.get(t);
//            if (null != id) {
//                indexRequest.id(id.toString());
//            }
//        }
//        indexRequest.source(s, XContentType.JSON);
//        IndexResponse indexResponse = this.index(indexRequest);
//        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED
//                || indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
//            return t;
//        }
//        return null;
//    }

    private <T> String getIndexName(T t) throws Exception {
        return ESUtil.getIndexName(t);
    }

//    public final <T> BulkResponse batchUpsert(List<T> tList) throws Exception {
//        return batchUpsert(tList, false);
//    }

//    public final <T> BulkResponse batchUpsert(List<T> tList, boolean delayRefresh) throws Exception {
//        BulkRequest.Builder bulkRequest = null;
//        List<BulkOperation> bulkOperationList = new ArrayList<>();
//        int count = 0;
//        for (T t : tList) {
//            if (null == bulkRequest) {
//                bulkRequest = new BulkRequest.Builder();
//                if (delayRefresh) {
//                    bulkRequest.refresh(Refresh.False);
////                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
//                } else {
//                    bulkRequest.refresh(Refresh.WaitFor);
////                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
//                }
//            }
//            Class clazz = t.getClass();
//            Document annotation = (Document) clazz.getAnnotation(Document.class);
//            if (null == annotation) {
//                throw new RuntimeException("无法使用ES upsert方法");
//            }
//            String index = annotation.index();
//            if (StringUtils.isEmpty(index)) {
//                throw new RuntimeException("索引不能为空");
//            }
//            Field[] fields = clazz.getDeclaredFields();
//            Field idField = null;
//            for (Field field : fields) {
//                Id idAnnotation = field.getAnnotation(Id.class);
//                if (null != idAnnotation) {
//                    idField = field;
//                    break;
//                }
//            }
//            if (Objects.isNull(idField)) {
//                throw new NullPointerException("没有id字段");
//            }
//            idField.setAccessible(true);
//            Object id = idField.get(t);
//            if (Objects.isNull(id)) {
//                throw new IllegalArgumentException("id不能为空");
//            }
//
//            String json = JSON.toJSONString(t);
//            UpdateRequest request = new UpdateRequest.Builder().index(index).id((String) id).doc(json).docAsUpsert(true).build();
//            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(json.getBytes()), StandardCharsets.UTF_8);
//            new BulkOperation.Builder().index(new UpdateOperation.Builder<T>().index(index).id((String)id).
//            UpdateOperation<clazz> request1 = new UpdateOperation.Builder<T>().index(index).id((String)id).withJson(reader);
//            bulkOperationList.add(request1._toBulkOperation());
//            count++;
//            if (count > 10000) {
//                bulkRequest.operations((List<BulkOperation>) request);
//                BulkResponse bulk = this.bulk(bulkRequest.build());
//                boolean hasFailures = bulk.errors();
//                if (hasFailures) {
//                    return bulk;
//                } else {
//                    count = 0;
//                    bulkRequest = null;
//                }
//            }
//        }
//        BulkResponse bulk = this.bulk(bulkRequest.build());
//        return bulk;
//    }

//    /**
//     * 有则更新，无则插入，默认不适用延迟刷新
//     * @param t
//     * @param <T>
//     * @return
//     * @throws Exception
//     */
//    public final <T> String upsert(T t) throws Exception {
//        return upsert(t, false);
//    }

//    /**
//     * 有则更新，无则插入
//     * @param t 数据
//     * @param delayRefresh 是否延迟刷新
//     * @param <T>
//     * @return
//     */
//    public final <T> String upsert(T t, boolean delayRefresh) throws Exception {
//        if (Objects.isNull(t)) {
//            throw new NullPointerException("参数不能为空");
//        }
//        Class clazz = t.getClass();
//        Document annotation = (Document) clazz.getAnnotation(Document.class);
//        if (null == annotation) {
//            throw new RuntimeException("无法使用ES upsert方法");
//        }
//        String index = annotation.index();
//        if (StringUtils.isEmpty(index)) {
//            throw new RuntimeException("索引不能为空");
//        }
//        Field[] fields = clazz.getDeclaredFields();
//        Field idField = null;
//        for (Field field : fields) {
//            Id idAnnotation = field.getAnnotation(Id.class);
//            if (null != idAnnotation) {
//                idField = field;
//                break;
//            }
//        }
//        if (Objects.isNull(idField)) {
//            throw new NullPointerException("没有id字段");
//        }
//        idField.setAccessible(true);
//        Object id = idField.get(t);
//        if (Objects.isNull(id)) {
//            throw new IllegalArgumentException("id不能为空");
//        }
//        UpdateRequest request = new UpdateRequest.Builder<T>().index(index).id( (String)id)).doc(t);
//        String json = JSON.toJSONString(t);
//        request.doc(json, XContentType.JSON);
//        request.docAsUpsert(true);
//        if (delayRefresh) {
//            request.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
//        } else {
//            request.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
//        }
//        UpdateResponse response = this.update(request);
//        return response.getResult().getLowercase();
//    }

//    public final UpdateResponse update(UpdateRequest<KeliuQueueTemplate> request) throws IOException {
//        client.update(request);
//        return client.update(request, options);
//    }

//    public final <T> BulkResponse batchSaveOrUpdate(List<T> tList) throws Exception {
//        return batchSaveOrUpdate(tList, false);
//    }

//    public final <T> BulkResponse batchSaveOrUpdate(List<T> tList, boolean delayRefresh) throws Exception {
//        BulkRequest.Builder bulkRequest = null;
//        int count = 0;
//        for (T t : tList) {
//            if (null == bulkRequest) {
//                bulkRequest = new BulkRequest.Builder();
//                if (delayRefresh) {
//                    bulkRequest.refresh(Refresh.False);
//                } else {
//                    bulkRequest.refresh(Refresh.WaitFor);
//                }
//            }
//            Class clazz = t.getClass();
//            String index = getIndexName(t);
//
//            Field[] fields = clazz.getDeclaredFields();
//            int idCount = 0;
//            Field idField = null;
//            for (Field field : fields) {
//                Id idAnnotation = field.getAnnotation(Id.class);
//                if (null != idAnnotation) {
//                    idCount++;
//                    idField = field;
//                }
//            }
//            /*if (idCount == 0) {
//                throw new RuntimeException(clazz.getName() + "没有id字段");
//            }*/
//            if (idCount > 1) {
//                throw new RuntimeException(clazz.getName() + "有两个id");
//            }
//
//            String s = JSON.toJSONString(t);
//
//            IndexRequest indexRequest = new IndexRequest(index);
//            //是否有id，没有id使用默认
//            if (null != idField) {
//                idField.setAccessible(true);
//                Object id = idField.get(t);
//                if (null != id) {
//                    indexRequest.id(id.toString());
//                }
//            }
//            indexRequest.source(s, XContentType.JSON);
//
//            bulkRequest.add(indexRequest);
//            count++;
//            if (count > 10000) {
//                BulkResponse bulk = this.bulk(bulkRequest);
//                boolean hasFailures = bulk.errors();
//                if (hasFailures) {
//                    return bulk;
//                } else {
//                    count = 0;
//                    bulkRequest = null;
//                }
//            }
//
//        }
//
//        BulkResponse bulk = this.bulk(bulkRequest);
//        return bulk;
//    }

    public final IndexResponse index(IndexRequest indexRequest) throws IOException {
        return client.index(indexRequest);
    }

    public final BulkResponse bulk(BulkRequest bulkRequest) throws IOException {
        return client.bulk(bulkRequest);
    }

    public final DeleteResponse delete(DeleteRequest deleteRequest) throws IOException {
        return client.delete(deleteRequest);
    }

//    public final SearchResponse search(SearchRequest searchRequest) throws IOException {
//        searchRequest.source().trackTotalHits(true);
//        return client.search(searchRequest, options);
//    }
//
//    public final SearchResponse search(Class clazz, SearchSourceBuilder searchSourceBuilder) throws IOException {
//        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz, searchSourceBuilder);
//        return this.search(searchRequest);
//    }
//
//    public final SearchResponse search(Class clazz, Date date, SearchSourceBuilder searchSourceBuilder) throws IOException {
//        SearchRequest searchRequest = new SearchRequest.Builder().
//        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz, date, searchSourceBuilder);
//        return this.search(searchRequest);
//    }
//
//    public final SearchResponse search(Class clazz, Date startDate, Date endDate, SearchSourceBuilder searchSourceBuilder) throws IOException {
//        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz, startDate, endDate, searchSourceBuilder);
//        return this.search(searchRequest);
//    }

    public final ElasticsearchIndicesClient indices() {
        return client.indices();
    }

    public final boolean exists(String poolId) throws IOException {
        BooleanResponse response = client.indices().exists(new ExistsRequest.Builder().index(poolId).build());
        return response.value();
    }

    public final CreateIndexResponse create(CreateIndexRequest createIndexRequest) throws IOException {
        return client.indices().create(createIndexRequest);
    }

    public final PutMappingResponse putMapping(PutMappingRequest putMappingRequest) throws IOException {
        return client.indices().putMapping(putMappingRequest);
    }

    public final UpdateByQueryResponse updateByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        return client.updateByQuery(updateByQueryRequest);
    }

    public final DeleteByQueryResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        return client.deleteByQuery(deleteByQueryRequest);
    }

}
