/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import com.viontech.keliu.configuration.elasticsearch.annotation.Template;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ESRequestFactory {
    public static SearchRequest.Builder getSearchRequest(Class clazz) {
        String index = ESUtil.getBaseIndexName(clazz);
        if (StringUtils.isEmpty((CharSequence)index)) {
            throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new SearchRequest.Builder().index(index, new String[0]);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, SourceConfig sourceConfig) {
        return ESRequestFactory.getSearchRequest(clazz).source(sourceConfig);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date date) {
        String index = ESUtil.getBaseIndexName(clazz);
        Template template = clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            try {
                Field declaredField = clazz.getDeclaredField(field);
                if (null != declaredField && Date.class == declaredField.getType() && StringUtils.isNotBlank((CharSequence)field)) {
                    String format = DateUtil.format((Date)date, (String)dateFormat);
                    index = index + "-" + format;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty((CharSequence)index)) {
            throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ESRequestFactory.getIgnoreUnavailableRequest(index);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date date, SourceConfig sourceConfig) {
        return ESRequestFactory.getSearchRequest(clazz, date).source(sourceConfig);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        String index = ESUtil.getBaseIndexName(clazz);
        Template template = clazz.getAnnotation(Template.class);
        if (null != template) {
            String dateFormat = template.dataFormat();
            String field = template.dateField();
            try {
                Field declaredField = clazz.getDeclaredField(field);
                if (null != declaredField && Date.class == declaredField.getType() && StringUtils.isNotBlank((CharSequence)field)) {
                    startDate = DateUtil.beginOfMonth((Date)startDate);
                    endDate = DateUtil.endOfMonth((Date)endDate);
                    ArrayList<String> indexList = new ArrayList<String>();
                    do {
                        String format = DateUtil.format((Date)startDate, (String)dateFormat);
                        String indexName = index + "-" + format;
                        indexList.add(indexName);
                    } while ((startDate = DateUtil.offsetMonth((Date)startDate, (int)1)).before(endDate));
                    if (ArrayUtil.isNotEmpty(indexList)) {
                        String[] indices = indexList.toArray(new String[indexList.size()]);
                        return ESRequestFactory.getIgnoreUnavailableRequest(indices);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty((CharSequence)index)) {
            throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new SearchRequest.Builder().index(index, new String[0]);
    }

    public static SearchRequest.Builder getSearchRequest(Class clazz, Date startDate, Date endDate, SourceConfig sourceConfig) {
        return ESRequestFactory.getSearchRequest(clazz, startDate, endDate).source(sourceConfig);
    }

    private static SearchRequest.Builder getIgnoreUnavailableRequest(String ... indices) {
        SearchRequest.Builder request = new SearchRequest.Builder().index(Arrays.asList(indices));
        request.ignoreUnavailable(Boolean.valueOf(true));
        return request;
    }
}

