/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch.Configuration;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.viontech.keliu.configuration.elasticsearch.Configuration.CustomElasticsearchProperties;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ElasticsearchConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.elasticsearch.rest")
    public CustomElasticsearchProperties Properties() {
        return new CustomElasticsearchProperties();
    }

    @Bean
    public ElasticsearchClient createElasticsearchClient(CustomElasticsearchProperties properties) {
        HttpHost[] esHosts = (HttpHost[])properties.getUris().stream().filter(StringUtils::hasLength).map(HttpHost::create).toArray(HttpHost[]::new);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (properties.getUsername() != null) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(properties.getUsername(), properties.getPassword()));
        }
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(properties.getIoThreadCount().intValue()).setConnectTimeout(10).setRcvBufSize(5).setSoKeepAlive(true).build();
        PoolingNHttpClientConnectionManager connectionManager = null;
        try {
            connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(ioReactorConfig));
            connectionManager.setMaxTotal(100);
            connectionManager.setDefaultMaxPerRoute(20);
        }
        catch (IOReactorException e) {
            throw new RuntimeException(e);
        }
        PoolingNHttpClientConnectionManager finalConnectionManager = connectionManager;
        RestClient restClient = RestClient.builder((HttpHost[])esHosts).setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(properties.getConnectionTimeout());
            requestConfigBuilder.setSocketTimeout(properties.getSocketTimeout());
            requestConfigBuilder.setConnectionRequestTimeout(-1);
            return requestConfigBuilder;
        }).setHttpClientConfigCallback(arg_0 -> ElasticsearchConfiguration.lambda$createElasticsearchClient$3(properties, (CredentialsProvider)credentialsProvider, finalConnectionManager, arg_0)).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticsearchClient$3(CustomElasticsearchProperties properties, CredentialsProvider credentialsProvider, PoolingNHttpClientConnectionManager finalConnectionManager, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setMaxConnTotal(properties.getMaxConnTotal().intValue());
        httpClientBuilder.setMaxConnPerRoute(properties.getMaxConnPerRoute().intValue());
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpClientBuilder.setConnectionManager((NHttpClientConnectionManager)finalConnectionManager);
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
            httpClientBuilder.setSSLContext(sslContext);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            System.out.println("\u5ffd\u7565\u8bc1\u4e66\u9519\u8bef");
        }
        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        return httpClientBuilder;
    }
}

