/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

package com.viontech.keliu.configuration.elasticsearch.query;


import org.locationtech.jts.geom.Coordinate;
import org.springframework.data.geo.Point;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

///**
// * Derived {@link AbstractGeometryQueryBuilder} that builds a lat, lon GeoShape Query. It
// * can be applied to any {@link MappedFieldType} that implements {@link GeoShapeQueryable}.
// *
// * GeoJson and WKT shape definitions are supported
// */
//public class ShapeQueryBuilder extends AbstractGeometryQueryBuilder<ShapeQueryBuilder> {
//    public static final String NAME = "shape";
//    private static final DeprecationLogger deprecationLogger =  DeprecationLogger.getLogger(ShapeQueryBuilder.class);
//
//    protected static final ParseField STRATEGY_FIELD = new ParseField("strategy");
//    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [geo_shape] queries. " +
//            "The type should no longer be specified in the [indexed_shape] section.";
//
//    private SpatialStrategy strategy;
//
//    /**
//     * Creates a new ShapeQueryBuilder whose Query will be against the given
//     * field name using the given Shape
//     *
//     * @param fieldName
//     *            Name of the field that will be queried
//     * @param shape
//     *            Shape used in the Query
//     */
//    public ShapeQueryBuilder(String fieldName, Geometry shape) {
//        super(fieldName, shape);
//    }
//
//    /**
//     * 创建一个ShapeQueryBuilder with fieldName 和多边形的点
//     * @param fieldName 字段名
//     * @param points 多边形的点
//     * @return
//     */
//    public static ShapeQueryBuilder newInShapeQueryBuilder(String fieldName, List<Point> points) {
//        if (CollectionUtils.isEmpty(points)) {
//            throw new RuntimeException("点不能为空");
//        }
//        Point firstPoint = points.get(0);
//        Point lastPoint = points.get(points.size() - 1);
//        if (firstPoint.getX() == lastPoint.getX() && firstPoint.getY() == lastPoint.getY()) {
//            //如果是闭合的
//            if (points.size() < 4) {
//                throw new RuntimeException("闭合的多边形不能少于4个点");
//            }
//        } else {
//            //如果是非闭合的
//            if (points.size() < 3) {
//                throw new RuntimeException("非闭合的多边形不能少于3个点");
//            }
//            //非闭合的加上第一个点，闭合起来
//            points.add(firstPoint);
//        }
//        CoordinatesBuilder coordinatesBuilder = new CoordinatesBuilder();
//        for (Point point : points) {
//            coordinatesBuilder.coordinate(new Coordinate(point.getX(), point.getY()));
//        }
//        PolygonBuilder polygonBuilder = new PolygonBuilder(coordinatesBuilder);
//        return new ShapeQueryBuilder(fieldName, polygonBuilder.buildGeometry());
//    }
//
//    /**
//     * 搜索多个多边形内的点
//     * @param fieldName
//     * @param multiPoints
//     * @return
//     */
//    public static ShapeQueryBuilder newInShapesQueryBuilder(String fieldName, List<List<Point>> multiPoints) {
//        if (CollectionUtils.isEmpty(multiPoints)) {
//            throw new RuntimeException("点不能为空");
//        }
//        for (List<Point> points : multiPoints) {
//            Point firstPoint = points.get(0);
//            Point lastPoint = points.get(points.size() - 1);
//            if (firstPoint.getX() == lastPoint.getX() && firstPoint.getY() == lastPoint.getY()) {
//                //如果是闭合的
//                if (points.size() < 4) {
//                    throw new RuntimeException("闭合的多边形不能少于4个点");
//                }
//            } else {
//                //如果是非闭合的
//                if (points.size() < 3) {
//                    throw new RuntimeException("非闭合的多边形不能少于3个点");
//                }
//                //非闭合的加上第一个点，闭合起来
//                points.add(firstPoint);
//            }
//        }
//        MultiPolygonBuilder multiPolygonBuilder = new MultiPolygonBuilder();
//        for (List<Point> points : multiPoints) {
//            CoordinatesBuilder coordinatesBuilder = new CoordinatesBuilder();
//            for (Point point : points) {
//                coordinatesBuilder.coordinate(new Coordinate(point.getX(), point.getY()));
//            }
//            PolygonBuilder polygonBuilder = new PolygonBuilder(coordinatesBuilder);
//            multiPolygonBuilder.polygon(polygonBuilder);
//        }
//        return new ShapeQueryBuilder(fieldName, multiPolygonBuilder.buildGeometry());
//    }
//
//
//    /**
//     * Creates a new ShapeQueryBuilder whose Query will be against the given
//     * field name using the given Shape
//     *
//     * @param fieldName
//     *            Name of the field that will be queried
//     * @param shape
//     *            Shape used in the Query
//     *
//     * @deprecated use {@link #ShapeQueryBuilder(String, Geometry)} instead
//     */
//    @Deprecated
//    public ShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
//        super(fieldName, shape);
//    }
//
//    public ShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId,
//                                @Nullable String indexedShapeType) {
//        super(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
//    }
//
//    /**
//     * Creates a new ShapeQueryBuilder whose Query will be against the given
//     * field name and will use the Shape found with the given ID in the given
//     * type
//     *
//     * @param fieldName
//     *            Name of the field that will be filtered
//     * @param indexedShapeId
//     *            ID of the indexed Shape that will be used in the Query
//     * @param indexedShapeType
//     *            Index type of the indexed Shapes
//     * @deprecated use {@link #ShapeQueryBuilder(String, String)} instead
//     */
//    @Deprecated
//    public ShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
//        super(fieldName, indexedShapeId, indexedShapeType);
//    }
//
//    /**
//     * Creates a new ShapeQueryBuilder whose Query will be against the given
//     * field name and will use the Shape found with the given ID
//     *
//     * @param fieldName
//     *            Name of the field that will be filtered
//     * @param indexedShapeId
//     *            ID of the indexed Shape that will be used in the Query
//     */
//    public ShapeQueryBuilder(String fieldName, String indexedShapeId) {
//        super(fieldName, indexedShapeId);
//    }
//
//    public ShapeQueryBuilder(StreamInput in) throws IOException {
//        super(in);
//        strategy = in.readOptionalWriteable(SpatialStrategy::readFromStream);
//    }
//
//    @Override
//    protected void doWriteTo(StreamOutput out) throws IOException {
//        super.doWriteTo(out);
//        out.writeOptionalWriteable(strategy);
//    }
//
//    @Override
//    public String getWriteableName() {
//        return NAME;
//    }
//
//    /**
//     * Sets the relation of query shape and indexed shape.
//     *
//     * @param relation relation of the shapes
//     * @return this
//     */
//    public ShapeQueryBuilder relation(ShapeRelation relation) {
//        if (relation == null) {
//            throw new IllegalArgumentException("No Shape Relation defined");
//        }
//        if (SpatialStrategy.TERM.equals(strategy) && relation != ShapeRelation.INTERSECTS) {
//            throw new IllegalArgumentException("current strategy [" + strategy.getStrategyName() + "] only supports relation ["
//                    + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
//        }
//        this.relation = relation;
//        return this;
//    }
//
//    /**
//     * Defines which spatial strategy will be used for building the geo shape
//     * Query. When not set, the strategy that will be used will be the one that
//     * is associated with the geo shape field in the mappings.
//     *
//     * @param strategy
//     *            The spatial strategy to use for building the geo shape Query
//     * @return this
//     */
//    public ShapeQueryBuilder strategy(SpatialStrategy strategy) {
//        if (strategy != null && strategy == SpatialStrategy.TERM && relation != ShapeRelation.INTERSECTS) {
//            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation ["
//                    + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
//        }
//        this.strategy = strategy;
//        return this;
//    }
//    /**
//     * @return The spatial strategy to use for building the geo shape Query
//     */
//    public SpatialStrategy strategy() {
//        return strategy;
//    }
//
//    @Override
//    public void doShapeQueryXContent(XContentBuilder builder, Params params) throws IOException {
//        if (strategy != null) {
//            builder.field(STRATEGY_FIELD.getPreferredName(), strategy.getStrategyName());
//        }
//    }
//
//    @Override
//    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
//        return new ShapeQueryBuilder(fieldName, shape);
//    }
//
//    @Override
//    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier,
//                                                        String indexedShapeId, String indexedShapeType) {
//        return new ShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
//    }
//
//    @Override
//    public Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
//        if ((fieldType instanceof GeoShapeQueryable) == false) {
//            throw new QueryShardException(context,
//                    "Field [" + fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [" + NAME + "] query");
//        }
//        final GeoShapeQueryable ft = (GeoShapeQueryable) fieldType;
//        return new ConstantScoreQuery(ft.geoShapeQuery(shape, fieldName, strategy, relation, context));
//    }
//
//    @Override
//    protected boolean doEquals(ShapeQueryBuilder other) {
//        return super.doEquals((AbstractGeometryQueryBuilder)other)
//                && Objects.equals(strategy, other.strategy);
//    }
//
//    @Override
//    protected int doHashCode() {
//        return Objects.hash(super.doHashCode(), strategy);
//    }
//
//    @Override
//    protected ShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
//        ShapeQueryBuilder builder = (ShapeQueryBuilder)super.doRewrite(queryRewriteContext);
//        builder.strategy(strategy);
//        return builder;
//    }
//
//    private static class ParsedGeoShapeQueryParams extends ParsedGeometryQueryParams {
//        SpatialStrategy strategy;
//
//        @Override
//        protected boolean parseXContentField(XContentParser parser) throws IOException {
//            SpatialStrategy strategy;
//            if (SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
//                this.shape = ShapeParser.parse(parser);
//                return true;
//            } else if (STRATEGY_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
//                String strategyName = parser.text();
//                strategy = SpatialStrategy.fromString(strategyName, deprecationLogger);
//                if (strategy == null) {
//                    throw new ParsingException(parser.getTokenLocation(), "Unknown strategy [" + strategyName + " ]");
//                } else {
//                    this.strategy = strategy;
//                }
//                return true;
//            }
//            return false;
//        }
//    }
//
//    public static ShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
//        ParsedGeoShapeQueryParams pgsqp =
//                (ParsedGeoShapeQueryParams) AbstractGeometryQueryBuilder.parsedParamsFromXContent(parser, new ParsedGeoShapeQueryParams());
//
//        ShapeQueryBuilder builder;
//        if (pgsqp.type != null) {
//            deprecationLogger.deprecate(DeprecationCategory.TYPES, "share_query_with_types", TYPES_DEPRECATION_MESSAGE);
//        }
//
//        if (pgsqp.shape != null) {
//            builder = new ShapeQueryBuilder(pgsqp.fieldName, pgsqp.shape);
//        } else {
//            builder = new ShapeQueryBuilder(pgsqp.fieldName, pgsqp.id, pgsqp.type);
//        }
//
//        if (pgsqp.index != null) {
//            builder.indexedShapeIndex(pgsqp.index);
//        }
//
//        if (pgsqp.shapePath != null) {
//            builder.indexedShapePath(pgsqp.shapePath);
//        }
//
//        if (pgsqp.shapeRouting != null) {
//            builder.indexedShapeRouting(pgsqp.shapeRouting);
//        }
//
//        if (pgsqp.relation != null) {
//            builder.relation(pgsqp.relation);
//        }
//
//        if (pgsqp.strategy != null) {
//            builder.strategy(pgsqp.strategy);
//        }
//
//        if (pgsqp.queryName != null) {
//            builder.queryName(pgsqp.queryName);
//        }
//
//        builder.boost(pgsqp.boost);
//        builder.ignoreUnmapped(pgsqp.ignoreUnmapped);
//        return builder;
//    }
//}
