package com.viontech.keliu.configuration.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import org.elasticsearch.client.RequestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Author: inggg
 * Date: 2019/8/12 9:42
 */
@Configuration
public class ESConfig {

    private static final Logger logger = LoggerFactory.getLogger(ESConfig.class);

    //ES查询结果最大数量
    public static final Integer MAX_SIZE = 200000;

    @Bean
    @ConditionalOnProperty("spring.elasticsearch.rest.uris")
    ESClient esClient(ElasticsearchClient elasticsearchClient) {
        RequestOptions options = RequestOptions.DEFAULT;
        ESClient client = new ESClient(elasticsearchClient, options);
        return client;
    }

}

