/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch.util;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AndQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AndQueryBuilder.class);
    private BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();

    public AndQueryBuilder eq(String field, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return this;
        }
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)field, (String)value));
        return this;
    }

    public AndQueryBuilder eq(String field, Integer value) {
        if (null == value) {
            return this;
        }
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)field, (Object)value));
        return this;
    }

    public AndQueryBuilder in(String field, String ... values) {
        if (null == values || values.length == 0) {
            return this;
        }
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)field, (String[])values));
        return this;
    }

    public AndQueryBuilder in(String field, Integer ... values) {
        if (null == values || values.length == 0) {
            return this;
        }
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)field, (Object[])values));
        return this;
    }

    public AndQueryBuilder in(String field, Collection<?> values) {
        if (CollectionUtils.isEmpty(values)) {
            return this;
        }
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)field, values));
        return this;
    }

    public AndQueryBuilder like(String field, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return this;
        }
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)("*" + value + "*")));
        return this;
    }

    public AndQueryBuilder between(String field, Object from, boolean includeLower, Object to, boolean includeUpper) {
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)field);
        if (null == from && null == to) {
            return this;
        }
        if (null != from) {
            rangeQueryBuilder.from(from, includeLower);
        }
        if (null != to) {
            rangeQueryBuilder.to(to, includeUpper);
        }
        this.boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
        return this;
    }

    public AndQueryBuilder exists(String field, boolean includeNullString) {
        this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.existsQuery((String)field));
        if (!includeNullString) {
            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
            subBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)field, (String)""));
            this.boolQueryBuilder.filter((QueryBuilder)subBoolQueryBuilder);
        }
        return this;
    }

    public AndQueryBuilder notExists(String field, boolean includeNullString) {
        if (includeNullString) {
            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
            subBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)field, (String)""));
            subBoolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field)));
            this.boolQueryBuilder.filter((QueryBuilder)subBoolQueryBuilder);
        } else {
            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
            subBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field));
            this.boolQueryBuilder.filter((QueryBuilder)subBoolQueryBuilder);
        }
        return this;
    }

    public BoolQueryBuilder build() {
        return this.boolQueryBuilder;
    }
}

