/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.locationtech.jts.geom.Coordinate;
import org.springframework.data.geo.Point;
import org.springframework.util.CollectionUtils;

public class ShapeQueryBuilder
extends AbstractGeometryQueryBuilder<ShapeQueryBuilder> {
    public static final String NAME = "shape";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ShapeQueryBuilder.class);
    protected static final ParseField STRATEGY_FIELD = new ParseField("strategy", new String[0]);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [geo_shape] queries. The type should no longer be specified in the [indexed_shape] section.";
    private SpatialStrategy strategy;

    public ShapeQueryBuilder(String fieldName, Geometry shape) {
        super(fieldName, shape);
    }

    public static ShapeQueryBuilder newInShapeQueryBuilder(String fieldName, List<Point> points) {
        if (CollectionUtils.isEmpty(points)) {
            throw new RuntimeException("\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Point firstPoint = points.get(0);
        Point lastPoint = points.get(points.size() - 1);
        if (firstPoint.getX() == lastPoint.getX() && firstPoint.getY() == lastPoint.getY()) {
            if (points.size() < 4) {
                throw new RuntimeException("\u95ed\u5408\u7684\u591a\u8fb9\u5f62\u4e0d\u80fd\u5c11\u4e8e4\u4e2a\u70b9");
            }
        } else {
            if (points.size() < 3) {
                throw new RuntimeException("\u975e\u95ed\u5408\u7684\u591a\u8fb9\u5f62\u4e0d\u80fd\u5c11\u4e8e3\u4e2a\u70b9");
            }
            points.add(firstPoint);
        }
        CoordinatesBuilder coordinatesBuilder = new CoordinatesBuilder();
        for (Point point : points) {
            coordinatesBuilder.coordinate(new Coordinate(point.getX(), point.getY()));
        }
        PolygonBuilder polygonBuilder = new PolygonBuilder(coordinatesBuilder);
        return new ShapeQueryBuilder(fieldName, polygonBuilder.buildGeometry());
    }

    public static ShapeQueryBuilder newInShapesQueryBuilder(String fieldName, List<List<Point>> multiPoints) {
        if (CollectionUtils.isEmpty(multiPoints)) {
            throw new RuntimeException("\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (List<Point> points : multiPoints) {
            Point firstPoint = points.get(0);
            Point lastPoint = points.get(points.size() - 1);
            if (firstPoint.getX() == lastPoint.getX() && firstPoint.getY() == lastPoint.getY()) {
                if (points.size() >= 4) continue;
                throw new RuntimeException("\u95ed\u5408\u7684\u591a\u8fb9\u5f62\u4e0d\u80fd\u5c11\u4e8e4\u4e2a\u70b9");
            }
            if (points.size() < 3) {
                throw new RuntimeException("\u975e\u95ed\u5408\u7684\u591a\u8fb9\u5f62\u4e0d\u80fd\u5c11\u4e8e3\u4e2a\u70b9");
            }
            points.add(firstPoint);
        }
        MultiPolygonBuilder multiPolygonBuilder = new MultiPolygonBuilder();
        for (List<Point> points : multiPoints) {
            CoordinatesBuilder coordinatesBuilder = new CoordinatesBuilder();
            for (Point point : points) {
                coordinatesBuilder.coordinate(new Coordinate(point.getX(), point.getY()));
            }
            PolygonBuilder polygonBuilder = new PolygonBuilder(coordinatesBuilder);
            multiPolygonBuilder.polygon(polygonBuilder);
        }
        return new ShapeQueryBuilder(fieldName, (Geometry)multiPolygonBuilder.buildGeometry());
    }

    @Deprecated
    public ShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
        super(fieldName, shape);
    }

    public ShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, @Nullable String indexedShapeType) {
        super(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    @Deprecated
    public ShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
        super(fieldName, indexedShapeId, indexedShapeType);
    }

    public ShapeQueryBuilder(String fieldName, String indexedShapeId) {
        super(fieldName, indexedShapeId);
    }

    public ShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.strategy = (SpatialStrategy)in.readOptionalWriteable(SpatialStrategy::readFromStream);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeOptionalWriteable((Writeable)this.strategy);
    }

    public String getWriteableName() {
        return NAME;
    }

    public ShapeQueryBuilder relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        if (SpatialStrategy.TERM.equals((Object)this.strategy) && relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("current strategy [" + this.strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
        }
        this.relation = relation;
        return this;
    }

    public ShapeQueryBuilder strategy(SpatialStrategy strategy) {
        if (strategy != null && strategy == SpatialStrategy.TERM && this.relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + this.relation.getRelationName() + "]");
        }
        this.strategy = strategy;
        return this;
    }

    public SpatialStrategy strategy() {
        return this.strategy;
    }

    public void doShapeQueryXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.strategy != null) {
            builder.field(STRATEGY_FIELD.getPreferredName(), this.strategy.getStrategyName());
        }
    }

    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
        return new ShapeQueryBuilder(fieldName, shape);
    }

    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, String indexedShapeType) {
        return new ShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    public Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
        if (!(fieldType instanceof GeoShapeQueryable)) {
            throw new QueryShardException(context, "Field [" + this.fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [" + NAME + "] query", new Object[0]);
        }
        GeoShapeQueryable ft = (GeoShapeQueryable)fieldType;
        return new ConstantScoreQuery(ft.geoShapeQuery(this.shape, this.fieldName, this.strategy, this.relation, context));
    }

    protected boolean doEquals(ShapeQueryBuilder other) {
        return super.doEquals((AbstractGeometryQueryBuilder)other) && Objects.equals(this.strategy, other.strategy);
    }

    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.strategy);
    }

    protected ShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        ShapeQueryBuilder builder = (ShapeQueryBuilder)super.doRewrite(queryRewriteContext);
        builder.strategy(this.strategy);
        return builder;
    }

    public static ShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedGeoShapeQueryParams pgsqp = (ParsedGeoShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent((XContentParser)parser, (AbstractGeometryQueryBuilder.ParsedGeometryQueryParams)new ParsedGeoShapeQueryParams());
        if (pgsqp.type != null) {
            deprecationLogger.deprecate(DeprecationCategory.TYPES, "share_query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        ShapeQueryBuilder builder = pgsqp.shape != null ? new ShapeQueryBuilder(pgsqp.fieldName, pgsqp.shape) : new ShapeQueryBuilder(pgsqp.fieldName, pgsqp.id, pgsqp.type);
        if (pgsqp.index != null) {
            builder.indexedShapeIndex(pgsqp.index);
        }
        if (pgsqp.shapePath != null) {
            builder.indexedShapePath(pgsqp.shapePath);
        }
        if (pgsqp.shapeRouting != null) {
            builder.indexedShapeRouting(pgsqp.shapeRouting);
        }
        if (pgsqp.relation != null) {
            builder.relation(pgsqp.relation);
        }
        if (pgsqp.strategy != null) {
            builder.strategy(pgsqp.strategy);
        }
        if (pgsqp.queryName != null) {
            builder.queryName(pgsqp.queryName);
        }
        builder.boost(pgsqp.boost);
        builder.ignoreUnmapped(pgsqp.ignoreUnmapped);
        return builder;
    }

    private static class ParsedGeoShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        SpatialStrategy strategy;

        private ParsedGeoShapeQueryParams() {
        }

        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                this.shape = ShapeParser.parse((XContentParser)parser);
                return true;
            }
            if (STRATEGY_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                String strategyName = parser.text();
                SpatialStrategy strategy = SpatialStrategy.fromString((String)strategyName, (DeprecationLogger)deprecationLogger);
                if (strategy == null) {
                    throw new ParsingException(parser.getTokenLocation(), "Unknown strategy [" + strategyName + " ]", new Object[0]);
                }
                this.strategy = strategy;
                return true;
            }
            return false;
        }
    }
}

