/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch;

import cn.hutool.core.util.ClassUtil;
import com.viontech.keliu.configuration.elasticsearch.ESClient;
import com.viontech.keliu.configuration.elasticsearch.ESConfig;
import com.viontech.keliu.configuration.elasticsearch.annotation.ESPrefix;
import com.viontech.keliu.configuration.elasticsearch.annotation.Template;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.index.MappingBuilder;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"spring.elasticsearch.rest.uris"})
public class EsInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(EsInit.class);
    @Autowired
    private ElasticsearchRestTemplate template;
    @Autowired
    private ESClient esClient;

    public void run(String ... args) throws Exception {
        Set templates = ClassUtil.scanPackageByAnnotation((String)"com.viontech", Template.class);
        for (Class clazz : templates) {
            String templateName;
            Template annotation = clazz.getAnnotation(Template.class);
            ESPrefix prefixAnnotation = clazz.getAnnotation(ESPrefix.class);
            ArrayList<String> patterns = new ArrayList<String>(annotation.patterns().length);
            if (null != prefixAnnotation) {
                String[] prefix = ESUtil.getPrefix(prefixAnnotation);
                templateName = (String)prefix + "-" + annotation.templateName();
                String[] stringArray = annotation.patterns();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String pattern = stringArray[i];
                    patterns.add((String)prefix + "-" + pattern);
                }
            } else {
                templateName = annotation.templateName();
                for (String pattern : annotation.patterns()) {
                    patterns.add(pattern);
                }
            }
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName);
            MappingBuilder mappingBuilder = new MappingBuilder(this.template.getElasticsearchConverter());
            String mapping = mappingBuilder.buildPropertyMapping(clazz);
            request.patterns(patterns);
            ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.template.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(clazz);
            Settings settings = persistentEntity.getDefaultSettings();
            settings.append("index.max_result_window", (Object)ESConfig.MAX_SIZE);
            request.mapping(mapping, XContentType.JSON);
            request.settings((Map)settings);
            AcknowledgedResponse acknowledgedResponse = this.esClient.indices().putTemplate(request, RequestOptions.DEFAULT);
            if (!acknowledgedResponse.isAcknowledged()) continue;
            log.info("\u6a21\u677f\u521b\u5efa\u5b8c\u6210");
        }
        Set classes = ClassUtil.scanPackageByAnnotation((String)"com.viontech", Document.class);
        for (Class clazz : classes) {
            boolean b;
            if (!clazz.getAnnotation(Document.class).createIndex() || !(b = this.template.indexOps(clazz).putMapping(clazz))) continue;
            log.info("{}\u7d22\u5f15\u66f4\u65b0\u6210\u529f", (Object)clazz.getName());
        }
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(15000L);
                        this.esClient.info();
                    }
                }
                catch (Exception e) {
                    log.error("EsQueryHandler error", (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }
}

