/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration.elasticsearch;

import com.alibaba.fastjson.JSON;
import com.viontech.keliu.configuration.elasticsearch.ESRequestFactory;
import com.viontech.keliu.configuration.elasticsearch.util.ESUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

public class ESClient {
    private RestHighLevelClient client;
    private RequestOptions options;

    public ESClient(RestHighLevelClient client, RequestOptions options) {
        this.client = client;
        this.options = options;
    }

    public final MainResponse info() throws IOException {
        return this.client.info(this.options);
    }

    public final <T> List<T> select(T t) throws Exception {
        Field[] fields;
        Class<?> clazz = t.getClass();
        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Class<Object> type = field.getType();
            field.setAccessible(true);
            Object value = field.get(t);
            if (Objects.isNull(value) || type.isAssignableFrom(Date.class) || type.isAssignableFrom(List.class)) continue;
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)name, (Object)value);
            boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse response = this.client.search(searchRequest, this.options);
        SearchHits hits = response.getHits();
        SearchHit[] hits1 = hits.getHits();
        ArrayList<Object> results = new ArrayList<Object>();
        if (0 == hits1.length) {
            return results;
        }
        for (SearchHit hit : hits1) {
            String sourceAsString = hit.getSourceAsString();
            Object t1 = JSON.parseObject((String)sourceAsString, clazz);
            String id = hit.getId();
            Field idField = clazz.getDeclaredField("id");
            if (null != idField) {
                idField.setAccessible(true);
                idField.set(t1, id);
            }
            results.add(t1);
        }
        return results;
    }

    public final <T> T findById(T t) throws Exception {
        Class<?> clazz = t.getClass();
        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(t.getClass());
        Field[] fields = clazz.getDeclaredFields();
        Object id = null;
        for (Field field : fields) {
            Id idAnnotation = field.getAnnotation(Id.class);
            if (null == idAnnotation) continue;
            field.setAccessible(true);
            id = field.get(t);
            if (!Objects.isNull(id)) break;
            throw new RuntimeException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery().addIds(new String[]{(String)id});
        searchSourceBuilder.query((QueryBuilder)idsQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse response = this.client.search(searchRequest, this.options);
        SearchHits hits = response.getHits();
        SearchHit[] hits1 = hits.getHits();
        if (0 == hits1.length) {
            return null;
        }
        SearchHit searchHit = hits1[0];
        String sourceAsString = searchHit.getSourceAsString();
        Object t1 = JSON.parseObject((String)sourceAsString, clazz);
        String id1 = searchHit.getId();
        Field idField = clazz.getDeclaredField("id");
        if (idField != null) {
            idField.setAccessible(true);
            idField.set(t1, id1);
        }
        return (T)t1;
    }

    public final <T> T saveOrUpdate(T t) throws Exception {
        return this.saveOrUpdate(t, false);
    }

    public final <T> T saveOrUpdate(T t, boolean delayRefresh) throws Exception {
        Class<?> clazz = t.getClass();
        String index = this.getIndexName(t);
        Field[] fields = clazz.getDeclaredFields();
        int idCount = 0;
        Field idField = null;
        for (Field field : fields) {
            Id idAnnotation = field.getAnnotation(Id.class);
            if (null == idAnnotation) continue;
            ++idCount;
            idField = field;
        }
        if (idCount > 1) {
            throw new RuntimeException(clazz.getName() + "\u6709\u4e24\u4e2aid");
        }
        String s = JSON.toJSONString(t);
        IndexRequest indexRequest = new IndexRequest(index);
        if (delayRefresh) {
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
        } else {
            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        }
        if (null != idField) {
            idField.setAccessible(true);
            Object id = idField.get(t);
            if (null != id) {
                indexRequest.id(id.toString());
            }
        }
        indexRequest.source(s, XContentType.JSON);
        IndexResponse indexResponse = this.index(indexRequest);
        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED || indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
            return t;
        }
        return null;
    }

    private <T> String getIndexName(T t) throws Exception {
        return ESUtil.getIndexName(t);
    }

    public final <T> BulkResponse batchUpsert(List<T> tList) throws Exception {
        return this.batchUpsert(tList, false);
    }

    public final <T> BulkResponse batchUpsert(List<T> tList, boolean delayRefresh) throws Exception {
        BulkRequest bulkRequest = null;
        int count = 0;
        for (T t : tList) {
            Class<?> clazz;
            Document annotation;
            if (null == bulkRequest) {
                bulkRequest = new BulkRequest();
                if (delayRefresh) {
                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
                } else {
                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
                }
            }
            if (null == (annotation = (clazz = t.getClass()).getAnnotation(Document.class))) {
                throw new RuntimeException("\u65e0\u6cd5\u4f7f\u7528ES upsert\u65b9\u6cd5");
            }
            String index = annotation.indexName();
            if (StringUtils.isEmpty((CharSequence)index)) {
                throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Field[] fields = clazz.getDeclaredFields();
            Field idField = null;
            for (Field field : fields) {
                Id idAnnotation = field.getAnnotation(Id.class);
                if (null == idAnnotation) continue;
                idField = field;
                break;
            }
            if (Objects.isNull(idField)) {
                throw new NullPointerException("\u6ca1\u6709id\u5b57\u6bb5");
            }
            idField.setAccessible(true);
            Object id = idField.get(t);
            if (Objects.isNull(id)) {
                throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UpdateRequest request = new UpdateRequest(index, (String)id);
            String json = JSON.toJSONString(t);
            request.doc(json, XContentType.JSON);
            request.docAsUpsert(true);
            bulkRequest.add(request);
            if (++count <= 10000) continue;
            BulkResponse bulk = this.bulk(bulkRequest);
            boolean hasFailures = bulk.hasFailures();
            if (hasFailures) {
                return bulk;
            }
            count = 0;
            bulkRequest = null;
        }
        BulkResponse bulk = this.bulk(bulkRequest);
        return bulk;
    }

    public final <T> String upsert(T t) throws Exception {
        return this.upsert(t, false);
    }

    public final <T> String upsert(T t, boolean delayRefresh) throws Exception {
        if (Objects.isNull(t)) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Class<?> clazz = t.getClass();
        Document annotation = clazz.getAnnotation(Document.class);
        if (null == annotation) {
            throw new RuntimeException("\u65e0\u6cd5\u4f7f\u7528ES upsert\u65b9\u6cd5");
        }
        String index = annotation.indexName();
        if (StringUtils.isEmpty((CharSequence)index)) {
            throw new RuntimeException("\u7d22\u5f15\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Field[] fields = clazz.getDeclaredFields();
        Field idField = null;
        for (Field field : fields) {
            Id idAnnotation = field.getAnnotation(Id.class);
            if (null == idAnnotation) continue;
            idField = field;
            break;
        }
        if (Objects.isNull(idField)) {
            throw new NullPointerException("\u6ca1\u6709id\u5b57\u6bb5");
        }
        idField.setAccessible(true);
        Object id = idField.get(t);
        if (Objects.isNull(id)) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UpdateRequest request = new UpdateRequest(index, (String)id);
        String json = JSON.toJSONString(t);
        request.doc(json, XContentType.JSON);
        request.docAsUpsert(true);
        if (delayRefresh) {
            request.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
        } else {
            request.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        }
        UpdateResponse response = this.update(request);
        return response.getResult().getLowercase();
    }

    public final UpdateResponse update(UpdateRequest request) throws IOException {
        return this.client.update(request, this.options);
    }

    public final <T> BulkResponse batchSaveOrUpdate(List<T> tList) throws Exception {
        return this.batchSaveOrUpdate(tList, false);
    }

    public final <T> BulkResponse batchSaveOrUpdate(List<T> tList, boolean delayRefresh) throws Exception {
        BulkRequest bulkRequest = null;
        int count = 0;
        for (T t : tList) {
            if (null == bulkRequest) {
                bulkRequest = new BulkRequest();
                if (delayRefresh) {
                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
                } else {
                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
                }
            }
            Class<?> clazz = t.getClass();
            String index = this.getIndexName(t);
            Field[] fields = clazz.getDeclaredFields();
            int idCount = 0;
            Field idField = null;
            for (Field field : fields) {
                Id idAnnotation = field.getAnnotation(Id.class);
                if (null == idAnnotation) continue;
                ++idCount;
                idField = field;
            }
            if (idCount > 1) {
                throw new RuntimeException(clazz.getName() + "\u6709\u4e24\u4e2aid");
            }
            String s = JSON.toJSONString(t);
            IndexRequest indexRequest = new IndexRequest(index);
            if (null != idField) {
                idField.setAccessible(true);
                Object id = idField.get(t);
                if (null != id) {
                    indexRequest.id(id.toString());
                }
            }
            indexRequest.source(s, XContentType.JSON);
            bulkRequest.add(indexRequest);
            if (++count <= 10000) continue;
            BulkResponse bulk = this.bulk(bulkRequest);
            boolean hasFailures = bulk.hasFailures();
            if (hasFailures) {
                return bulk;
            }
            count = 0;
            bulkRequest = null;
        }
        BulkResponse bulk = this.bulk(bulkRequest);
        return bulk;
    }

    public final IndexResponse index(IndexRequest indexRequest) throws IOException {
        return this.client.index(indexRequest, this.options);
    }

    public final BulkResponse bulk(BulkRequest bulkRequest) throws IOException {
        return this.client.bulk(bulkRequest, this.options);
    }

    public final DeleteResponse delete(DeleteRequest deleteRequest) throws IOException {
        return this.client.delete(deleteRequest, this.options);
    }

    public final SearchResponse search(SearchRequest searchRequest) throws IOException {
        searchRequest.source().trackTotalHits(true);
        return this.client.search(searchRequest, this.options);
    }

    public final SearchResponse search(Class clazz, SearchSourceBuilder searchSourceBuilder) throws IOException {
        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz, searchSourceBuilder);
        return this.search(searchRequest);
    }

    public final SearchResponse search(Class clazz, Date date, SearchSourceBuilder searchSourceBuilder) throws IOException {
        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz, date, searchSourceBuilder);
        return this.search(searchRequest);
    }

    public final SearchResponse search(Class clazz, Date startDate, Date endDate, SearchSourceBuilder searchSourceBuilder) throws IOException {
        SearchRequest searchRequest = ESRequestFactory.getSearchRequest(clazz, startDate, endDate, searchSourceBuilder);
        return this.search(searchRequest);
    }

    public final IndicesClient indices() {
        return this.client.indices();
    }

    public final boolean exists(GetIndexRequest getIndexRequest) throws IOException {
        return this.client.indices().exists(getIndexRequest, this.options);
    }

    public final AcknowledgedResponse create(CreateIndexRequest createIndexRequest) throws IOException {
        return this.client.indices().create(createIndexRequest, this.options);
    }

    public final AcknowledgedResponse putMapping(PutMappingRequest putMappingRequest) throws IOException {
        return this.client.indices().putMapping(putMappingRequest, this.options);
    }

    public final BulkByScrollResponse updateByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        return this.client.updateByQuery(updateByQueryRequest, this.options);
    }

    public final BulkByScrollResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        return this.client.deleteByQuery(deleteByQueryRequest, this.options);
    }
}

