package com.viontech.keliu.chart.axis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.Chart;

import java.util.ArrayList;
import java.util.List;

public abstract class AxisBase<T> implements Axis<T> {
	T min;
	T max;
	Integer scale;
	String unit;
	private boolean lock = false;
	protected boolean lockMinMax = false;
	protected Chart<T> chart;
	List<String> data_raw = new ArrayList<>();
	List<String> data = new ArrayList<>();
	List<String> hideData = new ArrayList<>();

	public void lockMinMax(){
		lockMinMax = true;
	}

	@JsonIgnore
	public T getMin() {
		return min;
	}
	public void setMin(T min) {
		this.min = min;
	}
	@JsonIgnore
	public T getMax() {
		return max;
	}
	public void setMax(T max) {
		this.max = max;
	}
	
	public Integer getScale() {
		return scale;
	}
	public void setScale(Integer scale) {
		this.scale = scale;
	}
	public List<String> getData() {
		return data;
	}
	public void setData(List<String> data) {
		this.data = data;
	}

	@JsonIgnore
	public List<String> getData_raw() {
		return data_raw;
	}

	public void setData_raw(List<String> data_raw) {
		this.data_raw = data_raw;
	}

	@JsonIgnore
	public List<String> getHideData() {
		return hideData;
	}

	public void setHideData(List<String> hideData) {
		this.hideData = hideData;
	}
	@Override
	@JsonIgnore
	public int getLength() {
		return getData().size();
	}
	@Override
	public void addData(T... t) {
		for (T t2 : t) {
			this.addData(t2);
		}
	}
	@Override
	public void addHideData(T t) {
		hideData.add((String) t);
	}

	@Override
	@JsonIgnore
	public Chart getChart() {
		return chart;
	}
	@Override
	public void setChart(Chart chart) {
		this.chart = chart;
	}
	@Override
	public List subData(int fromIndex, int toIndex) {
		toIndex = toIndex > data.size() ? data.size() : toIndex;
		data = data.subList(fromIndex, toIndex);
		return data;
	}
	@Override
	public List removeData(int index){
		if (index >= data.size())
			return  data;
		data.remove(index);
		return  data;
	}

	@Override
	public boolean valueExChange(int index1, int index2) {
		if(index1 < 0 || index2 < 0){
			return false;
		}
		if(index1 >= data.size() || index2 >= data.size()){
			return false;
		}
		String value1 = data.get(index1);
		String value2 = data.get(index2);
		data.set(index1, value2);
		data.set(index2,value1);
		return true;
	}
	
}
