/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.series.Bar;
import com.viontech.keliu.chart.series.Line;
import com.viontech.keliu.chart.series.Pie;
import com.viontech.keliu.chart.series.Radar;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.Scatter;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chart<T> {
    protected String title;
    protected String chartKey;
    private Axis xAxis;
    private Axis yAxis;
    protected List<Series> series;
    protected Map<String, Series> seriesMap = new HashMap<String, Series>();
    protected SeriesType defaultSeriesType;
    public static final int CALC_TYPE_SUM = 0;
    public static final int CALC_TYPE_AVG = 1;
    protected TIntArrayList calcTypes;
    protected int startIndex;
    protected int endIndex;
    protected Integer pageTotal;

    public Chart(String title, SeriesType defaulType) {
        this.series = new ArrayList<Series>();
        this.title = title;
        this.defaultSeriesType = defaulType;
    }

    public boolean putValue(String seriesName, Object coordinate, T value) {
        Series series = this.getOrCreatIfNeed(seriesName, null);
        return series.putValueByCoordinate(coordinate, value);
    }

    public boolean putValue(String seriesName, String stack, Object coordinate, T value) {
        Series series = this.getOrCreatIfNeed(seriesName, stack);
        return series.putValueByCoordinate(coordinate, value);
    }

    public boolean adjustOrPutValue(String seriesName, Object coordinate, T value) {
        Series series = this.getOrCreatIfNeed(seriesName, null);
        return series.adjustOrPutValueByCoordinate(coordinate, value);
    }

    public boolean adjustOrPutValue(Object coordinate, T value) {
        for (Map.Entry<String, Series> entry : this.seriesMap.entrySet()) {
            entry.getValue().adjustOrPutValueByCoordinate(coordinate, value);
        }
        return true;
    }

    public boolean adjustOrPutValue(String seriesName, String stack, Object coordinate, T value) {
        Series series = this.getOrCreatIfNeed(seriesName, stack);
        return series.adjustOrPutValueByCoordinate(coordinate, value);
    }

    public void setCalcTypeByCoordinate(Object coordinate, int calcType) {
        this.setCalcTypeByIndex(this.getIndexByCoordinate(coordinate), calcType);
    }

    public void setCalcTypeByIndex(int index, int calcType) {
        int i;
        if (this.calcTypes == null) {
            this.calcTypes = new TIntArrayList();
            for (i = 0; i < (this.getAxis() == null ? 0 : this.getAxis().getLength()); ++i) {
                this.calcTypes.add(0);
            }
        }
        if (index > this.calcTypes.size()) {
            for (i = this.calcTypes.size(); i < index + 1; ++i) {
                this.calcTypes.add(0);
            }
        }
        this.calcTypes.set(index, calcType);
    }

    public Integer getCalcTypeByCoordinate(Object coordinate) {
        return this.getCalcTypeByIndex(this.getIndexByCoordinate(coordinate));
    }

    public int getIndexByCoordinate(Object coordinate) {
        int index = 0;
        if (this.xAxis != null) {
            index = this.xAxis.getIndexByCoordinate(coordinate);
        } else if (this.yAxis != null) {
            index = this.yAxis.getIndexByCoordinate(coordinate);
        }
        if (index < this.getStartIndex()) {
            this.setStartIndex(index);
        }
        if (index > this.getEndIndex()) {
            this.setEndIndex(index);
        }
        return index;
    }

    public Integer getCalcTypeByIndex(int index) {
        if (this.calcTypes == null) {
            return 0;
        }
        if (index >= this.calcTypes.size()) {
            return 0;
        }
        return this.calcTypes.get(index);
    }

    public void setAllCalcType(Integer calcType) {
        int i;
        if (this.calcTypes == null) {
            this.calcTypes = new TIntArrayList();
            for (i = 0; i < (this.getAxis() == null ? 0 : this.getAxis().getLength()); ++i) {
                this.calcTypes.add(0);
            }
        }
        for (i = 0; i < this.calcTypes.size(); ++i) {
            this.calcTypes.set(i, calcType.intValue());
        }
    }

    public Series getOrCreatIfNeed(String seriesName, String stack) {
        Series seriesVal = this.seriesMap.get(seriesName);
        if (seriesVal == null) {
            seriesVal = this.createSeries(seriesName, stack, null);
        }
        return seriesVal;
    }

    public Series createSeries(String seriesName) {
        return this.createSeries(seriesName, null, null);
    }

    public Series getSeries(String seriesName) {
        Series s = this.seriesMap.get(seriesName);
        if (s == null) {
            s = this.getOrCreatIfNeed(seriesName, null);
        }
        return s;
    }

    public Series createSeries(String seriesName, SeriesType seriesType) {
        return this.createSeries(seriesName, null, seriesType);
    }

    public Series createSeries(String seriesName, String stack, SeriesType seriesType) {
        if (seriesType == null) {
            seriesType = this.defaultSeriesType;
        }
        Series result = null;
        switch (seriesType) {
            case bar: {
                result = new Bar(seriesName, stack, this);
                break;
            }
            case line: {
                result = new Line(seriesName, stack, this);
                break;
            }
            case pie: {
                result = new Pie(seriesName, this);
                break;
            }
            case table: {
                result = new Row(seriesName, this);
                break;
            }
            case scatter: {
                result = new Scatter(seriesName, this);
                break;
            }
            case radar: {
                result = new Radar(seriesName, this);
                break;
            }
        }
        Axis axis = this.getAxis();
        if (axis != null && axis.getLength() > 0) {
            result.putValueByIndex(axis.getData().size() - 1, null);
        }
        this.series.add(result);
        this.seriesMap.put(seriesName, result);
        return result;
    }

    @JsonIgnore
    public void sort(String seriesName, Comparator comparator) {
        Series series = this.getSeries(seriesName);
        series.sort(comparator, this.getAxis());
    }

    @JsonIgnore
    public void sort(Comparator<Series> comparator) {
        Collections.sort(this.series, comparator);
    }

    @JsonIgnore
    public void subData(int beginIndex, int endIndex) {
        this.getAxis().subData(beginIndex, endIndex);
        for (Series serie : this.series) {
            serie.subvalue(beginIndex, endIndex);
        }
    }

    public void removeChartHideCol() {
        Axis axis = this.getAxis();
        if (axis == null) {
            return;
        }
        List<String> axis_hideData = axis.getHideData();
        if (axis_hideData == null || axis_hideData.size() <= 0) {
            return;
        }
        List<String> data_raw = axis.getData_raw();
        if (data_raw == null || data_raw.size() <= 0) {
            return;
        }
        for (Series seriesCol : this.series) {
            seriesCol.getData();
            ArrayList<String> axis_data = new ArrayList<String>();
            axis_data.addAll(data_raw);
            for (String hideCol : axis_hideData) {
                int index = axis_data.indexOf(hideCol);
                axis_data.remove(hideCol);
                seriesCol.removeValue(index);
            }
        }
        List<String> data = axis.getData();
        if (data == null || data.size() <= 0) {
            return;
        }
        for (String hideCol : axis_hideData) {
            data.remove(hideCol);
        }
    }

    public T calcValue(int index, List<T> data_raw) {
        return this.calcValue(null, index, data_raw);
    }

    public T calcValue(String name, int index, List<T> data_raw) {
        return data_raw.get(index);
    }

    public List<Series> getSeries() {
        return this.series;
    }

    public void setSeries(List<Series> series) {
        for (Series s : series) {
            this.seriesMap.put(s.getName(), s);
        }
        this.series = series;
    }

    @JsonIgnore
    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    @JsonIgnore
    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public Axis getAxis() {
        if (this.xAxis != null) {
            return this.xAxis;
        }
        if (this.yAxis != null) {
            return this.yAxis;
        }
        return null;
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(Axis xAxis) {
        this.xAxis = xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(Axis yAxis) {
        this.yAxis = yAxis;
    }

    public String getChartKey() {
        return this.chartKey;
    }

    public void setChartKey(String chartKey) {
        this.chartKey = chartKey;
    }

    public Integer getPageTotal() {
        return this.pageTotal;
    }

    public void setPageTotal(Integer pageTotal) {
        this.pageTotal = pageTotal;
    }
}

