/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart.series;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Series {
    public static final int CALC_TYPE_SUM = 0;
    public static final int CALC_TYPE_AVG = 1;
    private String name;
    private String stack;
    protected Chart chart;
    protected List data_raw = new ArrayList();
    protected List data = null;
    protected TIntList counts;
    protected TIntList calcTypes;

    public Series(String name, String stack, Chart chart) {
        this.name = name;
        this.stack = stack;
        this.chart = chart;
    }

    public Series(String name, Chart chart) {
        this(name, null, chart);
    }

    public Series(Chart chart) {
        this(null, null, chart);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract String getType();

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public void putValue(Object value) {
        this.putValueByCoordinate("data", value);
    }

    public void adjustOrPutValue(Object value) {
        this.adjustOrPutValueByCoordinate("data", value);
    }

    @JsonIgnore
    public Object getValue() {
        return this.getValueByCoordinate("data");
    }

    public Object getValueByCoordinate(Object coordinate) {
        if (coordinate == null) {
            throw new RuntimeException("\u5750\u6807\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.getValueByIndex(this.getIndexByCoordinate(coordinate));
    }

    public Object getValueByIndex(int index) {
        if (index >= this.data_raw.size()) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        return this.data_raw.get(index);
    }

    public boolean putValueByCoordinate(Object coordinate, Object value) {
        if (coordinate == null) {
            throw new RuntimeException("\u5750\u6807\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int index = this.getIndexByCoordinate(coordinate);
        if (index > -1) {
            return this.putValueByIndex(index, value);
        }
        return false;
    }

    public boolean putValueByIndex(int index, Object value) {
        if (index < 0) {
            return false;
        }
        if (index >= this.data_raw.size()) {
            for (int i = this.data_raw.size(); i <= index; ++i) {
                this.data_raw.add(null);
            }
        }
        this.data_raw.set(index, value);
        return true;
    }

    public boolean adjustOrPutValueByCoordinate(Object coordinate, Object value) {
        return this.adjustOrPutValueByIndex(this.getIndexByCoordinate(coordinate), value);
    }

    protected final boolean adjustOrPutValueByIndex(int index, Object value) {
        if (index < 0) {
            return false;
        }
        return this.adjustOrPutValueByIndex2(index, value);
    }

    protected abstract boolean adjustOrPutValueByIndex2(int var1, Object var2);

    @JsonIgnore
    protected abstract int getIndexByCoordinate(Object var1);

    protected boolean isAvg(int index) {
        return this.getCalcTypeByIndex(index) != null && this.getCalcTypeByIndex(index) == 1;
    }

    public boolean valueExChange(int index1, int index2) {
        Object value2;
        Object value1;
        if (index1 < 0 || index2 < 0) {
            return false;
        }
        if (index1 >= this.getLength() || index2 >= this.getLength()) {
            return false;
        }
        if (this.data_raw != null) {
            value1 = this.data_raw.get(index1);
            value2 = this.data_raw.get(index2);
            this.data_raw.set(index1, value2);
            this.data_raw.set(index2, value1);
        }
        if (this.data != null) {
            value1 = this.data.get(index1);
            value2 = this.data.get(index2);
            this.data.set(index1, value2);
            this.data.set(index2, value1);
        }
        if (this.counts != null) {
            int value12 = this.counts.get(index1);
            int value22 = this.counts.get(index2);
            this.counts.set(index1, value22);
            this.counts.set(index2, value12);
        }
        return true;
    }

    public boolean subvalue(int fromIndex, int toIndex) {
        if (this.data == null) {
            this.calcResultValues();
        }
        if (this.data_raw != null && toIndex > this.data_raw.size()) {
            toIndex = this.data_raw.size();
        }
        this.data_raw = this.data_raw.subList(fromIndex, toIndex);
        if (this.data != null && toIndex > this.data.size()) {
            toIndex = this.data.size();
        }
        this.data = this.data.subList(fromIndex, toIndex);
        if (this.counts != null) {
            if (toIndex > this.counts.size()) {
                toIndex = this.counts.size();
            }
            this.counts = this.counts.subList(fromIndex, toIndex);
        }
        return true;
    }

    public boolean removeValue(int index) {
        if (this.data != null) {
            if (index >= this.data.size()) {
                return true;
            }
            this.data.remove(index);
        }
        return true;
    }

    public List getData() {
        if (this.data == null) {
            this.calcResultValues();
        }
        return this.data;
    }

    @JsonIgnore
    public List getRawData() {
        return this.data_raw;
    }

    public int dataSize() {
        if (this.data_raw == null) {
            return 0;
        }
        return this.data_raw.size();
    }

    public void calcResultValues() {
        int i;
        this.data = new ArrayList(this.data_raw);
        boolean needFill = false;
        for (i = this.data.size() - 1; i >= 0; --i) {
            if (this.data.get(i) != null) {
                needFill = true;
            }
            if (!needFill || this.data.get(i) != null) continue;
            this.data.set(i, 0);
        }
        for (i = 0; i < this.data_raw.size(); ++i) {
            Object value = this.data_raw.get(i);
            Integer count = this.getCountByIndex(i);
            if (value != null && this.isAvg(i) && count != null) {
                this.data.set(i, this.calcAvg(value, count));
            }
            this.data.set(i, this.chart.calcValue(this.getName(), i, this.data));
        }
    }

    protected Number numberConverter(Number number, Class targetClass) {
        if (targetClass.equals(Double.class)) {
            return new Double(number.toString());
        }
        if (targetClass.equals(Integer.class)) {
            return new Double(number.toString()).intValue();
        }
        if (targetClass.equals(Float.class)) {
            return Float.valueOf(new Double(number.toString()).floatValue());
        }
        if (targetClass.equals(Long.class)) {
            return new Double(number.toString()).longValue();
        }
        return number;
    }

    protected Object calcAvg(Object value, Integer count) {
        if (!(value instanceof Number) || count == 0) {
            return value;
        }
        double result = new BigDecimal(value.toString()).divide(new BigDecimal(count), 2).doubleValue();
        return this.numberConverter(result, value.getClass());
    }

    protected void setCountByIndex(int index, int count) {
        int i;
        if (this.counts == null) {
            this.counts = new TIntArrayList();
            for (i = 0; i < (this.chart.getAxis() == null ? 0 : this.chart.getAxis().getLength()); ++i) {
                this.counts.add(0);
            }
        }
        for (i = this.counts.size(); i < index + 1; ++i) {
            this.counts.add(0);
        }
        this.counts.set(index, count);
    }

    public void setCountByCoordinate(Object coordinate, Integer count) {
        this.setCountByIndex(this.getIndexByCoordinate(coordinate), count);
    }

    public Integer getCountByIndex(int index) {
        if (this.counts == null || index >= this.counts.size() || index < 0) {
            return null;
        }
        return this.counts.get(index);
    }

    public Integer getCountByCoordinate(Object coordinate) {
        return this.getCountByIndex(this.getIndexByCoordinate(coordinate));
    }

    public void setCalcTypeByCoordinate(Object coordinate, int calcType) {
        this.setCalcTypeByIndex(this.getIndexByCoordinate(coordinate), calcType);
    }

    public void setAllCalcType(Integer calcType) {
        for (int i = 0; i < this.dataSize(); ++i) {
            this.setCalcTypeByIndex(i, calcType);
        }
    }

    protected void setCalcTypeByIndex(int index, int calcType) {
        int i;
        if (this.calcTypes == null) {
            this.calcTypes = new TIntArrayList();
            for (i = 0; i < this.dataSize(); ++i) {
                this.calcTypes.add(0);
            }
        }
        for (i = this.calcTypes.size(); i < index + 1; ++i) {
            this.calcTypes.add(0);
        }
        this.calcTypes.set(index, calcType);
    }

    public Integer getCalcTypeByCoordinate(Object coordinate) {
        return this.getCalcTypeByIndex(this.getIndexByCoordinate(coordinate));
    }

    protected Integer getCalcTypeByIndex(int index) {
        if (this.calcTypes == null) {
            return 0;
        }
        if (index >= this.calcTypes.size()) {
            return 0;
        }
        return this.calcTypes.get(index);
    }

    @JsonIgnore
    protected int getLength() {
        return this.data_raw.size();
    }

    public void sort(Comparator comparator, Axis axis) {
        this.calcResultValues();
        for (int i = 0; i < this.data.size() - 1; ++i) {
            for (int j = 0; j < this.data.size() - i - 1; ++j) {
                int result = comparator.compare(this.data.get(j), this.data.get(j + 1));
                if (result >= 0) continue;
                this.valueExChange(j, j + 1);
                axis.valueExChange(j, j + 1);
            }
        }
    }
}

