/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart.excel;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.model.PieData;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class ChartExcel {
    private Chart chart;
    private static final int colsizeN = 630;
    private static final int colsizeM = 1000;

    public ChartExcel(Chart chart) {
        this.chart = chart;
    }

    public InputStream creatExcelInputStream() {
        Map<String, Object> excelData = this.getExcelData();
        return this.Data2Excel(excelData);
    }

    private Map<String, Object> getExcelData() {
        HashMap<String, Object> excelMap = new HashMap<String, Object>();
        String title = this.chart.getTitle();
        excelMap.put("title", title);
        LinkedList<Object> heads = new LinkedList<Object>();
        LinkedHashMap<Object, List> rows = new LinkedHashMap<Object, List>();
        Axis axis = this.chart.getAxis();
        List<Object> axisList = new ArrayList();
        if (axis != null) {
            axisList = axis.getData();
        }
        List<Series> series = this.chart.getSeries();
        boolean flag = true;
        for (int i = 0; i < series.size(); ++i) {
            List<Object> rowList;
            Object name;
            int j;
            List data;
            Series serie = series.get(i);
            String serieName = serie.getName();
            String type = serie.getType();
            if (SeriesType.pie.name().equals(type)) {
                if (flag) {
                    heads.add("\\");
                    flag = false;
                }
                if (!heads.contains(serieName)) {
                    heads.add(serieName);
                }
                data = serie.getData();
                for (j = 0; j < data.size(); ++j) {
                    name = ((PieData)data.get(j)).getName();
                    rowList = (ArrayList<Object>)rows.get(name);
                    if (rowList == null) {
                        rowList = new ArrayList<Object>();
                        rowList.add(name);
                    }
                    Object value = ((PieData)data.get(j)).getValue();
                    rowList.add(value);
                    rows.put(name, rowList);
                }
                continue;
            }
            if (SeriesType.table.name().equals(type)) {
                data = serie.getData();
                String name2 = serie.getName();
                rows.put(name2, data);
                if (heads.size() > 0) continue;
                heads.addAll(axisList);
                continue;
            }
            if (flag) {
                heads.add("\\");
                flag = false;
            }
            if (!heads.contains(serieName)) {
                heads.add(serieName);
            }
            data = serie.getData();
            for (j = 0; j < data.size(); ++j) {
                name = (String)axisList.get(j);
                rowList = (List)rows.get(name);
                if (rowList == null) {
                    rowList = new ArrayList();
                    rowList.add(name);
                }
                rowList.add(data.get(j));
                rows.put(name, rowList);
            }
        }
        excelMap.put("heads", heads);
        excelMap.put("rows", rows);
        return excelMap;
    }

    public InputStream Data2Excel(Map<String, Object> excelMap) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont font = wb.createFont();
            font.setBold(true);
            font.setFontHeight((short)400);
            titleStyle.setFont(font);
            HSSFCell titleCell = sheet.createRow(0).createCell(0);
            String title = (String)excelMap.get("title");
            titleCell.setCellValue((RichTextString)new HSSFRichTextString(title));
            titleCell.setCellStyle(titleStyle);
            HSSFRow headRow = sheet.createRow(1);
            int colSzie = 0;
            HSSFCellStyle headStyle = wb.createCellStyle();
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            HSSFFont headFont = wb.createFont();
            headFont.setBold(true);
            headFont.setFontHeight((short)240);
            headStyle.setFont(headFont);
            List heads = (List)excelMap.get("heads");
            Map rows = (Map)excelMap.get("rows");
            for (int i = 0; i < heads.size(); ++i) {
                String head = (String)heads.get(i);
                HSSFCell cell = headRow.createCell(i);
                cell.setCellValue((RichTextString)new HSSFRichTextString(head));
                cell.setCellStyle(headStyle);
                ++colSzie;
                sheet.autoSizeColumn((int)((short)i));
                sheet.setColumnWidth(i, head.length() * 630 + 1000);
            }
            HSSFCellStyle cellStyle = wb.createCellStyle();
            int i = 0;
            for (Object datas : rows.values()) {
                HSSFRow row = sheet.createRow(i + 2);
                List rowData = (List)datas;
                for (int j = 0; j < rowData.size(); ++j) {
                    HSSFCell cell = row.createCell(j);
                    Object cellValue = rowData.get(j);
                    if (cellValue == null) {
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("--");
                        continue;
                    }
                    Boolean isNum = false;
                    Boolean isInteger = false;
                    Boolean isPercent = false;
                    if (cellValue != null || "".equals(cellValue)) {
                        isNum = cellValue.toString().matches("^(-?\\d+)(\\.\\d+)?$");
                        isInteger = cellValue.toString().matches("^[-\\+]?[\\d]*$");
                        isPercent = cellValue.toString().contains("%");
                    }
                    if (isNum.booleanValue() && !isPercent.booleanValue() && cellValue != null) {
                        HSSFDataFormat df = wb.createDataFormat();
                        if (isInteger.booleanValue()) {
                            cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,#0"));
                        } else {
                            cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0.00"));
                        }
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(Double.parseDouble("" + cellValue));
                        continue;
                    }
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue("" + cellValue);
                }
                ++i;
            }
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colSzie - 1));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                wb.write((OutputStream)os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] b = os.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(b);
            return in;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

