/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.chart.axis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viontech.keliu.chart.axis.AxisBase;
import com.viontech.keliu.chart.exception.AxisLockException;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateAxis
extends AxisBase<Date> {
    private String sdfStr = null;
    private int scaleType = 11;

    public DateAxis(int scaleType) {
        this.scaleType = scaleType;
    }

    public DateAxis(String sdfStr, int scaleType) {
        this.sdfStr = sdfStr;
        this.scaleType = scaleType;
    }

    @Override
    public List<String> getData() {
        if (this.data.size() > 0) {
            return this.data;
        }
        this.lock();
        if (this.sdfStr == null) {
            this.sdfStr = this.getSimpleDateFormatStr();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.getMin());
        while (!cal.getTime().after((Date)this.getMax())) {
            if (this.scaleType == 4) {
                this.data.add(String.valueOf(DateUtil.getWeekOfMonth((Date)cal.getTime())));
            } else if (this.scaleType == 3) {
                int weekOfYear = DateUtil.getWeekOfYear((Date)cal.getTime());
                this.data.add(String.valueOf(LocalMessageUtil.getMessage((String)"weekOfyearStrFormat", (Object[])new Object[]{weekOfYear})));
            } else {
                this.data.add(DateUtil.format((String)this.sdfStr, (Date)cal.getTime()));
            }
            cal.add(this.scaleType, this.scale == null ? 1 : this.scale);
        }
        return this.data;
    }

    @Override
    public void setMin(Date startDate) {
        if (this.lockMinMax) {
            return;
        }
        if (this.isLock()) {
            throw new AxisLockException("x\u8f74\u5df2\u88ab\u9501\u5b9a");
        }
        if (this.min == null) {
            this.min = startDate;
        } else {
            if (this.scaleType == 3) {
                try {
                    startDate = DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)startDate));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (startDate.before((Date)this.getMin())) {
                    this.min = startDate;
                }
                return;
            }
            if (this.sdfStr == null || this.sdfStr.length() <= 0) {
                this.sdfStr = this.getSimpleDateFormatStr();
            }
            try {
                startDate = DateUtil.parse((String)this.sdfStr, (String)DateUtil.format((String)this.sdfStr, (Date)startDate));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (startDate.before((Date)this.getMin())) {
                this.min = startDate;
            }
        }
    }

    @Override
    public void setMax(Date endDate) {
        if (this.lockMinMax) {
            return;
        }
        if (this.isLock()) {
            throw new AxisLockException("x\u8f74\u5df2\u88ab\u9501\u5b9a");
        }
        if (this.max == null) {
            this.max = endDate;
        } else {
            if (this.scaleType == 3) {
                try {
                    endDate = DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)endDate));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (endDate.after((Date)this.getMax())) {
                    this.max = endDate;
                }
                return;
            }
            if (this.sdfStr == null || this.sdfStr.length() <= 0) {
                this.sdfStr = this.getSimpleDateFormatStr();
            }
            try {
                endDate = DateUtil.parse((String)this.sdfStr, (String)DateUtil.format((String)this.sdfStr, (Date)endDate));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (endDate.after((Date)this.getMax())) {
                this.max = endDate;
            }
        }
    }

    @JsonIgnore
    public String getSimpleDateFormatStr() {
        Date startDate = (Date)this.getMin();
        Date endDate = (Date)this.getMax();
        StringBuilder sb = new StringBuilder();
        if (1 == this.scaleType) {
            sb.append("yyyy");
        }
        if (2 == this.scaleType) {
            if (startDate != null && endDate != null && !DateUtil.isSameYear((Date)startDate, (Date)endDate)) {
                sb.append("yyyy-");
            }
            sb.append("MM");
        }
        if (5 == this.scaleType) {
            if (startDate != null && endDate != null && !DateUtil.isSameYear((Date)startDate, (Date)endDate)) {
                sb.append("yyyy-");
            }
            if (startDate != null && endDate != null && !DateUtil.isSameMonth((Date)startDate, (Date)endDate)) {
                sb.append("MM-");
            }
            sb.append("dd(E)");
        }
        if (11 == this.scaleType) {
            if (startDate != null && endDate != null && !DateUtil.isSameYear((Date)startDate, (Date)endDate)) {
                sb.append("yyyy-");
            }
            if (startDate != null && endDate != null && !DateUtil.isSameMonth((Date)startDate, (Date)endDate)) {
                sb.append("MM-");
            }
            if (startDate != null && endDate != null && !DateUtil.isSameDay((Date)startDate, (Date)endDate)) {
                sb.append("dd ");
            }
            sb.append("HH:00");
        }
        if (12 == this.scaleType) {
            if (startDate != null && endDate != null && !DateUtil.isSameYear((Date)startDate, (Date)endDate)) {
                sb.append("yyyy-");
            }
            if (startDate != null && endDate != null && !DateUtil.isSameMonth((Date)startDate, (Date)endDate)) {
                sb.append("MM-");
            }
            if (startDate != null && endDate != null && !DateUtil.isSameDay((Date)startDate, (Date)endDate)) {
                sb.append("dd ");
            }
            if (startDate != null && endDate != null && !DateUtil.isSameHour((Date)startDate, (Date)endDate)) {
                sb.append("HH:");
            }
            sb.append("mm");
        }
        if (7 == this.scaleType) {
            this.sdfStr = DateUtil.FORMAT_DAY_OF_WEEK_SORT_CN;
            return this.sdfStr;
        }
        if (3 == this.scaleType) {
            this.sdfStr = DateUtil.FORMAT_WEEK_OF_YEAR;
            return this.sdfStr;
        }
        this.sdfStr = sb.toString();
        return this.sdfStr;
    }

    @Override
    public void lock() {
    }

    @Override
    @JsonIgnore
    public boolean isLock() {
        return false;
    }

    public void setDateFormatStr(String dateFormatStr) {
        this.sdfStr = dateFormatStr;
    }

    @Override
    public int getIndexByCoordinate(Date date) {
        Object coor = date;
        if (date != null) {
            if (this.sdfStr == null) {
                this.sdfStr = this.getSimpleDateFormatStr();
            }
            if (this.scaleType == 4) {
                coor = String.valueOf(DateUtil.getWeekOfMonth((Date)date));
            } else if (this.scaleType == 3) {
                int weekOfYear = DateUtil.getWeekOfYear((Date)date);
                coor = String.valueOf(LocalMessageUtil.getMessage((String)"weekOfyearStrFormat", (Object[])new Object[]{weekOfYear}));
            } else if (this.scaleType == 12 && this.scale > 1) {
                Calendar instance = Calendar.getInstance();
                instance.setTime(date);
                int minute = instance.get(12);
                minute = minute / this.scale * this.scale;
                instance.set(12, minute);
                coor = DateUtil.format((String)this.sdfStr, (Date)instance.getTime());
            } else {
                coor = DateUtil.format((String)this.sdfStr, (Date)date);
            }
        }
        return this.getData().indexOf(coor);
    }

    @Override
    public void addData(Date t) {
        this.data = new ArrayList();
        this.setMin(t);
        this.setMax(t);
    }
}

